/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.utilities.ccd.CornerRaft;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.RaftGeometryConstants;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.location.Location;

public class FocalPlane
extends Geometry<Raft> {
    private static final int GAP_BETWEEN_RAFTS = 50;
    private static final int S_BAYS = 5;
    private static final int P_BAYS = 5;
    private static final RaftGeometryConstants RAFT_GEOMETRY_CONSTANTS = RaftGeometryConstants.createRaftGeometryConstants(new E2VCCDType());

    public FocalPlane() {
        super("FocalPlane", new Dimension(5 * RAFT_GEOMETRY_CONSTANTS.getRaftx() + 200, 5 * RAFT_GEOMETRY_CONSTANTS.getRafty() + 200), 5, 5);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public FocalPlane(String definition) {
        this();
        if (definition.isEmpty()) {
            for (int p = 0; p < 5; ++p) {
                for (int s = 0; s < 5; ++s) {
                    Raft raft = FocalPlane.isCornerRaft(p, s) ? CornerRaft.createCornerRaft(FocalPlane.getCornerRaftPosition(p, s)) : Raft.createRaft("");
                    this.addChildGeometry(raft, p, s);
                }
            }
        } else if ("AUXTEL".equals(definition)) {
            CornerRaft raft = CornerRaft.createAuxtelRaft();
            this.addChildGeometry(raft, 0, 0);
        } else {
            List rafts = (List)InputConversionEngine.convertArgToType((String)definition, List.class);
            for (String raftStr : rafts) {
                if (!(raftStr = raftStr.trim()).startsWith("R")) {
                    throw new IllegalArgumentException("Illegal raft definition: " + raftStr + "; it must start with the raft name in the form Rij");
                }
                try {
                    int parallelPosition = Integer.parseInt(raftStr.substring(1, 2));
                    int serialPosition = Integer.parseInt(raftStr.substring(2, 3));
                    String raftDefinition = raftStr.length() > 4 ? raftStr.substring(4) : "";
                    Raft raft = FocalPlane.isCornerRaft(parallelPosition, serialPosition) ? CornerRaft.createCornerRaft(FocalPlane.getCornerRaftPosition(parallelPosition, serialPosition)) : Raft.createRaft(raftDefinition.trim());
                    this.addChildGeometry(raft, parallelPosition, serialPosition);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not create a Raft for definition " + raftStr, e);
                }
            }
        }
    }

    @Override
    protected void addGeometryToGrid(Raft child, int p, int s) {
        if (FocalPlane.isCornerRaft(p, s)) {
            if (!(child instanceof CornerRaft)) {
                throw new RuntimeException("Only CornerRafts can be added to the corners of the focal plane.");
            }
            CornerRaft cr = (CornerRaft)child;
            if (cr.getCornerRaftPosition().getParallelPosition() != p || cr.getCornerRaftPosition().getSerialPosition() != s) {
                throw new RuntimeException("CornerRaft for position " + cr.getCornerRaftPosition() + " cannot be added to focal plane in bay (" + p + "," + s + ")");
            }
        }
        int yCoord = s * (child.getHeight() + 50);
        int xCoord = p * (child.getWidth() + 50);
        this.addGeometry(child, xCoord, yCoord);
    }

    public List<Raft> getRafts() {
        return this.getChildrenList();
    }

    public List<Reb> getRebs() {
        ArrayList<Reb> rebs = new ArrayList<Reb>();
        for (Raft r : this.getRafts()) {
            rebs.addAll(r.getRebs());
        }
        return rebs;
    }

    public Reb getReb(String fullName) {
        for (Reb reb : this.getRebs()) {
            if (!reb.getFullName().equals(fullName)) continue;
            return reb;
        }
        throw new RuntimeException("Could not find reb " + fullName + " among (" + this.getRebs() + ")");
    }

    public Reb getRebAtLocation(Location location) {
        for (Reb reb : this.getRebs()) {
            if (!reb.getLocation().equals(location)) continue;
            return reb;
        }
        throw new RuntimeException("Could not find reb at location " + location + " among (" + this.getRebs() + ")");
    }

    public static FocalPlane createFocalPlane(String definition) {
        FocalPlane fp = new FocalPlane(definition);
        return fp;
    }

    public static FocalPlane createFocalPlane() {
        return FocalPlane.createFocalPlane("");
    }

    private static boolean isCornerRaft(int p, int s) {
        return p == 0 && (s == 0 || s == 4) || p == 4 && (s == 0 || s == 4);
    }

    private static CornerRaft.CornerRaftPosition getCornerRaftPosition(int p, int s) {
        for (CornerRaft.CornerRaftPosition position : CornerRaft.CornerRaftPosition.values()) {
            if (position.getParallelPosition() != p || position.getSerialPosition() != s) continue;
            return position;
        }
        throw new IllegalArgumentException("Could not find a CornerRaftPosition corresponding to (" + p + "," + s + ")");
    }

    static boolean isCornerRaft(String raftStr) {
        int parallelPosition = Integer.parseInt(raftStr.substring(1, 2));
        int serialPosition = Integer.parseInt(raftStr.substring(2, 3));
        return FocalPlane.isCornerRaft(parallelPosition, serialPosition);
    }
}

