/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePWM;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePulse;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.drivers.modbus.TestModbus;

public class TestMaq20
extends TestModbus {
    private static final Map<Integer, String> funcDescs = new HashMap<Integer, String>();
    private static final Map<Integer, String> timebaseDescs;
    private final Maq20 maq;

    public TestMaq20() {
        super(new Maq20());
        this.maq = (Maq20)this.mod;
    }

    @Override
    @Command(description="Open connection to general device")
    public void open(@Argument(name="type", description="Connection type") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident) throws DriverException {
        super.open(type, ident);
    }

    @Override
    @Command(description="Open connection to general device")
    public void open(@Argument(name="type", description="Connection type") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param", description="Device parameter") int param) throws DriverException {
        super.open(type, ident, param);
    }

    @Override
    @Command(description="Open connection to serial device")
    public void open(@Argument(name="type", description="Connection type: net, serial") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="baud", description="Baud rate") int baud, @Argument(name="dbits", description="The number of data bits") Ascii.DataBits dbits, @Argument(name="sbits", description="The number of stop bits") Ascii.StopBits sbits, @Argument(name="parity", description="The parity") Ascii.Parity parity, @Argument(name="flow", description="The flow control") Ascii.FlowCtrl flow) throws DriverException {
        super.open(type, ident, baud, dbits, sbits, parity, flow);
    }

    @Command(description="Open connection to USB device")
    public void openUsb(@Argument(name="serial", description="Serial number") String serial) throws DriverException {
        this.maq.openUsb(serial);
    }

    @Command(description="Initialize simulation")
    public void initSimulation(Maq20.ModuleType ... modTypes) throws DriverException {
        String[] serials = new String[modTypes.length];
        for (int j = 0; j < serials.length; ++j) {
            serials[j] = String.format("%04d", j);
        }
        this.maq.initSimulation(modTypes, serials);
    }

    @Command(description="Set simulated channel value")
    public void setSimChannelValue(@Argument(name="modId", description="Module ID") int modId, @Argument(name="channel", description="Channel number") int chan, @Argument(name="value", description="Channel value") double value) throws DriverException {
        this.maq.setSimChannelValue(modId, chan, value);
    }

    @Command(description="Register modules")
    public void register(String ... serial) throws DriverException {
        this.maq.register(serial);
    }

    @Command(description="Show the IP address")
    public String showIPAddress() throws DriverException {
        return "IP address: " + this.maq.getIPAddress();
    }

    @Command(description="Set the IP address")
    public void setIPAddress(@Argument(name="ipaddr", description="IP address") String ipAddr) throws DriverException {
        this.maq.setIPAddress(ipAddr);
    }

    @Command(description="Show the subnet mask")
    public String showSubnetMask() throws DriverException {
        return "Subnet mask: " + this.maq.getSubnetMask();
    }

    @Command(description="Set the subnet mask")
    public void setSubnetMask(@Argument(name="mask", description="subnet mask") String mask) throws DriverException {
        this.maq.setSubnetMask(mask);
    }

    @Command(description="Show the temperature")
    public String showTemperature() throws DriverException {
        return "Temperature: " + this.maq.readTemperature();
    }

    @Command(description="Save the parameters")
    public void saveParams() throws DriverException {
        this.maq.saveParameters();
    }

    @Command(description="Show all module IDs")
    public String showIds() throws DriverException {
        int[] ids = this.maq.getModuleIds();
        if (ids.length == 0) {
            return "No modules present";
        }
        StringBuilder text = new StringBuilder("Valid module IDs:");
        for (int id : ids) {
            text.append(" ").append(id);
        }
        return text.toString();
    }

    @Command(description="Show all modules")
    public String showModules() throws DriverException {
        int[] ids = this.maq.getModuleIds();
        if (ids.length == 0) {
            return "No modules present";
        }
        StringBuilder text = new StringBuilder("ID  Type   F/W  Serial No.");
        for (int id : ids) {
            text.append(String.format("\n%2s  %-4s  %-4s  %s", new Object[]{id, this.maq.getModuleType(id), this.maq.getFwRevision(id), this.maq.getSerialNumber(id)}));
        }
        return text.toString();
    }

    @Command(description="Show module's ID")
    public String showId(@Argument(name="serial", description="Serial number") String serial) throws DriverException {
        return "Module ID: " + this.maq.getModuleId(serial);
    }

    @Command(description="Blink a module's status light")
    public void identify(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.identifyModule(modId);
    }

    @Command(description="Reset a module")
    public void reset(@Argument(name="modid", description="Module ID") int modId, @Argument(name="deflt", description="Whether to apply defaults") boolean deflt) throws DriverException {
        this.maq.resetModule(modId, deflt);
    }

    @Command(description="Show module's name")
    public String showName(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Device name: " + this.maq.getModuleName(modId);
    }

    @Command(description="Show module's type")
    public String showType(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Module type: " + (Object)((Object)this.maq.getModuleType(modId));
    }

    @Command(description="Show module's serial number")
    public String showSerial(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Serial number: " + this.maq.getSerialNumber(modId);
    }

    @Command(description="Show module's FW revision")
    public String showFwRevision(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Firmware revision: " + this.maq.getFwRevision(modId);
    }

    @Command(description="Show module's date code")
    public String showDateCode(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Date code: " + this.maq.getDateCode(modId);
    }

    @Command(description="Show module's input channel count")
    public String showNumInputs(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Input channel count: " + this.maq.getNumInputs(modId);
    }

    @Command(description="Show module's output channel count")
    public String showNumOutputs(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Output channel count: " + this.maq.getNumOutputs(modId);
    }

    @Command(description="Show module's watchdog flag")
    public String showWatchdogFlag(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Watchdog flag: " + this.maq.getWatchdogFlag(modId);
    }

    @Command(description="Show module's brownout flag")
    public String showBrownoutFlag(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Brownout flag: " + this.maq.getBrownoutFlag(modId);
    }

    @Command(description="Show module's I2C error counts")
    public String showI2cErrorCounts(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        int[] counts = this.maq.getI2cErrorCounts(modId);
        return String.format("I2C error counts: transmit = %s, receive = %s", counts[0], counts[1]);
    }

    @Command(description="Show module's DAC error count")
    public String showDacErrorCount(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "DAC error count: " + this.maq.getDacErrorCount(modId);
    }

    @Command(description="Show module's numeric error count")
    public String showNumericErrorCount(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Numeric error count: " + this.maq.getNumericErrorCount(modId);
    }

    @Command(description="Show module's UART RX error counts")
    public String showUartRxErrorCounts(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        int[] counts = this.maq.getUartRxErrorCounts(modId);
        return String.format("UART RX error counts: too short = %s, too long = %s, invalid state = %s", counts[0], counts[1], counts[2]);
    }

    @Command(description="Clear module's watchdog flag")
    public void clearWatchdogFlag(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.clearWatchdogFlag(modId);
    }

    @Command(description="Clear module's brownout flag")
    public void clearBrownoutFlag(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.clearBrownoutFlag(modId);
    }

    @Command(description="Clear module's I2C error counts")
    public void clearI2cerrorCounts(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.clearI2cErrorCounts(modId);
    }

    @Command(description="Clear module's DAC error count")
    public void clearDacErrorCount(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.clearDacErrorCount(modId);
    }

    @Command(description="Clear module's numeric error count")
    public void clearNumericErrorCount(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.clearNumericErrorCount(modId);
    }

    @Command(description="Clear module's UART RX error counts")
    public void clearUartRxErrorCounts(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.clearUartRxErrorCounts(modId);
    }

    @Command(description="Show module's range count")
    public String showNumRanges(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return "Range count: " + this.maq.getAnalog(modId).getNumRanges();
    }

    @Command(description="Show channel's range")
    public String showRange(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return "Range: " + this.maq.getAnalog(modId).getRange(chan);
    }

    @Command(description="Set channel's range")
    public void setRange(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="range", description="Range number") int range) throws DriverException {
        this.maq.getAnalog(modId).setRange(chan, range);
    }

    @Command(description="Show channel's enabled state")
    public String showEnabled(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return "Enabled state: " + (this.maq.getAnalIn(modId).isEnabled(chan) ? "on" : "off");
    }

    @Command(description="Set channel's enabled state")
    public void setEnabled(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="state", description="Enabled state") TestModbus.OnOff state) throws DriverException {
        this.maq.getAnalIn(modId).enable(chan, state == TestModbus.OnOff.ON);
    }

    @Command(description="Read channels' data values")
    public String readValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Number of channels") int count) throws DriverException {
        return this.formatDoubles(this.maq.getAnalog(modId).readValue(chan, count));
    }

    @Command(description="Read a channel's data value")
    public String readValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return this.formatDoubles(new double[]{this.maq.getAnalog(modId).readValue(chan)});
    }

    @Command(description="Read all channels' data values")
    public String readValue(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatDoubles(this.maq.getAnalog(modId).readValue());
    }

    @Command(description="Write data to channels")
    public void writeValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, double ... values) throws DriverException {
        this.maq.getAnalOut(modId).writeValue(chan, values.length, values);
    }

    @Command(description="Set default data for channels")
    public void setDefaultValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, double ... values) throws DriverException {
        this.maq.getAnalOut(modId).setDefaultValue(chan, values.length, values);
    }

    @Command(description="Show channels' default data values")
    public String showDefaultValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Number of channels") int count) throws DriverException {
        return this.formatDoubles(this.maq.getAnalOut(modId).getDefaultValue(chan, count));
    }

    @Command(description="Show a channel's default data value")
    public String showDefaultValue(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return this.formatDoubles(new double[]{this.maq.getAnalOut(modId).getDefaultValue(chan)});
    }

    @Command(description="Show all channels' default data values")
    public String showDefaultValue(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatDoubles(this.maq.getAnalOut(modId).getDefaultValue());
    }

    @Command(description="Save the default data values")
    public void saveDefaultValues(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.getAnalOut(modId).saveDefaultValues();
    }

    @Command(description="Save the output ranges")
    public void saveRanges(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.getAnalOut(modId).saveRanges();
    }

    @Command(description="Read discrete input channels' values")
    public String readDiscIn(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Number of channels") int count) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).readDiscIn(chan, count));
    }

    @Command(description="Read a discrete input channel's value")
    public String readDiscIn(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return this.formatIntegers(new int[]{this.maq.getDiscrete(modId).readDiscIn(chan)});
    }

    @Command(description="Read all discrete input channels' values")
    public String readDiscIn(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).readDiscIn());
    }

    @Command(description="Read discrete output channels' values")
    public String readDiscOut(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Number of channels") int count) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).readDiscOut(chan, count));
    }

    @Command(description="Read a discrete output channel's value")
    public String readDiscOut(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Channel number") int chan) throws DriverException {
        return this.formatIntegers(new int[]{this.maq.getDiscrete(modId).readDiscOut(chan)});
    }

    @Command(description="Read all discrete output channels' values")
    public String readDiscOut(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).readDiscOut());
    }

    @Command(description="Read all discrete input channels' values")
    public String readDiscAll(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return String.format("Values mask: %08x", this.maq.getDiscIn(modId).readDiscAll());
    }

    @Command(description="Write data to discrete channels")
    public void writeDiscOut(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, int ... values) throws DriverException {
        this.maq.getDiscrete(modId).writeDisc(chan, values.length, values);
    }

    @Command(description="Write data to discrete channels")
    public void writeDiscAll(@Argument(name="modid", description="Module ID") int modId, @Argument(name="value", description="Value to write") int value) throws DriverException {
        this.maq.getDiscOut(modId).writeDiscAll(value);
    }

    @Command(description="Set default discrete output values")
    public void setDiscDefault(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, int ... values) throws DriverException {
        this.maq.getDiscrete(modId).setDiscDefault(chan, values.length, values);
    }

    @Command(description="Save the default discrete output values")
    public void saveDiscDefaults(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        this.maq.getDiscrete(modId).saveDiscDefaults();
    }

    @Command(description="Set all default discrete output values")
    public void setDiscDefaultAll(@Argument(name="modid", description="Module ID") int modId, @Argument(name="value", description="Value to write") int value) throws DriverException {
        this.maq.getDiscOut(modId).setDiscDefaultAll(value);
    }

    @Command(description="Show all default discrete output values")
    public String showDiscDefault(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatIntegers(this.maq.getDiscrete(modId).getDiscDefault());
    }

    @Command(description="Show all default discrete output values")
    public String showDiscDefaultAll(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return String.format("Values mask: %08x", this.maq.getDiscOut(modId).getDiscDefaultAll());
    }

    @Command(description="Set power-off discrete output values")
    public void setDiscOff(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="First channel number") int chan, int ... values) throws DriverException {
        this.maq.getDiscOut(modId).setDiscOff(chan, values.length, values);
    }

    @Command(description="Set all default discrete output values")
    public void setDiscOffAll(@Argument(name="modid", description="Module ID") int modId, @Argument(name="value", description="Value to write") int value) throws DriverException {
        this.maq.getDiscOut(modId).setDiscOffAll(value);
    }

    @Command(description="Show all power-off discrete output values")
    public String showDiscOff(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return this.formatIntegers(this.maq.getDiscOut(modId).getDiscOff());
    }

    @Command(description="Show all default discrete output values")
    public String showDiscOffAll(@Argument(name="modid", description="Module ID") int modId) throws DriverException {
        return String.format("Values mask: %08x", this.maq.getDiscOut(modId).getDiscOffAll());
    }

    @Command(description="Set discrete function code")
    public void setFunction(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan, @Argument(name="func", description="Function name") DiscFunc func) throws DriverException {
        this.maq.getDiscPulse(modId).setFunction(chan, func.getValue());
    }

    @Command(description="Show discrete function code")
    public String showFunction(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        int func = this.maq.getDiscPulse(modId).getFunction(chan);
        return "Function: " + func + " (" + funcDescs.get(func) + ")";
    }

    @Command(description="Arm discrete function")
    public void armFunction(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        this.maq.getDiscPulse(modId).armFunction(chan);
    }

    @Command(description="Disarm discrete function")
    public void disarmFunction(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        this.maq.getDiscPulse(modId).disarmFunction(chan);
    }

    @Command(description="Read pulse count")
    public String readPulseCount(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        return "Pulse count: " + this.maq.getDiscPulse(modId).readPulseCount(chan);
    }

    @Command(description="Read frequency")
    public String readFrequency(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        return "Frequency: " + this.maq.getDiscPulse(modId).readFrequency(chan);
    }

    @Command(description="Read RPM")
    public String readRPM(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        return "RPM: " + this.maq.getDiscPulse(modId).readRPM(chan);
    }

    @Command(description="Set pulses per revolution")
    public void setPulsesPerRevn(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan, @Argument(name="ppr", description="Pulses/revolution") int ppr) throws DriverException {
        Maq20DiscretePulse maqDisc = this.maq.getDiscPulse(modId);
        maqDisc.setPulsesPerRevn(chan, ppr);
        maqDisc.armFunction(chan);
    }

    @Command(description="Show pulses per revolution")
    public String showPulsesPerRevn(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        return "Pulses/revolution: " + this.maq.getDiscPulse(modId).getPulsesPerRevn(chan);
    }

    @Command(description="Set PWM timebase")
    public void setTimebase(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan, @Argument(name="time", description="Timebase") Timebase timebase) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.setTimebase(chan, timebase.getValue());
        maqDisc.armFunction(chan);
    }

    @Command(description="Show PWM timebase")
    public String showTimebase(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        int timebase = this.maq.getDiscPWM(modId).getTimebase(chan);
        return "PWM timebase: " + timebase + " (" + timebaseDescs.get(timebase) + ")";
    }

    @Command(description="Set PWM period")
    public void setPeriod(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan, @Argument(name="period", description="PWM period") int period) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.setPeriod(chan, period);
        maqDisc.armFunction(chan);
    }

    @Command(description="Show PWM period")
    public String showPeriod(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        return "PWM period: " + this.maq.getDiscPWM(modId).getPeriod(chan);
    }

    @Command(description="Set output 1 low time")
    public void setLowTime1(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan, @Argument(name="time", description="Time") int time) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.setLowTime1(chan, time);
        maqDisc.armFunction(chan);
    }

    @Command(description="Show PWM output 1 low time")
    public String showLowTime1(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        return "PWM low time 1: " + this.maq.getDiscPWM(modId).getLowTime1(chan);
    }

    @Command(description="Set output 2 low time")
    public void setLowTime2(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan, @Argument(name="time", description="Time") int time) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.setLowTime2(chan, time);
        maqDisc.armFunction(chan);
    }

    @Command(description="Show PWM output 2 low time")
    public String showLowTime2(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        return "PWM low time 2: " + this.maq.getDiscPWM(modId).getLowTime2(chan);
    }

    @Command(description="Enable/disable output 2")
    public void enableOut2(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan, @Argument(name="time", description="Time") boolean enable) throws DriverException {
        Maq20DiscretePWM maqDisc = this.maq.getDiscPWM(modId);
        maqDisc.enableOutput2(chan, enable);
        maqDisc.armFunction(chan);
    }

    @Command(description="Show whether PWM output 2 is enabled")
    public String isOut2Enabled(@Argument(name="modid", description="Module ID") int modId, @Argument(name="chan", description="Function channel number (0 or 1)") int chan) throws DriverException {
        return "PWM output 2 is " + (this.maq.getDiscPWM(modId).isOutput2Enabled(chan) ? "" : "not ") + "enabled";
    }

    private String formatDoubles(double[] values) {
        StringBuilder text = new StringBuilder(values.length > 1 ? "Values:" : "Value:");
        for (double value : values) {
            text.append(String.format(" %.6g", value));
        }
        return text.toString();
    }

    private String formatIntegers(int[] values) {
        StringBuilder text = new StringBuilder(values.length > 1 ? "Values:" : "Value:");
        for (int value : values) {
            text.append(" ").append(value);
        }
        return text.toString();
    }

    static {
        funcDescs.put(0, "None");
        funcDescs.put(1, "Pulse counter");
        funcDescs.put(2, "Debounced pulse counter");
        funcDescs.put(3, "Waveform measurement");
        funcDescs.put(4, "Time between events");
        funcDescs.put(5, "Frequency generator");
        funcDescs.put(6, "PWM generator");
        funcDescs.put(7, "One-shot pulse generator");
        timebaseDescs = new HashMap<Integer, String>();
        timebaseDescs.put(0, "seconds");
        timebaseDescs.put(1, "milliseconds");
        timebaseDescs.put(2, "microseconds");
    }

    public static enum Timebase {
        SECS(0),
        MSECS(1),
        USECS(2);

        int value;

        private Timebase(int func) {
            this.value = func;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum DiscFunc {
        PULSE(1),
        PWMGEN(6),
        FREQGEN(5);

        int value;

        private DiscFunc(int func) {
            this.value = func;
        }

        int getValue() {
            return this.value;
        }
    }
}

