/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public class CanCBXAI420
extends CanOpenDevice
implements ADCInterface {
    public static final double NANO_VOLTS_PER_BIT = 4.6566;

    @Override
    public int readAnalogInput(int inputNB) {
        return (int)this.readSDO(25602, inputNB);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="read voltage in volts for the input chanel inputNB")
    public double readVoltage(int inputNB) {
        if (inputNB <= 0 || inputNB > 4) {
            throw new IllegalArgumentException(inputNB + " : has to be between 1 and 4");
        }
        return (double)this.readAnalogInput(inputNB) * 4.6566 * Math.pow(10.0, -9.0);
    }

    @Override
    public long getInput(int i) {
        return (long)this.readVoltage(i);
    }
}

