/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.PersistentCounter;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerOnlineClamp
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    private static final Logger FCSLOG = Logger.getLogger(AutochangerOnlineClamp.class.getName());
    public static final String ONLINE_CLAMP_CONFIG_CATEGORY = "onlineClampCurrent";
    public static final String CURRENT_MONITOR_TASK_NAME = "-monitorCurrent";
    public static final int TIMEOUT_FOR_CLOSING = 6000;
    public static final int TIMEOUT_FOR_OPENING = 15000;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final EPOSControllerForOnlineClamp controller;
    private final ComplementarySensors closeSensors;
    private final ComplementarySensors openSensors;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @ConfigurationParameter(range="-7000..7000", description="Current to clamp ONLINE clamp", units="mA", category="autochanger")
    private volatile int currentToClamp = 0;
    @ConfigurationParameter(range="-2000..2000", description="Current to open ONLINE clamp", units="mA", category="autochanger")
    private volatile int currentToOpen = 0;
    @Persist
    private volatile int sentCurrent = 0;
    private int position;
    @ConfigurationParameter(range="0..2000", description="Increment of current to lock in a current ramp", units="mA", category="autochanger")
    private volatile int incrementCurrentToClamp = 250;
    @ConfigurationParameter(range="0..1000", description="Increment of current to close clamp in a current ramp", units="mA", category="autochanger")
    private volatile int incrementCurrentToClose = 250;
    @ConfigurationParameter(range="0..1000", description="Increment of current to open clamp in a current ramp", units="mA", category="autochanger")
    private volatile int incrementCurrentToOpen = 250;
    @ConfigurationParameter(range="-3000..3000", description="Initial current to close clamp in a current ramp", units="mA", category="autochanger")
    private volatile int initialCurrentToClose = -this.currentToOpen;
    @ConfigurationParameter(range="-3000..3000", description="Final current to close clamp in a current ramp", units="mA", category="autochanger")
    private volatile int finalCurrentToClose = -this.currentToOpen * 2;
    private volatile FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile boolean initialized;
    private boolean controllerConfigured = true;
    private ScheduledFuture<?> currentRampHandle;
    @ConfigurationParameter(range="-18000..18000", description="Absolute target position to open clamp", units="unitless", category="autochanger")
    private volatile int targetPositionToOpen;
    @ConfigurationParameter(range="-150000..150000", description="Absolute target position to close clamp", units="unitless", category="autochanger")
    private volatile int targetPositionToClose;
    @ConfigurationParameter(range="0..500", description="Delta of current between target current and current read on controller. Used to know if action is completed for homing.", units="mA", category="autochanger")
    private volatile int deltaCurrent = 50;
    private final int positionRange = 500;

    public AutochangerOnlineClamp(EPOSControllerForOnlineClamp controller, ComplementarySensors closeSensors, ComplementarySensors openSensors) {
        this.controller = controller;
        this.closeSensors = closeSensors;
        this.openSensors = openSensors;
    }

    public void setCurrentToClamp(int currentToClamp) {
        this.currentToClamp = currentToClamp;
    }

    public void setCurrentToOpen(int currentToOpen) {
        this.currentToOpen = currentToOpen;
    }

    public void setInitialCurrentToClose(int initialCurrentToClose) {
        this.initialCurrentToClose = initialCurrentToClose;
    }

    public void setFinalCurrentToClose(int finalCurrentToClose) {
        this.finalCurrentToClose = finalCurrentToClose;
    }

    public void setSentCurrent(int sentCurrent) {
        this.sentCurrent = sentCurrent;
    }

    public void setTargetPositionToOpen(int targetPositionToOpen) {
        this.targetPositionToOpen = targetPositionToOpen;
    }

    public void setTargetPositionToClose(int targetPositionToClose) {
        this.targetPositionToClose = targetPositionToClose;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToClamp(int stepHeightAbsValue) {
        FcsUtils.checkPositive(stepHeightAbsValue);
        this.incrementCurrentToClamp = stepHeightAbsValue;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToOpen(int incrementCurrentToOpen) {
        FcsUtils.checkPositive(incrementCurrentToOpen);
        this.incrementCurrentToOpen = incrementCurrentToOpen;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToClose(int incrementCurrentToClose) {
        FcsUtils.checkPositive(incrementCurrentToClose);
        this.incrementCurrentToClose = incrementCurrentToClose;
    }

    public int getInitialCurrentToClose() {
        return this.initialCurrentToClose;
    }

    public int getFinalCurrentToClose() {
        return this.finalCurrentToClose;
    }

    public int getIncrementCurrentToOpen() {
        return this.incrementCurrentToOpen;
    }

    public int getIncrementCurrentToClamp() {
        return this.incrementCurrentToClamp;
    }

    public int getIncrementCurrentToClose() {
        return this.incrementCurrentToClose;
    }

    public int getSentCurrent() {
        return this.sentCurrent;
    }

    @Override
    public EPOSControllerForOnlineClamp getController() {
        return this.controller;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public ComplementarySensors getCloseSensors() {
        return this.closeSensors;
    }

    public int getTargetPositionToOpen() {
        return this.targetPositionToOpen;
    }

    public int getTargetPositionToClose() {
        return this.targetPositionToClose;
    }

    public ComplementarySensors getOpenSensors() {
        return this.openSensors;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockSensor and lockSensorC return the same value. Doesn't read again sensors.")
    public boolean isCloseSensorsInError() {
        return this.closeSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if unlockSensor and unlockSensorC return the same value. Doesn't read again sensors.")
    public boolean isOpenSensorsInError() {
        return this.openSensors.isInError();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if in ERROR which means that closeSensor or openSensor is in ERROR or thatopenSensor and closeSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CLOSED. Doesn't read again sensors.")
    public boolean isClosed() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if homing of controller has been done. Does not read the controller.")
    public boolean isHomingDone() {
        return this.controller.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Reads the homing status on the controller, True means that the homing as been done and is still in memory.")
    public boolean checkHomingStatusOnController() {
        return this.controller.checkHomingStatusOnController();
    }

    public void updateHomingFromControllerStatusWord() {
        this.controller.updateHomingFromControllerStatusWord();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LOCKED. Doesn't read again sensors.")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if OPENED. Doesn't read again sensors.")
    public boolean isOpened() {
        return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if INTRAVEL. Doesn't read again sensors.")
    public boolean isInTravel() {
        return this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is initialized : controller is booted and parameters in the controller CPU have been opened and controller is configured.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.controller.getName()), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.SDO_ERROR.getAlert(this.controller.getName()), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerOnlineClamp.class, this.path);
        this.movementCounter = new EnumMap(FcsEnumerations.MobileItemAction.class);
        for (FcsEnumerations.MobileItemAction action : new FcsEnumerations.MobileItemAction[]{FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_CURRENT, FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP, FcsEnumerations.MobileItemAction.OPEN_HOMING_ONLINECLAMP, FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT, FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, FcsEnumerations.MobileItemAction.OPEN_HALFWAY_RELATIVE_POSITION, FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT, FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP}) {
            this.registerActionDuration(action);
            this.movementCounter.put(action, PersistentCounter.newCounter(action.getActionCounterPath(this.path), this.subs, action.name()));
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is initialized and configured.")
    public boolean myDevicesReady() {
        return this.controller.isInitialized() && this.controllerConfigured;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be opened.")
    public void checkConditionsForOpening() {
        this.autochanger.checkConditionsForActioningOnlineClamps();
        if (!this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " can't be OPENED if autochanger is not HOLDING filter.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be closed.")
    public void checkConditionsForClosing() {
        this.autochanger.checkConditionsForActioningOnlineClamps();
    }

    public void postStart() {
        FCSLOG.fine(() -> this.name + " BEGIN postStart.");
        if (this.controller.isBooted()) {
            this.initializeController();
            this.controller.updateEposState();
            this.updatePosition();
            this.checkHomingAtStartup();
        } else {
            FCSLOG.severe(this.name + " could not initialize controller in postStart. Do it by hand.");
        }
        FCSLOG.fine(() -> this.name + " END postStart.");
    }

    private void initializeController() {
        try {
            this.controller.initializeAndCheckHardware();
            this.controller.updateHomingFromControllerStatusWord();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.controller.getName(), (Exception)ex);
        }
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, level=1, description="Change mode depending of action to be done, then enable and release brake.")
    public void enableAndCheckControllerBeforeAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION: 
            case OPEN_ONLINECLAMP_MODE_PROFILE_POSITION: 
            case OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE: {
                this.controller.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                break;
            }
            default: {
                this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
            }
        }
        this.controller.enableAndReleaseBrake();
        this.controller.checkFault();
    }

    public void checkControllerWhenGoingFromEngineeringModeToNormal() {
        this.controller.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        if (!this.controller.isParametersOK()) {
            String msg = this.name + " Some parameter values are not the same in CPU and configuration system.";
            FCSLOG.severe(msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure controller.")
    public void configureController() {
        try {
            this.controllerConfigured = false;
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
            this.controllerConfigured = true;
        }
        catch (SDORequestException ex) {
            FCSLOG.log(Level.WARNING, this.name, ex);
        }
    }

    public void updatePosition() {
        this.position = this.controller.getPosition();
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state from sensors values.")
    public synchronized void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-acClamp");){
            boolean inError;
            boolean closed = this.closeSensors.isOn();
            boolean opened = this.openSensors.isOn();
            boolean someSensorsInError = this.closeSensors.isInError() || this.openSensors.isInError();
            boolean bl = inError = someSensorsInError || closed && opened;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (closed ? FcsEnumerations.LockStatus.CLOSED : (opened ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
            if (closed && this.sentCurrent == this.currentToClamp) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            }
            this.updatePosition();
            this.publishData();
        }
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
        this.controller.publishDataDuringMotion();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case UNLOCK_ONLINECLAMP: {
                return this.sentCurrent == this.finalCurrentToClose;
            }
            case CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION: {
                FCSLOG.info(this.name + " /position=" + this.position + " /position to reach = " + this.targetPositionToClose + " /positionRange = 500");
                return this.isClosed() && this.isAtPosition(this.targetPositionToClose);
            }
            case OPEN_ONLINECLAMP_MODE_CURRENT: 
            case REOPEN_ONLINECLAMP_MODE_CURRENT: {
                return this.isOpened();
            }
            case OPEN_HALFWAY_RELATIVE_POSITION: {
                FCSLOG.info(this.name + " /position=" + this.position);
                return this.controller.isTargetReached();
            }
            case OPEN_HOMING_ONLINECLAMP: {
                FCSLOG.info(this.name + " /position=" + this.position);
                return this.isOpened() && this.controller.isTargetReached();
            }
            case OPEN_ONLINECLAMP_MODE_PROFILE_POSITION: 
            case OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE: {
                FCSLOG.info(this.name + " /position=" + this.position + " /position to reach = " + this.targetPositionToOpen + " /positionRange = 500");
                return this.isOpened() && this.isAtPosition(this.targetPositionToOpen);
            }
            case CLOSE_ONLINECLAMP_MODE_CURRENT: {
                return this.isClosed();
            }
            case LOCK_ONLINECLAMP: {
                return this.isLocked();
            }
        }
        throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + action);
    }

    public boolean isAtPositionClose() {
        return this.isAtPosition(this.targetPositionToClose);
    }

    public boolean isAtPositionOpen() {
        return this.isAtPosition(this.targetPositionToOpen);
    }

    public boolean isAtPosition(int pos) {
        return Math.abs(this.position - pos) < 500;
    }

    public boolean isAtPositionClosedOrLocked() {
        return Math.abs(this.position - this.targetPositionToClose) < 15000;
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Closes the ONLINE clamp.", timeout=6000)
    public void closeClampInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (this.isOpened() || this.isInTravel()) {
            this.checkConditionsForClosing();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_CURRENT, 6000L);
            this.checkCloseSensors();
            this.updateStateAndCheckSensors();
        } else if (this.isClosed()) {
            FCSLOG.info(this.name + " is already CLOSED. Nothing to do.");
        } else {
            throw new RejectedCommandException(this.name + " has to be OPENED before a close action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Closes the ONLINE clamp in mode PROFILE_POSITION.", timeout=6000)
    public void close() {
        block8: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-close");){
                if (!this.controller.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet. Can't close.");
                }
                this.updateStateAndCheckSensors();
                if (this.isOpened() || this.isInTravel()) {
                    this.checkConditionsForClosing();
                    this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, 6000L);
                    this.checkCloseSensors();
                    this.updateStateAndCheckSensors();
                    break block8;
                }
                if (this.isClosed()) {
                    FCSLOG.info(this.name + " is already CLOSED. Nothing to do.");
                    break block8;
                }
                throw new RejectedCommandException(this.name + " has to be OPENED before a close action.");
            }
        }
    }

    private void checkCloseSensors() {
        if (!this.isClosed()) {
            throw new FailedCommandException(this.name + " not CLOSED after close or unlock command, lockStatus is " + this.lockStatus.name());
        }
        FCSLOG.info(this.name + " is CLOSED");
    }

    private void checkOpenSensors() {
        if (!this.isOpened()) {
            throw new FailedCommandException(this.name + " is not OPEN after open or openAndHoming command. current action : " + this.currentAction.toString());
        }
        FCSLOG.info(this.name + " is OPEN");
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Opens the ONLINE clamp.", timeout=15000)
    public void openClampInCurrentMode() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openClampInCurrentMode");){
            this.updateStateAndCheckSensors();
            if (this.isClosed()) {
                this.checkConditionsForOpening();
                this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT, 15000L);
            } else if (this.isOpened() || this.isInTravel()) {
                FCSLOG.info(this.name + " is already OPENED. Send again currentToOpen.");
                this.executeAction(FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT, 15000L);
            } else {
                throw new RejectedCommandException(this.name + " has to be CLOSED before an open action.");
            }
            this.controller.checkFault();
            this.checkOpenSensors();
            this.updateStateAndCheckSensors();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Opens the ONLINE clamp in PROFILE_POSITION.", timeout=15000)
    public void open() {
        block8: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-open");){
                if (!this.controller.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet. Use openInCurrentModeAndHoming.");
                }
                this.updateStateAndCheckSensors();
                if (this.isClosed() || this.isInTravel()) {
                    this.checkConditionsForOpening();
                    this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, 15000L);
                    this.checkOpenSensors();
                    this.updateStateAndCheckSensors();
                    break block8;
                }
                if (this.isOpened()) {
                    FCSLOG.info(this.name + " is already OPENED. Nothing to do.");
                    break block8;
                }
                throw new RejectedCommandException(this.name + " has to be CLOSED before an open action.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Open the Online Clamp in PROFILE_POSITION without putting the brake", timeout=15000)
    public void openNoBrake() {
        block8: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-open-nobrake");){
                if (!this.controller.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet. Use openInCurrentModeAndHoming.");
                }
                this.updateStateAndCheckSensors();
                if (this.isClosed() || this.isInTravel()) {
                    this.checkConditionsForOpening();
                    this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE, 15000L);
                    this.checkOpenSensors();
                    this.updateStateAndCheckSensors();
                    break block8;
                }
                if (this.isOpened()) {
                    FCSLOG.info(this.name + " is already OPENED. Nothing to do.");
                    break block8;
                }
                throw new RejectedCommandException(this.name + " has to be CLOSED before an open action.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="open clamp in CURRENT mode and do homing", timeout=5000)
    public void openInCurrentModeAndHoming() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openInCurrentModeAndHoming");){
            this.openClampInCurrentMode();
            this.controller.homing();
            this.updatePosition();
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, 15000L);
            this.updatePosition();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Open clamp and do homing with current threshold", timeout=5000)
    public void openAndHoming() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openAndHoming");){
            this.updateStateAndCheckSensors();
            if (this.isLocked()) {
                throw new RejectedCommandException(this.name + " has to be OPEN or CLOSED before starting homing.");
            }
            if (this.isClosed()) {
                this.executeAction(FcsEnumerations.MobileItemAction.OPEN_HALFWAY_RELATIVE_POSITION, 5000L);
                this.controller.updateDataDuringMotionFromSDO();
                this.controller.publishData();
            }
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN_HOMING_ONLINECLAMP, 15000L);
            this.updateHomingFromControllerStatusWord();
            this.updatePosition();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Open clamp in relative position and end up between open and close", timeout=5000)
    public void openHalfwayProfilePosition() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openHalfwayProfilePosition");){
            this.updateStateAndCheckSensors();
            if (!this.isClosed()) {
                throw new RejectedCommandException(this.name + " has to be CLOSED before issuing this method.");
            }
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN_HALFWAY_RELATIVE_POSITION, 5000L);
            this.updatePosition();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Check whether homing is already done at FCS startup")
    public void checkHomingAtStartup() {
        if (this.closeSensors.isOn() && this.isAtPositionClosedOrLocked()) {
            this.controller.setHomingDone();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Locks the ONLINE clamp : sends currentToClamp to the controller with a ramp of currentfrom currentToClose to currentToRamp.", timeout=6000)
    public void lock() {
        block7: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-lock");){
                this.updateStateAndCheckSensors();
                if (this.isClosed()) {
                    this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP, 6000L);
                    this.updateStateAndCheckSensors();
                    break block7;
                }
                if (this.isLocked()) {
                    FCSLOG.info(this.name + " is already LOCKED. Nothing to do.");
                    break block7;
                }
                throw new RejectedCommandException(this.name + " has to be CLOSED before lock action.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Unlocks the ONLINE clamp : sends currentToClamp to the controller  with a ramp of current from currentToClamp to currentToClose.", timeout=15000)
    public void unlock() {
        block7: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-unlock");){
                this.updateStateAndCheckSensors();
                if (this.isLocked()) {
                    this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP, 6000L);
                    this.checkCloseSensors();
                    this.updateStateAndCheckSensors();
                    break block7;
                }
                if (this.isClosed()) {
                    FCSLOG.info(this.name + " is already CLOSED. Nothing to do.");
                    break block7;
                }
                throw new RejectedCommandException(this.name + " has to be LOCKED before unlock action.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("AutoOnlineClamp-action-" + action.toString());){
            this.autochanger.checkConditionsForActioningOnlineClamps();
            switch (action) {
                case CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                    this.controller.enableAndReleaseBrake();
                    this.controller.writeTargetPosition(this.targetPositionToClose);
                    this.controller.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION_AND_MOVE);
                    return;
                }
                case CLOSE_ONLINECLAMP_MODE_CURRENT: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.controller.doReleaseBrake();
                    this.writeCurrentToControllerAndSaveValue(this.initialCurrentToClose);
                    this.executeCurrentRamp(this.initialCurrentToClose, this.finalCurrentToClose, this.incrementCurrentToClose);
                    return;
                }
                case OPEN_ONLINECLAMP_MODE_PROFILE_POSITION: 
                case OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                    this.controller.enableAndReleaseBrake();
                    this.controller.writeTargetPosition(this.targetPositionToOpen);
                    this.controller.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION_AND_MOVE);
                    return;
                }
                case OPEN_ONLINECLAMP_MODE_CURRENT: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.writeCurrentToControllerAndSaveValue(this.finalCurrentToClose);
                    FcsUtils.sleep(250, this.name);
                    this.controller.doReleaseBrake();
                    this.executeCurrentRamp(this.finalCurrentToClose, this.currentToOpen, this.incrementCurrentToOpen);
                    return;
                }
                case OPEN_HALFWAY_RELATIVE_POSITION: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                    this.controller.enableAndReleaseBrake();
                    int targetPosition = (this.targetPositionToOpen - this.targetPositionToClose) / 2;
                    this.controller.enableAndWriteRelativePosition(targetPosition);
                    return;
                }
                case OPEN_HOMING_ONLINECLAMP: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.HOMING);
                    int homingMethod = this.currentToOpen >= 0 ? -3 : -4;
                    this.controller.writeParameter(EPOSEnumerations.Parameter.HomingMethod, homingMethod);
                    this.controller.writeParameter(EPOSEnumerations.Parameter.HomePosition, this.targetPositionToOpen);
                    this.controller.doReleaseBrake();
                    this.controller.goToOperationEnable();
                    this.controller.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION);
                    return;
                }
                case REOPEN_ONLINECLAMP_MODE_CURRENT: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.controller.doReleaseBrake();
                    this.writeCurrentToControllerAndSaveValue(this.currentToOpen);
                    return;
                }
                case LOCK_ONLINECLAMP: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.writeCurrentToControllerAndSaveValue(this.finalCurrentToClose);
                    FcsUtils.sleep(250, this.name);
                    this.controller.doReleaseBrake();
                    this.executeCurrentRamp(this.finalCurrentToClose, this.currentToClamp, this.incrementCurrentToClamp);
                    return;
                }
                case UNLOCK_ONLINECLAMP: {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.writeCurrentToControllerAndSaveValue(this.currentToClamp);
                    FcsUtils.sleep(250, this.name);
                    this.controller.doReleaseBrake();
                    this.executeCurrentRamp(this.currentToClamp, this.finalCurrentToClose, this.incrementCurrentToClamp);
                    return;
                }
                default: {
                    throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + action);
                }
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="sent current to control and save this value")
    public void writeCurrentToControllerAndSaveValue(int current) {
        FCSLOG.finest(() -> this.name + " current to write to controller " + this.getControllerName() + ":" + current);
        this.controller.writeCurrent((short)current);
        this.sentCurrent = current;
        this.subs.getAgentPersistenceService().persistNow();
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.finer(() -> this.name + " is ABORTING action " + action.toString() + " within delay " + delay);
        switch (action) {
            case OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE: {
                this.controller.stopAction();
                break;
            }
            case CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION: 
            case OPEN_ONLINECLAMP_MODE_PROFILE_POSITION: 
            case OPEN_HALFWAY_RELATIVE_POSITION: {
                this.controller.stopAction();
                this.controller.activateBrake();
                break;
            }
            default: {
                this.controller.activateBrake();
                this.controller.writeCurrent(0);
                this.controller.goToSwitchOnDisabled();
            }
        }
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.finer(() -> this.name + " is ENDING action " + action.toString());
        switch (action) {
            case CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION: 
            case UNLOCK_ONLINECLAMP: {
                break;
            }
            case OPEN_ONLINECLAMP_MODE_CURRENT: 
            case REOPEN_ONLINECLAMP_MODE_CURRENT: {
                FCSLOG.info(this.name + " waiting for clamp to be completely open.");
                FcsUtils.sleep(3000, this.name);
                this.controller.activateBrake();
                FcsUtils.sleep(this.autochanger.getWaitTimeForBrakeOC(), this.name);
                this.controller.goToSwitchOnDisabled();
                break;
            }
            case OPEN_ONLINECLAMP_MODE_PROFILE_POSITION: 
            case OPEN_HALFWAY_RELATIVE_POSITION: 
            case OPEN_HOMING_ONLINECLAMP: 
            case CLOSE_ONLINECLAMP_MODE_CURRENT: 
            case LOCK_ONLINECLAMP: {
                this.controller.activateBrake();
                FcsUtils.sleep(this.autochanger.getWaitTimeForBrakeOC(), this.name);
                this.controller.goToSwitchOnDisabled();
                break;
            }
            case OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE: {
                this.controller.goToSwitchOnDisabled();
                break;
            }
            default: {
                throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + action);
            }
        }
        FCSLOG.finer(() -> this.name + " END of action " + action.toString());
        this.publishData();
        this.controller.checkFault();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() {
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, 5);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, 0);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, 35872);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, 48);
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() {
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, 0);
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput4, 15);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 32769);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, 0);
    }

    public StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp() {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setLockSensorOn(this.closeSensors.isOn());
        status.setUnlockSensorOn(this.openSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorInError(this.closeSensors.isInError());
        status.setUnlockSensorInError(this.openSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        status.setSentCurrent(this.sentCurrent);
        status.setHomingDone(this.controller.isHomingDone());
        return status;
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByOnlineClamp()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
    }

    private void cancelCurrentRamp() {
        this.currentRampHandle.cancel(false);
        FCSLOG.finer(" => current ramp ended");
    }

    private void waitForEndOfCurrentRamp(int timeout) {
        FCSLOG.info(this.name + " BEGIN WAITING FOR END OF CURRENT RAMP");
        try {
            this.currentRampHandle.get(timeout, TimeUnit.SECONDS);
        }
        catch (CancellationException ex) {
            if (this.currentRampHandle.isDone()) {
                FCSLOG.info(this.name + " CURRENT RAMP ENDED");
            } else {
                FCSLOG.log(Level.SEVERE, this.name + " during action " + this.currentAction + " waiting was cancelled before END of CURRENT RAMP\n", ex);
            }
        }
        catch (TimeoutException ex) {
            FCSLOG.log(Level.SEVERE, this.name + " CURRENT RAMP IS DURING TOO LONG - timeout=" + timeout + " ", ex);
            this.cancelCurrentRamp();
        }
        catch (InterruptedException ex) {
            FCSLOG.log(Level.SEVERE, this.name + " interrupted while waiting end of current ramp during action=" + this.currentAction, ex);
            throw new FcsHardwareException(this.name + " interrupted while waiting end of current ramp during action=" + this.currentAction, (Throwable)ex);
        }
        catch (ExecutionException ex) {
            FCSLOG.log(Level.SEVERE, this.name + " error during action=" + this.currentAction, ex);
            throw new FcsHardwareException(this.name + " error during action=" + this.currentAction, (Throwable)ex);
        }
        finally {
            FCSLOG.info(this.name + " STOP WAITING FOR END OF CURRENT RAMP");
        }
    }

    private void writeCurrentRamp(final int initialValue, final int finalValue, final int increment) {
        FCSLOG.finer(() -> {
            StringBuilder message = new StringBuilder("############################\n");
            message.append(this.name).append("writeCurrentRamp\n");
            message.append("initialValue=").append(initialValue).append("\n");
            message.append("finalValue=").append(finalValue).append("\n");
            message.append("|increment|=").append(increment).append("\n");
            message.append("period=").append(250).append("\n");
            message.append("waitTime=").append(250).append("\n");
            message.append("############################");
            return message.toString();
        });
        Runnable currentRamp = new Runnable(){
            private final int adjustedStepHeight;
            private int currentValue;
            {
                this.adjustedStepHeight = FcsUtils.getSignedStepHeight(initialValue, finalValue, increment);
                this.currentValue = initialValue;
            }

            public boolean finalValueReached() {
                boolean reachedUp = this.adjustedStepHeight > 0 && this.currentValue >= finalValue;
                boolean reachedDown = this.adjustedStepHeight < 0 && this.currentValue <= finalValue;
                return reachedUp || reachedDown;
            }

            @Override
            public void run() {
                if (!this.finalValueReached()) {
                    this.currentValue += this.adjustedStepHeight;
                    FCSLOG.info("ramp " + AutochangerOnlineClamp.this.name + " write current " + this.currentValue);
                    AutochangerOnlineClamp.this.writeCurrentToControllerAndSaveValue(this.currentValue);
                }
                if (this.finalValueReached()) {
                    AutochangerOnlineClamp.this.cancelCurrentRamp();
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 250L, 250L, TimeUnit.MILLISECONDS);
    }

    public void executeCurrentRamp(int initialCurrent, int finalCurrent, int incrementCurrent) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("executeCurrentRamp");){
            this.writeCurrentRamp(initialCurrent, finalCurrent, incrementCurrent);
            this.waitForEndOfCurrentRamp(15000);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Fake the current sent to the controller for this clamp - MUST BE USED BY FES ENGINEERS ONLY")
    public void setSentCurrentDANGEROUS(int value) {
        FCSLOG.severe("setSentCurrentValueDANGEROUS : fake the current sent to the controller for this clamp to " + value + " mA");
        this.sentCurrent = value;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Fake the LOCKED status of the clamp by patching the sent current - MUST BE USED BY FES ENGINEERS ONLY")
    public void setClampStatusLockedDANGEROUS() {
        FCSLOG.severe("setClampStatusLockedDANGEROUS : fake the LOCKED status of the clamp by patching the sent current");
        this.sentCurrent = this.currentToClamp;
        this.updateState();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Fake the CLOSED status of the clamp by patching the sent current - MUST BE USED BY FES ENGINEERS ONLY")
    public void setClampStatusClosedDANGEROUS() {
        FCSLOG.severe("setClampStatusClosedDANGEROUS : fake the CLOSED status of the clamp by patching the sent current");
        this.sentCurrent = this.finalCurrentToClose;
        this.updateState();
    }
}

