/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderCarrierController
extends SimuEPOSController {
    private static final Logger FCSLOG = Logger.getLogger(SimuLoaderCarrierController.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*carrier")
    private LoaderCarrier carrier;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="loader")
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private SimuLoaderPlutoGateway plutoGateway;
    @LookupPath
    private String nodePath;

    @Override
    public void init() {
        if (this.plutoGateway == null) {
            throw new RuntimeException("Invalid initialization. An instance of SimuAutochangerPlutoGateway should have been picked up from the Lookup tree from the siblinds of this node: " + this.nodePath);
        }
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSLOG.finer("loader carrier is moving.");
        FCSLOG.finer(this.name + "=>position intitiale=" + this.position);
        int stepsNB = 20;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            try {
                this.position = positionInitiale + i * step;
                this.carrier.updatePosition();
                if (this.position == this.carrier.getHandoffPosition()) {
                    FCSLOG.finer("plutoGateway=" + this.plutoGateway.toString());
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (this.position == this.carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                this.loader.updateStateWithSensors();
                this.carrier.publishData();
                FCSLOG.finer(this.name + "i=" + i + ",position=" + this.position);
                try {
                    Thread.sleep(10L);
                    if (!this.carrier.getHaltRequired().get()) continue;
                    FCSLOG.finer(this.name + " STOP simulated carrier motion.");
                    return;
                }
                catch (InterruptedException ex) {
                    throw new RejectedCommandException(this.name + " sleep was interrupted.");
                }
            }
            catch (FcsHardwareException ex) {
                FCSLOG.severe(ex.toString());
                throw new RejectedCommandException(ex.getMessage());
            }
        }
        this.position = this.targetPosition;
        if (this.position == this.carrier.getHandoffPosition()) {
            FCSLOG.finer("plutoGateway=" + this.plutoGateway.toString());
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (this.position == this.carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else if (this.position == this.carrier.getEngagedPosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtEngaged();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }
    }
}

