/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselBrakes;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.common.AcceleroInterface;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.PT100Interface;
import org.lsst.ccs.subsystems.fcs.common.PersistentCounter;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.common.TTC580Interface;
import org.lsst.ccs.subsystems.fcs.errors.ControllerFaultException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Carousel
extends MobileItem
implements FilterHolder {
    private static final long serialVersionUID = -2376279469784152348L;
    private static final Logger FCSLOG = Logger.getLogger(Carousel.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private int rotationTimeout;
    protected int position = 0;
    private int relativeTargetPosition;
    protected int absoluteTargetPosition;
    protected int startPosition;
    @ConfigurationParameter(description="If the value of deltaPosition exceeds this threshold after the recovery procedure, cancel any rotation action.", units="unitless", range="0..2181120", category="carousel")
    private volatile int maxStandbyDeltaPosition = 130;
    @ConfigurationParameter(description="When deltaPosition exceeds this threshold, a rotation recovery procedure is initiated", units="unitless", range="0..2181120", category="carousel")
    private volatile int recoveryStandbyDeltaPosition = 110;
    private final int fullTurn = 4362240;
    private final int halfTurn = 2181120;
    @ConfigurationParameter(description="Velocity in slow mode.", units="rpm", range="0..5000", category="carousel")
    public volatile int slowVelocity = 500;
    @ConfigurationParameter(description="Acceleration in slow mode.", units="rpm/s", range="0..5000", category="carousel")
    public volatile int slowAcceleration = 200;
    @ConfigurationParameter(description="Deceleration in slow mode.", units="rpm/s", range="0..5000", category="carousel")
    public volatile int slowDeceleration = 200;
    @ConfigurationParameter(description="Timeout for the rotation in slow mode.", units="millisecond", range="0..300000", category="carousel")
    public volatile int slowRotationTimeout = 100000;
    @ConfigurationParameter(description="Velocity in fast mode.", units="rpm", range="0..5000", category="carousel")
    public volatile int fastVelocity = 3400;
    @ConfigurationParameter(description="Acceleration in fast mode.", units="rpm/s", range="0..5000", category="carousel")
    public volatile int fastAcceleration = 2000;
    @ConfigurationParameter(description="Deceleration in fast mode.", units="rpm/s", range="0..5000", category="carousel")
    public volatile int fastDeceleration = 1000;
    @ConfigurationParameter(description="Timeout for the rotation in fast mode.", units="millisecond", range="0..300000", category="carousel")
    public volatile int fastRotationTimeout = 20000;
    @ConfigurationParameter(description="Time to wait for the protection system to update its status after motion events.", units="millisecond", range="0..5000", category="carousel")
    public volatile long timeToUpdateProtectionSystem = 2000L;
    @ConfigurationParameter(description="For command unlock of carousel clamp : current to send to prepare unlock", range="-3200..3200", units="mA", category="carousel")
    protected volatile int currentToPrepareUnlock = -100;
    @ConfigurationParameter(description="For command unlock of carousel clamp : time between little current to prepare hardware and currentToLock ", range="0..500", units="millisecond", category="carousel")
    protected volatile int timeToPrepareUnlock = 200;
    @ConfigurationParameter(description="A current to be sent to clampXminus controller during locking recovery.", units="mA", range="0..1000", category="carousel")
    public volatile int recoveryLockingCurrent = 400;
    @ConfigurationParameter(description="If the velocity in clampXminus controller goes over this value during locking recovery, it means that the recovery process has failed. [rpm]", units="unitless", range="0..100", category="carousel")
    public volatile int recoveryMaxVelocity = 60;
    @ConfigurationParameter(description="A number of steps to go back if after rotation carousel position has exceeded standbyPosition by more than maxStandbyDeltaPosition.", units="micron", range="0..2181120", category="carousel")
    public volatile int recoveryBackwardStep = 10000;
    @ConfigurationParameter(description="Number of steps to go forward if after rotation carousel position has exceeded standbyPosition by more than maxStandbyDeltaPosition.", units="micron", range="0..2181120", category="carousel")
    public volatile int recoveryForwardStep = 150000;
    @ConfigurationParameter(range="0..30000", description="Upper brake1 (bay I) limit for state CLOSED", units="mV", category="carousel")
    private volatile int brake1Limit = 19033;
    @ConfigurationParameter(range="0..30000", description="Upper brake2 (bay N) limit for state CLOSED", units="mV", category="carousel")
    private volatile int brake2Limit = 16959;
    @ConfigurationParameter(range="0..30000", description="Upper brake3 (bay X) limit for state CLOSED", units="mV", category="carousel")
    private volatile int brake3Limit = 21063;
    private FcsEnumerations.BrakeState brakeState1;
    private FcsEnumerations.BrakeState brakeState2;
    private FcsEnumerations.BrakeState brakeState3;
    private static int BRAKE_NO_SENSOR_LIMIT = 500;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/clampXminusController")
    private EPOSController clampXminusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/clampXplusController")
    private EPOSController clampXplusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/carouselController")
    protected EPOSControllerForCarousel carouselController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/hyttc580")
    private TTC580Interface hyttc580;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/ai814")
    protected ADCInterface ai814;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/pt100")
    private PT100Interface pt100;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/accelerobf")
    public AcceleroInterface accelerobf;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, CarouselSocket> socketsMap = new TreeMap<String, CarouselSocket>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Map<String, SensorPluggedOnTTC580> sensorsMap = new HashMap<String, SensorPluggedOnTTC580>();
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="canbus0")
    protected BridgeToHardware tcpProxy;
    private boolean initialized = false;
    protected boolean clampsStateInitialized = false;
    @Persist
    private volatile boolean available = true;
    private int socketAtStandbyID;
    protected CarouselSocket socketAtStandby;
    protected volatile int minLockedThreshold = 9500;
    @ConfigurationParameter(description="If lockSensor side X- returns a value < lockSensorMinLimitXminus, sensor is in ERROR.", range="0..12000", units="mV", category="carousel")
    private volatile int lockSensorMinLimitXminus = 201;
    @ConfigurationParameter(description="If lockSensor side X+ returns a value < lockSensorMinLimitXplus, sensor is in ERROR.", range="0..12000", units="mV", category="carousel")
    private volatile int lockSensorMinLimitXplus = 202;
    @ConfigurationParameter(description="If lockSensor side X- returns a value above lockSensorMaxLimitXminus, the sensor is in error.", range="0..12000", units="mV", category="carousel")
    private volatile int lockSensorMaxLimitXminus = 10001;
    @ConfigurationParameter(description="If lockSensor side X+ returns a value above lockSensorMaxLimitXplus, the sensor is in error.", range="0..12000", units="mV", category="carousel")
    private volatile int lockSensorMaxLimitXplus = 11002;
    @ConfigurationParameter(description="Minimum value of filter presence sensor without filter. Generic value used by all carousel clamps", range="0..12000", units="mV", category="carousel")
    private volatile int filterPresenceMinNoFilter = 9200;
    @ConfigurationParameter(description="If difference between offset read on hyttc580 and persisted offset is over this limit an ALARM is launched", range="0..1000", units="mV", category="carousel")
    private volatile int maxClampsOffsetDelta = 100;
    @ConfigurationParameter(description="If true powerSaveActivate is activated at the end of setFilter command.", units="unitless", category="carousel")
    private volatile boolean powerSaveAllowed = true;
    private double meanClampsTemperature;
    private PersistentCounter rotateCounter;
    private AtomicLong lastUpdateLockSensorMinLocked = new AtomicLong(0L);
    private AtomicLong lastUpdateStateWithSensors = new AtomicLong(0L);
    private AtomicLong lastUpdateTemperatures = new AtomicLong(0L);

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByCarousel.class, this.name);
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByCarouselBrakes.class, this.name + "/brakes");
        this.movementCounter = new EnumMap(FcsEnumerations.MobileItemAction.class);
        for (FcsEnumerations.MobileItemAction action : new FcsEnumerations.MobileItemAction[]{FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION, FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION}) {
            this.registerActionDuration(action);
            this.movementCounter.put(action, PersistentCounter.newCounter(action.getActionCounterPath(this.path), this.subs, action.name()));
        }
        this.rotateCounter = PersistentCounter.newCounter(FcsEnumerations.GeneralAction.ROTATE_SOCKET_TO_STANDBY.getCounterPath(), this.subs, FcsEnumerations.GeneralAction.ROTATE_SOCKET_TO_STANDBY.name());
        this.registerHighLevelActionDuration(FcsEnumerations.GeneralAction.ROTATE_SOCKET_TO_STANDBY);
        this.agentStateService.registerState(FcsEnumerations.HoldingBrakesState.class, "Carousel Holding Brakes", (Object)this);
        this.agentStateService.updateAgentComponentState((Object)this, new Enum[]{FcsEnumerations.HoldingBrakesState.FALSE});
    }

    public void init() {
        super.init();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.carouselController.getName()), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.IN_FAULT.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY_FAILURE.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY_SUCCESS.getAlert(this.name), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if CANopen devices are booted and initialized and homing has been done.")
    boolean isInitialized() {
        return this.myDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if power save can be activated at the end of setFilter command.")
    public boolean isPowerSaveAllowed() {
        return this.powerSaveAllowed;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Set allowPoserSave.")
    public void setPowerSaveAllowed(boolean powerSaveAllowed) {
        this.powerSaveAllowed = powerSaveAllowed;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carousel is able to rotate or false if not.")
    public boolean isAvailable() {
        return this.available;
    }

    @Command(type=Command.CommandType.QUERY, level=2, description="Flag carousel rotation as unavailable if false or available if true. If available is false, this command should be used to return to 'available' only after FES engineers have been consulted.")
    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isRotationAllowedByPLC() {
        return this.sensorsMap.get("carousel/plc/caEnableRotation").getValue() == 1;
    }

    public boolean isUnclampAllowedByPLC() {
        return this.sensorsMap.get("carousel/plc/caEnableUnclamp").getValue() == 1;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if clamp state is initialized for all clamps.")
    public boolean isClampsStateInitialized() {
        return this.clampsStateInitialized;
    }

    public int getCurrentToPrepareUnlock() {
        return this.currentToPrepareUnlock;
    }

    public int getTimeToPrepareUnlock() {
        return this.timeToPrepareUnlock;
    }

    public Integer getMinLockedThreshold() {
        return this.minLockedThreshold;
    }

    public int getLockSensorMinLimitXminus() {
        return this.lockSensorMinLimitXminus;
    }

    public int getLockSensorMinLimitXplus() {
        return this.lockSensorMinLimitXplus;
    }

    public int getLockSensorMaxLimitXminus() {
        return this.lockSensorMaxLimitXminus;
    }

    public int getLockSensorMaxLimitXplus() {
        return this.lockSensorMaxLimitXplus;
    }

    public int getFilterPresenceMinNoFilter() {
        return this.filterPresenceMinNoFilter;
    }

    public int getRecoveryLockingCurrent() {
        return this.recoveryLockingCurrent;
    }

    public int getRecoveryMaxVelocity() {
        return this.recoveryMaxVelocity;
    }

    public int getMaxClampsOffsetDelta() {
        return this.maxClampsOffsetDelta;
    }

    public int getFullTurn() {
        return 4362240;
    }

    public Map<String, CarouselSocket> getSocketsMap() {
        return this.socketsMap;
    }

    public CarouselSocket getSocketByName(String socketName) {
        if (this.socketsMap.containsKey(socketName)) {
            return this.socketsMap.get(socketName);
        }
        throw new IllegalArgumentException(this.name + ": no such name for socket:" + socketName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return carousel position.", alias="printPosition")
    public int getPosition() {
        return this.position;
    }

    public EPOSController getClampXminusController() {
        return this.clampXminusController;
    }

    public EPOSController getClampXplusController() {
        return this.clampXplusController;
    }

    public CarouselClamp getClampXminus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXminus();
    }

    public CarouselClamp getClampXplus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXplus();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a socket is HALTED at STANDBY position, false otherwise.")
    public boolean isAtStandby() {
        return this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5;
    }

    public CarouselSocket getSocketAtStandby() {
        return this.socketAtStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return ID of socket at STANDBY, 0 if carousel is not stopped at STANDBY")
    public int getSocketAtStandbyID() {
        return this.socketAtStandbyID;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns name of filter at STANDBY position  or NO_FILTER if carousel is not at STANDBY or there is no filter at STANDBY.")
    public String getFilterAtStandbyName() {
        if (this.socketAtStandby == null || this.isEmptyAtStandby()) {
            return "NO FILTER";
        }
        return this.socketAtStandby.getFilterName();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns ID of filter at STANDBY position  or 0 if there is no filter at STANDBY.")
    public int getFilterIDatStandby() {
        if (this.socketAtStandby == null) {
            return 0;
        }
        return this.socketAtStandby.getFilterID();
    }

    public boolean isFilterOnCarousel(int filterID) {
        return this.socketsMap.values().stream().anyMatch(socket -> socket.getFilterID() == filterID);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To change filterID on socket which ID is given as argument.")
    public void changeFilterID(int filterID, int socketID) {
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + ": bad value - enter a digit between 1 and 5");
        }
        if (this.isFilterOnCarousel(filterID)) {
            int sockID = this.getFilterSocket(filterID).getId();
            throw new IllegalArgumentException(filterID + " filter already on carousel on socket" + sockID);
        }
        String socketName = "socket" + socketID;
        this.socketsMap.get(socketName).setFilterID(filterID);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize carousel hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.tcpProxy.bootProcess();
        this.postStart();
    }

    public void postStart() {
        FCSLOG.info(this.name + " BEGIN postStart.");
        if (this.carouselController.isBooted()) {
            this.initializeRotationController();
            long profileVelocity = this.carouselController.readProfileVelocity();
            this.carouselController.readProfileAcceleration();
            this.carouselController.readProfileDeceleration();
            this.rotationTimeout = profileVelocity == (long)this.slowVelocity ? this.slowRotationTimeout : this.fastRotationTimeout;
            try {
                this.updatePosition();
            }
            catch (ControllerFaultException ex) {
                FCSLOG.log(Level.SEVERE, "Carousel controller failed to start", ex);
                this.raiseAlarm(FcsEnumerations.FcsAlert.IN_FAULT, ex.toString(), this.name);
            }
            this.updateHoldingBrakesState();
        }
        if (this.clampXminusController.isBooted()) {
            this.initializeClampController(this.clampXminusController);
        }
        if (this.clampXplusController.isBooted()) {
            this.initializeClampController(this.clampXplusController);
        }
        if (this.hyttc580.isBooted()) {
            this.initializeClampsState();
            this.initializeAndCheckClampsOffset();
        }
        this.hyttc580.checkTTC580Temperatures();
        if (this.isPowerSaveActivated()) {
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.CarouselPowerState.LOW_POWER});
        } else {
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.CarouselPowerState.REGULAR});
        }
        FCSLOG.info(this.name + " END postStart.");
    }

    private void initializeRotationController() {
        try {
            this.carouselController.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.carouselController.getName(), (Exception)ex);
        }
    }

    private void initializeClampController(EPOSController controller) {
        try {
            controller.initializeAndCheckHardware();
            if (!controller.isInMode(EPOSEnumerations.EposMode.CURRENT)) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " is not in CURRENT mode.", controller.getName());
            }
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller ", controller.getName(), (Exception)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Disable carousel controller, set the position sensor to TypeEncoderSSI, and check that the ssi position is correct.")
    public void setControllerPositionSensorTypeEncoderSSI() {
        this.carouselController.setPositionSensorTypeEncoderSSI();
        this.position = this.carouselController.readPosition();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="slow down profile velocity, acceleration and deceleration in carousel controller.")
    public void setSlowMode() {
        this.carouselController.changeProfileVelocity(this.slowVelocity);
        this.carouselController.changeProfileAcceleration(this.slowAcceleration);
        this.carouselController.changeProfileDeceleration(this.slowDeceleration);
        this.rotationTimeout = this.slowRotationTimeout;
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="raise profile velocity, acceleration and deceleration in carousel controller.")
    public void setFastMode() {
        this.carouselController.changeProfileVelocity(this.fastVelocity);
        this.carouselController.changeProfileAcceleration(this.fastAcceleration);
        this.carouselController.changeProfileDeceleration(this.fastDeceleration);
        this.rotationTimeout = this.fastRotationTimeout;
        this.publishData();
    }

    public void waitForProtectionSystemUpdate() {
        this.waitForStateUnclampedOnFilter(this.timeToUpdateProtectionSystem);
    }

    public void waitForStateUnclampedOnFilter(long timeout) {
        FcsUtils.waitCondition(() -> this.isUnclampedOnFilterAtStandby(), () -> this.updateSocketAtStandbyReadSensorsNoPublication(), "waitForStateUnclampedOnFilter", timeout);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Wait until socket at STANDBY is awake")
    public void waitUntilCarouselIsAwake() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("waitUntilCarouselIsAwake");){
            FcsUtils.checkAndWaitConditionWithTimeoutAndFixedDelay(() -> this.isAwake(), () -> this.updateCarouselIOStatus(), "checkCarouselIsAwake", this.name + ": Carousel is still not awake after trying every 100ms during 5s", 5000L, 100L);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Power save deactivate and wait until all ttc30 are awake")
    public void powerWakeupTest() {
        this.powerOn();
        this.waitUntilCarouselIsAwake();
    }

    private void updateCarouselIOStatus() {
        this.tcpProxy.updatePDOData();
        this.updateState();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return true if a socket is at STANDBY and is awake or if all sockets are awake")
    public boolean isAwake() {
        return this.isSocketAtStandbyAwake() || this.allSocketsAwake();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a socket is at STANDBY and available")
    public boolean isSocketAtStandbyAvailable() {
        if (this.socketAtStandby != null) {
            return this.socketAtStandby.isAvailable();
        }
        return false;
    }

    public boolean isSocketAtStandbyAwake() {
        return this.socketsMap.values().stream().anyMatch(socket -> socket.isAwake() && socket.isAtStandby());
    }

    public boolean allSocketsAwake() {
        return this.socketsMap.values().stream().allMatch(socket -> socket.isAwake());
    }

    public void checkSensorTypeIncremental() {
        int sensorType = this.carouselController.readPositionSensorType();
        if (sensorType != 8) {
            throw new FcsHardwareException(this.name + " PositionSensorType has to be set to Incremental Encoder before motion.");
        }
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCarousel()));
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name + "/brakes", (Serializable)this.createStatusDataPublishedByCarouselBrakes()));
    }

    public StatusDataPublishedByCarousel createStatusDataPublishedByCarousel() {
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel();
        status.setPosition(this.position);
        status.setPositionSensorType(this.carouselController.getPositionSensorType());
        status.setEstimatedPosition((this.startPosition + this.position) % 4362240);
        status.setAtStandby(this.isAtStandby());
        status.setMoving(this.moving);
        status.setSocketAtStandbyID(this.socketAtStandbyID);
        status.setFilterAtStandbyName(this.getFilterAtStandbyName());
        status.setFilterAtStandbyId(this.getFilterIDatStandby());
        if (this.isAtStandby()) {
            status.setSocketAtStandbyName(this.socketAtStandby.getName());
            status.setEmptyAtStandby(this.isEmptyAtStandby());
            status.setDeltaPositionAtStandby(this.socketAtStandby.getDeltaPosition());
            status.setClampsStateAtStandby(this.socketAtStandby.getClampsState());
            status.setIOStatusAtStandby(this.socketAtStandby.getIOModuleStatus());
        } else if (this.isPowerSaveActivated()) {
            status.setSocketAtStandbyName("POWER_SAVE");
        } else if (this.socketAtStandbyID == 0) {
            status.setSocketAtStandbyName("NO_SOCKET_AT_STANDBY");
        } else if (this.socketAtStandbyID == 7) {
            status.setSocketAtStandbyName("ERROR_READING_ID");
        }
        status.setRotationTimeout((long)this.rotationTimeout);
        status.setMinLocked((long)this.minLockedThreshold);
        status.setMeanClampsTemperature(this.meanClampsTemperature);
        status.setAvailable(this.available);
        return status;
    }

    public StatusDataPublishedByCarouselBrakes createStatusDataPublishedByCarouselBrakes() {
        StatusDataPublishedByCarouselBrakes status = new StatusDataPublishedByCarouselBrakes();
        status.setSensor1(this.ai814.getInput(0));
        status.setSensor2(this.ai814.getInput(1));
        status.setSensor3(this.ai814.getInput(2));
        status.setBrakeState1(Carousel.computeBrakeState(this.brake1Limit, this.ai814.getInput(0)));
        status.setBrakeState2(Carousel.computeBrakeState(this.brake2Limit, this.ai814.getInput(1)));
        status.setBrakeState3(Carousel.computeBrakeState(this.brake3Limit, this.ai814.getInput(2)));
        status.setTemperature1(this.pt100.getTemperature(1));
        status.setTemperature2(this.pt100.getTemperature(2));
        status.setTemperature3(this.pt100.getTemperature(3));
        status.setTemperature4(this.pt100.getTemperature(4));
        return status;
    }

    private static FcsEnumerations.BrakeState computeBrakeState(int limit, long sensorValue) {
        if (sensorValue > (long)limit) {
            return FcsEnumerations.BrakeState.CLOSED;
        }
        if (sensorValue > (long)BRAKE_NO_SENSOR_LIMIT) {
            return FcsEnumerations.BrakeState.NO_BRAKE;
        }
        return FcsEnumerations.BrakeState.NO_SENSOR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if Carousel is stopped and no filter is at STANDBY position")
    public boolean isReadyToGrabAFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (this.socketAtStandby == null) {
            return false;
        }
        if (!this.socketAtStandby.isAvailable()) {
            return false;
        }
        return this.socketAtStandby.isEmpty() && this.socketAtStandby.isReadyToClamp();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if a filter is clamped at STANDBY position")
    public boolean isHoldingFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (this.socketAtStandby == null || this.socketAtStandby.isEmpty()) {
            return false;
        }
        return this.socketAtStandby.isClampedOnFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns false if carousel controller is SWITCH_ON_DISABLED.")
    public boolean isRotating() {
        return !this.carouselController.isInState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="PLC value for carousel brakes activated")
    public boolean isStatusBrakesActivated() {
        return this.sensorsMap.get("carousel/plc/caBrakesActivated").getValue() == 1;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="PLC value for carousel power save activated")
    public boolean isPowerSaveActivated() {
        return this.sensorsMap.get("carousel/plc/powerSave").getValue() == 1;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="NO_BRAKE signal on all 3 AI814 sensors")
    public boolean areBrakesDisabledFromAI814() {
        boolean brake1Disabled = this.brakeState1 == FcsEnumerations.BrakeState.NO_SENSOR || this.brakeState1 == FcsEnumerations.BrakeState.NO_BRAKE;
        boolean brake2Disabled = this.brakeState2 == FcsEnumerations.BrakeState.NO_SENSOR || this.brakeState2 == FcsEnumerations.BrakeState.NO_BRAKE;
        boolean brake3Disabled = this.brakeState3 == FcsEnumerations.BrakeState.NO_SENSOR || this.brakeState3 == FcsEnumerations.BrakeState.NO_BRAKE;
        return brake1Disabled && brake2Disabled && brake3Disabled;
    }

    protected boolean areBrakesAllowingRotation() {
        return !this.carouselController.isHoldingBrakes() && !this.isStatusBrakesActivated() && this.areBrakesDisabledFromAI814();
    }

    private void updateBrakesStatesFromAI814() {
        this.brakeState1 = Carousel.computeBrakeState(this.brake1Limit, this.ai814.getInput(0));
        this.brakeState2 = Carousel.computeBrakeState(this.brake2Limit, this.ai814.getInput(1));
        this.brakeState3 = Carousel.computeBrakeState(this.brake3Limit, this.ai814.getInput(2));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update brakes status from all sensors")
    public void updateBrakesStatus() {
        this.updateHoldingBrakesState();
        this.tcpProxy.updatePDOData();
        this.updateBrakesStatesFromAI814();
    }

    protected void updateHoldingBrakesState() {
        boolean hb = this.carouselController.readHoldingBrakes();
        if (hb) {
            this.agentStateService.updateAgentComponentState((Object)this, new Enum[]{FcsEnumerations.HoldingBrakesState.TRUE});
        } else {
            this.agentStateService.updateAgentComponentState((Object)this, new Enum[]{FcsEnumerations.HoldingBrakesState.FALSE});
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Set position sensor type SSI and update carousel position in reading controller.")
    public void updatePosition() {
        this.setControllerPositionSensorTypeEncoderSSI();
        try {
            this.position = this.carouselController.readPosition();
        }
        catch (SDORequestException ex) {
            FCSLOG.log(Level.WARNING, this.name + "=> ERROR IN READING CONTROLLER:", ex);
        }
        this.publishData();
    }

    public void updateClampsStateWithSensorsFromPDO() {
        this.tcpProxy.updatePDOData();
        PDOData pdoStore = this.tcpProxy.getPDOData();
        FCSLOG.finest(() -> this.name + ":pdoStore=" + pdoStore.toString());
        this.socketsMap.values().stream().forEach(socket -> socket.updateState());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamps state in sending 5 sync.")
    public void initializeClampsState() {
        FCSLOG.info(this.name + " Initializing clamps state....");
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        for (byte count = 1; count <= 5; count = (byte)(count + 1)) {
            FCSLOG.finer(this.name + " sync no " + count);
            this.tcpProxy.updatePDOData();
            this.hyttc580.updateFromPDO(this.tcpProxy.getPDOData());
            this.updateState();
        }
        this.clampsStateInitialized = true;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carousel clamps offset1 and offset2 in reading hyttc580 and launch an ALARM if values read and different from previous values. The new values are saved in persistence file.")
    public void initializeAndCheckClampsOffset() {
        FCSLOG.info(this.name + " Initializing clamps offsets....");
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        this.socketsMap.values().stream().forEach(socket -> {
            byte socketId = (byte)socket.getId();
            long offset2 = this.hyttc580.readOffset2SDO(socketId);
            socket.checkAndUpdateOffset2(offset2);
            long offset1 = this.hyttc580.readOffset1SDO(socketId);
            socket.checkAndUpdateOffset1(offset1);
            socket.getClampXminus().publishData();
            socket.getClampXplus().publishData();
        });
        this.subs.getAgentPersistenceService().persistNow();
    }

    public CarouselSocket getFilterSocket(int filterID) {
        CarouselSocket socket = null;
        for (CarouselSocket sock : this.socketsMap.values()) {
            if (sock.getFilterID() != filterID) continue;
            return sock;
        }
        return socket;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release clamps at STANDBY position to get ready to clamp again")
    public void releaseClamps() {
        this.updateStateWithSensors();
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't release clamps when no socket is halted at STANDBY position.");
        }
        this.socketAtStandby.releaseClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamps at STANDBY.")
    public void unlockClamps() {
        this.updateSocketAtStandbyReadSensorsNoPublication();
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't unlock clamps while a socket is not halted at STANDBY position.");
        }
        FCSLOG.info("Unlocking clamps at STANDBY.");
        this.socketAtStandby.unlockClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock clampXminus when clampXplus is already locked.")
    public void recoveryLockingXminus() {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't use command recoveryLockingXminus.");
        }
        if (this.socketAtStandby.getClampXplus().getClampState() == FcsEnumerations.FilterClampState.CLAMPED_ON_FILTER && this.socketAtStandby.getClampXminus().getClampState() != FcsEnumerations.FilterClampState.CLAMPED_ON_FILTER) {
            this.socketAtStandby.getClampXminus().recoveryLocking();
        }
    }

    @Deprecated
    public boolean isAtStandby(int filterID) {
        return this.socketAtStandby.getFilterID() != 0 && this.socketAtStandby.getFilterID() == filterID;
    }

    @Override
    public boolean myDevicesReady() {
        return this.carouselController.isBooted() && this.carouselController.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if carousel rotation is permitted.")
    public void checkConditionsForRotation() {
        if (!this.initialized) {
            throw new FcsHardwareException("Carousel hardware is not initialized. Can't rotate.");
        }
        if (this.isAtStandby() && this.socketAtStandby.isUnclampedOnFilter()) {
            String message = "Filter at STANDBY position is not held by clamps. Can't rotate carousel.";
            FCSLOG.severe(message);
            throw new RejectedCommandException(message);
        }
        if (!this.autochanger.isAtHandoff()) {
            throw new RejectedCommandException(this.name + " can't rotate if autochanger is not at HANDOFF position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to a new absolute position.", timeout=60000)
    public void rotateToAbsolutePosition(int newPos) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("rotateToAbsolutePosition");){
            int absolutePosition;
            if (this.pt100.isBooted()) {
                this.pt100.updateTemperatures();
            }
            this.checkReadyForAction();
            if (this.isPowerSaveActivated()) {
                throw new RejectedCommandException(this.name + " can't rotate because power save is activated");
            }
            this.carouselController.checkInitialized();
            this.carouselController.checkFault();
            if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                throw new RejectedCommandException(this.name + " can rotate only if autochanger is at Handoff or at Online  ");
            }
            double airmass = this.accelerobf.getAirmass();
            if (airmass > 3.0) {
                this.setSlowMode();
            } else {
                this.setFastMode();
            }
            FcsUtils.sleep(10, this.name);
            this.carouselController.setPositionSensorTypeEncoderSSI();
            this.startPosition = absolutePosition = this.carouselController.readPosition();
            this.carouselController.setPositionSensorTypeSinusIncrementalEncoder();
            int incrementalPosition = this.carouselController.readPosition();
            FCSLOG.info(this.name + " absolutePosition = " + absolutePosition + " incrementalPosition = " + incrementalPosition);
            int diffPos = newPos - absolutePosition;
            this.absoluteTargetPosition = Math.abs(diffPos) <= 2181120 ? diffPos + incrementalPosition : (diffPos < 0 ? diffPos + incrementalPosition + 4362240 : diffPos + incrementalPosition - 4362240);
            FCSLOG.info(this.name + " is at incremental position: " + incrementalPosition + "; about to rotate to incremental position" + this.absoluteTargetPosition);
            this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION, this.rotationTimeout);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to a relative position.", timeout=60000)
    public void rotateToRelativePosition(int relativePos, long timeout) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("rotateToRelativePosition");){
            this.carouselController.checkInitialized();
            this.carouselController.checkFault();
            if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                throw new RejectedCommandException(this.name + " can rotate only if autochanger is at Handoff or at Online.");
            }
            this.carouselController.setPositionSensorTypeSinusIncrementalEncoder();
            int incrementalPosition = this.carouselController.readPosition();
            this.relativeTargetPosition = relativePos + incrementalPosition;
            this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION, timeout);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a socket which name is given as argument to STANDBY position.", alias="moveSocketToStandby", timeout=50000)
    public void rotateSocketToStandby(String socketName) {
        FcsUtils.checkSocketName(socketName);
        CarouselSocket socketToMove = this.socketsMap.get(socketName);
        if (!socketToMove.isAtStandby() || this.socketAtStandbyNeedsRotation(socketToMove)) {
            long beginTime = System.currentTimeMillis();
            this.rotateCounter.increment();
            int requiredPosition = socketToMove.getStandbyPosition();
            FCSLOG.info(this.name + " is at position: " + this.position + "; about to rotate to position: " + requiredPosition);
            this.rotateToAbsolutePosition(requiredPosition);
            this.checkDeltaPosition();
            this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(FcsEnumerations.GeneralAction.ROTATE_SOCKET_TO_STANDBY.getDurationPath(), (Serializable)Long.valueOf(System.currentTimeMillis() - beginTime)));
        }
        FCSLOG.info(this.name + ":" + socketName + " is at STANDBY position on carousel.");
    }

    public void checkDeltaPosition() {
        if (this.socketAtStandby != null) {
            this.socketAtStandby.updateDeltaPosition();
            if (this.socketAtStandbyNeedsRotation(this.socketAtStandby)) {
                this.recoveryRotation();
            }
        }
    }

    private boolean socketAtStandbyNeedsRotation(CarouselSocket socket) {
        socket.updateDeltaPosition();
        return Math.abs(socket.getDeltaPosition()) > this.recoveryStandbyDeltaPosition;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel full turn. A number of turns can be given as argument.")
    public void rotateFullTurn(int nbTurn) {
        if (Math.abs(nbTurn) > 3) {
            throw new IllegalArgumentException("nbTurn=" + nbTurn + " should not be more than 3");
        }
        long timeout = Math.abs(nbTurn) * 2 * this.slowRotationTimeout;
        int relativePosition = 4362240 * nbTurn;
        this.rotateToRelativePosition(relativePosition, timeout);
    }

    private void recoveryRotation() {
        if (!this.autochanger.isAtOnline() && !this.autochanger.isAtHandoff()) {
            FCSLOG.info(this.name + " can rotate only if autochanger is at HANDOFF or ONLINE. Can't execute recoveryRotation.");
            return;
        }
        double airmass = this.accelerobf.getAirmass();
        if (airmass > 2.0) {
            this.recoveryRotationBackward();
            if (Math.abs(this.socketAtStandby.getDeltaPosition()) > this.recoveryStandbyDeltaPosition) {
                this.recoveryRotationStraight();
            }
        } else {
            this.recoveryRotationStraight();
            this.socketAtStandby.updateDeltaPosition();
            if (Math.abs(this.socketAtStandby.getDeltaPosition()) > this.recoveryStandbyDeltaPosition) {
                this.recoveryRotationBackward();
            }
        }
        this.socketAtStandby.updateDeltaPosition();
        if (Math.abs(this.socketAtStandby.getDeltaPosition()) > this.maxStandbyDeltaPosition) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY_FAILURE, String.format("After 2 recovery tries delta position at STANDBY is %s is still over %s.\n", this.socketAtStandby.getDeltaPosition(), this.maxStandbyDeltaPosition) + "The operator should use recoveryRotationForward to align the carousel to the STANDBY position.", this.name);
        } else {
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY_SUCCESS, "After recovery delta position at STANDBY is " + this.socketAtStandby.getDeltaPosition(), this.name);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Triggered when the carousel's position exceeds the STANDBY position by more than deltaPositionMax (typically around 200).\nExplanation: if the selected carousel socket for a filter exchange between the autochanger and the carousel has a significant offset from the STANDBY position, the operation will be halted or prevented. To resolve this issue, the carousel socket must be aligned with the STANDBY position using a dedicated recovery rotation command.\nThis command attempts to align the carousel socket with the STANDBY position by reversing the previous movement and then rotating back to the STANDBY position while compensating for any offset (to account for play in the brakes).\nThis method is the most precise and reliable but is slower (approximately 7 seconds). It is recommended for use when recoveryRotationStraight fails or when dealing with large imbalances in filter configuration (such as during filter loading/unloading from the camera).\nThe FCS will automatically try a recovery if needed. If it fails, the operator should use recoveryRotationForward to align the carousel to the STANDBY Position.")
    public void recoveryRotationBackward() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " it seems that no Carousel socket is at STANDBY position, meaning that recoveryRotationBackward is not relevant here. It might be that the socket IOModule is not responding correctly. Some ideas to consider: first check the IO Status on the  carousel socket panel and verify the STANDBY position and actual positions. If IO Status is unknown but the carousel socket seems at STANDBY, then the only way out is to perform a restart of the FCS along with a powercycle of the carousel 24V and 48V and the FES PLC. Instructions for this can be found on the Camera Confluence.");
        }
        int deltaPositionAtStandby = this.socketAtStandby.getDeltaPosition();
        this.raiseWarning(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY, String.format(" |delta position at STANDBY| = %d is over %d about to try recoveryRotationBackward", this.socketAtStandby.getDeltaPosition(), this.recoveryStandbyDeltaPosition), this.name);
        int delta_sign = deltaPositionAtStandby >= 0 ? 1 : -1;
        int relativePosition = delta_sign * this.recoveryBackwardStep;
        FCSLOG.info(this.name + " about to rotateToRelativePosition " + relativePosition);
        this.rotateToRelativePosition(relativePosition, 7000L);
        int newPos = this.socketAtStandby.getStandbyPosition() - deltaPositionAtStandby;
        FCSLOG.info(this.name + " about to rotateToAbsolutePosition to " + newPos);
        this.rotateToAbsolutePosition(newPos);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Triggered when the carousel's position exceeds the STANDBY position by more than deltaPositionMax (typically around 200).\nExplanation: if the selected carousel socket for a filter exchange between the autochanger and the carousel has a significant offset from the STANDBY position, the operation will be halted or prevented. To resolve this issue, the carousel socket must be aligned with the STANDBY position using a dedicated recovery rotation command.\nThis command attempts to align the carousel socket with the STANDBY position by reversing the previous movement and then rotating back to the STANDBY position while compensating for any offset (to account for play in the brakes).\nThis method is less precise than the other recovery methods.\nIt is recommended for use when recoveryRotationStraight and recoveryRotationBackward have both failed.\nThe FCS will automatically try a recovery if needed. If it fails, the operator should use recoveryRotationForward to align the carousel to the STANDBY Position.")
    public void recoveryRotationForward() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " no socket at STANDBY method recoveryRotationForward is not relevant.");
        }
        int deltaPositionAtStandby = this.socketAtStandby.getDeltaPosition();
        int delta_sign = deltaPositionAtStandby >= 0 ? 1 : -1;
        int relativePosition = -delta_sign * this.recoveryForwardStep;
        FCSLOG.info(this.name + " about to rotateToRelativePosition " + relativePosition);
        this.rotateToRelativePosition(relativePosition, 7000L);
        int newPos = this.socketAtStandby.getStandbyPosition();
        FCSLOG.info(this.name + " about to rotateToAbsolutePosition to " + newPos);
        this.rotateToAbsolutePosition(newPos);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Triggered when the carousel's position exceeds the STANDBY position by more than deltaPositionMax (typically around 200).\nExplanation: if the selected carousel socket for a filter exchange between the autochanger and the carousel has a significant offset from the STANDBY position, the operation will be halted or prevented. To resolve this issue, the carousel socket must be aligned with the STANDBY position using a dedicated recovery rotation command.\nThis command attempts to align the carousel socket with the STANDBY position by executing a straightforward rotation to correct the measured misalignment. This method is the fastest (~3s) and is generally effective, especially when the camera is not positioned horizontally and the filter weight imbalance is minimal.\nIt is recommended to use that one first.\nThe FCS will automatically try a recovery if needed. If it fails, the operator should use recoveryRotationForward to align the carousel to the STANDBY Position.")
    public void recoveryRotationStraight() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " no socket at STANDBY method recoveryRotationForward is not relevant.");
        }
        int deltaPositionAtStandby = this.socketAtStandby.getDeltaPosition();
        this.raiseWarning(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY, String.format(" |delta position at STANDBY| = %d is over %d about to try recoveryRotationStraight", this.socketAtStandby.getDeltaPosition(), this.recoveryStandbyDeltaPosition), this.name);
        int newPos = this.socketAtStandby.getStandbyPosition() - deltaPositionAtStandby;
        FCSLOG.info(this.name + " about to rotateToAbsolutePosition to " + newPos);
        this.rotateToAbsolutePosition(newPos);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            return this.carouselController.isTargetReached();
        }
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            return this.carouselController.isTargetReached();
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensorsDuringMotion();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.main.updateAgentState(FcsEnumerations.FilterState.valueOf((String)"ROTATING"));
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            this.carouselController.enableAndWriteRelativePosition(this.relativeTargetPosition);
        } else if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            this.carouselController.writeTargetPosition(this.absoluteTargetPosition);
            FcsUtils.checkAndWaitConditionWithTimeoutAndFixedDelay(() -> this.isRotationAllowedByPLC(), () -> this.tcpProxy.updatePDOData(), "checkRotationAllowedByPLC", this.name + ": PLC did not allow motion after trying every 100ms during 500 ms", 500L, 100L);
            FcsUtils.sleep(100, this.name);
            this.carouselController.goToOperationEnable();
            this.updateBrakesStatus();
            if (!this.areBrakesAllowingRotation()) {
                FcsUtils.checkAndWaitConditionWithTimeout(() -> this.areBrakesAllowingRotation(), () -> this.updateBrakesStatus(), "checkCarouselBrakesReleased", this.name + ": carousel brakes are still activated.", 500L);
            }
            this.carouselController.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION_AND_MOVE);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.finer(() -> this.name + " is ABORTING action " + action.toString() + " within delay " + delay);
        this.carouselController.stopPosition();
        this.carouselController.goToSwitchOnDisabled();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.finer(() -> this.name + " is ENDING action " + action.toString());
        int deltaPosBeforeDisable = this.position - this.absoluteTargetPosition;
        FCSLOG.info(this.name + " delta position before disable = " + deltaPosBeforeDisable);
        this.carouselController.goToSwitchOnDisabled();
        this.main.updateAgentState(FcsEnumerations.FilterState.valueOf((String)"CAROUSEL_STOPPED"));
        this.setControllerPositionSensorTypeEncoderSSI();
        this.position = this.carouselController.readPosition();
        this.startPosition = 0;
        FCSLOG.info(this.name + " position after disable = " + this.position + " delta " + (this.position - this.absoluteTargetPosition));
        this.initializeClampsState();
        this.updateStateWithSensors();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.carouselController.stopPosition();
        this.carouselController.goToSwitchOnDisabled();
    }

    @Override
    public boolean isHoldingFilter() {
        return this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isNotHoldingFilter() {
        return !this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isAtHandoff() {
        return false;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the ID of filter at STANDBY")
    public int getFilterID() {
        return this.socketAtStandby.getFilterID();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read sensors and update state", timeout=2000)
    public synchronized void updateStateWithSensors() {
        long beginTime = System.currentTimeMillis();
        if (!FcsUtils.isSimu() && beginTime - this.lastUpdateStateWithSensors.get() < 100L) {
            return;
        }
        this.lastUpdateStateWithSensors.set(beginTime);
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateStateWithSensors-carousel");){
            this.hyttc580.checkBooted();
            if (!this.clampsStateInitialized) {
                throw new FcsHardwareException(this.name + ": clamps state not initialized.  Please launch command initializeClampsState.");
            }
            this.tcpProxy.updatePDOData();
            this.updateState();
            this.updateMinLockedThreshold();
            this.updateTemperatures();
            this.updateHoldingBrakesState();
            this.publishData();
        }
    }

    private void updateStateWithSensorsDuringMotion() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateStateWithSensorsDuringMotion-carousel");){
            this.hyttc580.checkBooted();
            if (!this.clampsStateInitialized) {
                throw new FcsHardwareException(this.name + ": clamps state not initialized.  Please launch command initializeClampsState.");
            }
            this.tcpProxy.updatePDOData();
            this.updateState();
            this.updateHoldingBrakesState();
            this.publishData();
            this.carouselController.publishDataDuringMotion();
        }
    }

    public void updateMinLockedThreshold() {
        if (System.currentTimeMillis() - this.lastUpdateLockSensorMinLocked.get() < 60000L) {
            return;
        }
        this.minLockedThreshold = (int)this.readLockSensorMinLocked();
        this.lastUpdateLockSensorMinLocked.set(System.currentTimeMillis());
    }

    public long readLockSensorMinLocked() {
        return this.hyttc580.readLockSensorMinLocked();
    }

    @Override
    public boolean isAtOnline() {
        return false;
    }

    public void updateSocketAtStandbyReadSensorsNoPublication() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateSocketAtStandbyReadSensorsNoPublication-carousel");){
            this.hyttc580.checkBooted();
            this.hyttc580.checkInitialized();
            this.tcpProxy.updatePDOData();
            this.updateSocketAtStandbyState();
        }
    }

    public void updateSocketAtStandbyState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateSocketAtStandbyState-carousel");){
            this.socketAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo1());
            if (this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5) {
                this.socketAtStandby = this.socketsMap.get("socket" + this.socketAtStandbyID);
                this.socketAtStandby.updateState();
                this.socketAtStandby.updateFilterID();
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update socket at STANDBY state from hyttc580 data.", timeout=2000)
    public void updateSocketAtStandbyWithSensors() {
        this.updateSocketAtStandbyReadSensorsNoPublication();
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update state from hyttc580 data.", timeout=2000)
    public void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-carousel");){
            this.updateSocketAtStandbyState();
            this.position = this.carouselController.getPosition();
            int level = FcsUtils.getTimingLevel();
            Level logLevel = FcsUtils.getLogLevel();
            this.subs.getScheduler().schedule(() -> {
                FcsUtils.startAsync(level, logLevel);
                this.updateSocketNotAtStandby();
                FcsUtils.endAsync();
            }, 0L, TimeUnit.SECONDS);
        }
    }

    public void updateSocketNotAtStandby() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateSocketNotAtStandby");){
            short socketNotAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo2());
            if (socketNotAtStandbyID >= 1 && socketNotAtStandbyID <= 5) {
                CarouselSocket socketToUpdate = this.socketsMap.get("socket" + socketNotAtStandbyID);
                socketToUpdate.updateState();
            }
        }
    }

    public FcsEnumerations.FilterClampState getClampsStateAtStandby() {
        if (this.socketAtStandby == null) {
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        return this.socketAtStandby.getClampsState();
    }

    public boolean isEmptyAtStandby() {
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isEmpty();
    }

    public boolean isUnclampedOnFilterAtStandby() {
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isUnclampedOnFilter();
    }

    public void updateTemperatures() {
        if (System.currentTimeMillis() - this.lastUpdateTemperatures.get() < 60000L) {
            return;
        }
        this.readBrakesAndMotorTemperatures();
        this.meanClampsTemperature = this.readMeanClampsTemperature();
        this.lastUpdateTemperatures.set(System.currentTimeMillis());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read on pt100 the temperatures", timeout=2000)
    public void readBrakesAndMotorTemperatures() {
        this.pt100.updateTemperatures();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read on hyttc580 the mean temperature for all the clamps in Celsius", timeout=2000)
    public double readMeanClampsTemperature() {
        return this.hyttc580.readMeanClampsTemperature();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Activate POWER SAVE mode.", alias="activatePowerSave")
    public void powerSave() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("powerSave");){
            this.carouselController.activatePowerSave();
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.CarouselPowerState.LOW_POWER});
            FCSLOG.info(this.getName() + ": POWER SAVE activated.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Deactivate POWER SAVE mode.")
    public void powerOn() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("powerSaveDeactivate");){
            this.carouselController.deactivatePowerSave();
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.CarouselPowerState.REGULAR});
            FCSLOG.info(this.getName() + ": POWER SAVE deactivated.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Disable interlock shutter. Do it only if you understand what you are doing.")
    public void interlockShutterDisable() {
        this.hyttc580.interlockShutterDisable();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable interlock shutter. Do it only if you understand what you are doing.")
    public void interlockShutterEnable() {
        this.hyttc580.interlockShutterEnable();
    }

    public void registerHighLevelActionDuration(FcsEnumerations.GeneralAction action) {
        String path = "duration/" + action.name();
        this.dataProviderDictionaryService.registerData(new KeyValueData(path, (Serializable)Double.valueOf(0.0)));
        DataProviderInfo info = this.dataProviderDictionaryService.getDataProviderDictionary().getDataProviderInfoForPath(path);
        info.addAttribute(DataProviderInfo.Attribute.UNITS, "millisecond");
        info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Duration of the action " + action.name());
    }
}

