/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.StrainGauge;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSeneca4RTD;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerThreeOnlineClamps
implements ControlledBySensors,
SignalHandler,
HasLifecycle {
    private static final Logger FCSLOG = Logger.getLogger(AutochangerThreeOnlineClamps.class.getName());
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/onlineStrainGauge")
    private StrainGauge onlineStrainGauge;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/tempSensorsDevice2")
    private CanOpenSeneca4RTD tempSensorsDevice2;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    protected final AutochangerOnlineClamp onlineClampXminus;
    protected final AutochangerOnlineClamp onlineClampXplus;
    protected final AutochangerOnlineClamp onlineClampYminus;
    protected final AutochangerOnlineClamp[] clampsList;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    protected ScheduledFuture<?> currentRampHandle;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @ConfigurationParameter(range="0..30000", description="Timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="autochanger")
    protected volatile int timeoutForLockingClamps = 15000;
    @ConfigurationParameter(range="0..30000", description="Timeout in milliseconds : if unlocking the clamps last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="autochanger")
    protected volatile int timeoutForUnlockingClamps = 20000;
    @ConfigurationParameter(range="0..5000", description="Maximum time in milliseconds to lock the 3 clamps", units="millisecond", category="autochanger")
    protected volatile int maxTimeToLockAllClamps = 3000;
    @ConfigurationParameter(range="0..5000", description="Maximum time in milliseconds to unlock the 3 clamps", units="millisecond", category="autochanger")
    protected volatile int maxTimeToUnlockAllClamps = 3000;
    @ConfigurationParameter(range="0..5000", description="Maximum time in milliseconds to open the 3 clamps", units="millisecond", category="autochanger")
    protected volatile int maxTimeToOpenClampsX = 2000;
    @ConfigurationParameter(range="0..5000", description="Maximum time in milliseconds to close the 3 clamps", units="millisecond", category="autochanger")
    protected volatile int maxTimeToCloseClampsX = 2000;
    @ConfigurationParameter(range="50..1000", description="Minimal period for current ramps. Should be > 50", units="millisecond", category="autochanger")
    protected volatile int minPeriod = 200;
    @ConfigurationParameter(range="-10000..10000", units="mV", description="If strain superior to maxClosedStrain, clamps are OPENED", category="autochanger")
    private volatile short maxClosedStrain = (short)1572;
    @ConfigurationParameter(range="-10000..10000", units="mV", description="If strain strictly inferior to maxLockedStrain, clamps are LOCKED", category="autochanger")
    private volatile short maxLockedStrain = (short)1484;
    @ConfigurationParameter(range="-10000..10000", units="mV", description="If strain strictly inferior to minLockedStrain, clamps may be in ERROR", category="autochanger")
    private volatile short minLockedStrain = (short)500;
    @ConfigurationParameter(range="0..5", units="unitless", description="Gain to convert from raw strain to temperature-aware strain", category="autochanger")
    private volatile double strainGain = 2.978;
    private short rawStrain = 0;
    private short normalizedStrain = 0;
    private boolean lockStatusInitialized = false;

    public AutochangerThreeOnlineClamps(AutochangerOnlineClamp onlineClampXminus, AutochangerOnlineClamp onlineClampXplus, AutochangerOnlineClamp onlineClampYminus) {
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampYminus = onlineClampYminus;
        this.clampsList = new AutochangerOnlineClamp[]{onlineClampYminus, onlineClampXminus, onlineClampXplus};
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerThreeClamps.class, this.path);
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CAN_BUS_READING_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR.getAlert(), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_ONLINE_CLAMPS_CLOSED_AT_STARTUP.getAlert(), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_ONLINE_CLAMPS_STAY_ENABLED.getAlert(), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if lockStatus has been first initialized from strain.")
    public boolean isLockStatusInitialized() {
        return this.lockStatusInitialized;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if homing has been done for the 3 ONLINE clamp controllers.")
    public boolean isHomingDone() {
        return this.onlineClampXminus.isHomingDone() && this.onlineClampXplus.isHomingDone() && this.onlineClampYminus.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Reads the homing status on each controller of the online clamps. Returns true if all status are true.")
    public boolean checkHomingStatusOnController() {
        return this.onlineClampXminus.checkHomingStatusOnController() && this.onlineClampXplus.checkHomingStatusOnController() && this.onlineClampYminus.checkHomingStatusOnController();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Reads the homing status on each controller of the online clamps. Update homingDone in FCS according to the results. If all are true, homingDone is set to true, otherwise it is set to false.")
    public String updateHomingStatusAccordingToController() {
        boolean controllerHomingDoneStatus;
        Object message = "Homing status";
        boolean fcsHomingDoneStatus = this.isHomingDone();
        if (fcsHomingDoneStatus == (controllerHomingDoneStatus = this.checkHomingStatusOnController())) {
            message = (String)message + (fcsHomingDoneStatus ? ": done" : "undone (already up to date).");
        } else {
            this.onlineClampXminus.updateHomingFromControllerStatusWord();
            this.onlineClampXplus.updateHomingFromControllerStatusWord();
            this.onlineClampYminus.updateHomingFromControllerStatusWord();
            message = (String)message + (controllerHomingDoneStatus ? " is set to done." : " is set to undone.");
        }
        return message;
    }

    @ConfigurationParameterChanger
    public void setMinPeriod(int minPeriod) {
        if (minPeriod < 50) {
            throw new IllegalArgumentException(minPeriod + " bad value for minPeriod. should be > 50");
        }
        this.minPeriod = minPeriod;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are LOCKED.")
    public boolean isLocked() {
        return this.onlineClampXminus.isLocked() && this.onlineClampXplus.isLocked() && this.onlineClampYminus.isLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are CLOSED.")
    public boolean isClosed() {
        return this.onlineClampXminus.isClosed() && this.onlineClampXplus.isClosed() && this.onlineClampYminus.isClosed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if any of the 3 clamps is CLOSED.")
    public boolean isAnyClosed() {
        return Arrays.stream(this.clampsList).anyMatch(c -> c.isClosed());
    }

    public boolean areAllDisabled() {
        return Arrays.stream(this.clampsList).allMatch(c -> !c.getController().isEnabled());
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are OPENED.")
    public boolean isOpened() {
        return this.onlineClampXminus.isOpened() && this.onlineClampXplus.isOpened() && this.onlineClampYminus.isOpened();
    }

    private boolean isInTravel() {
        return this.onlineClampXminus.isInTravel() || this.onlineClampXplus.isInTravel() || this.onlineClampYminus.isInTravel();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if one of the clamp is in error.")
    public boolean isInError() {
        return this.onlineClampXminus.isInError() || this.onlineClampXplus.isInError() || this.onlineClampYminus.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready : controllers ready, controllers parameters checked and controllers configured.")
    public boolean isInitialized() {
        return this.onlineClampXminus.isInitialized() && this.onlineClampXplus.isInitialized() && this.onlineClampYminus.isInitialized();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Do homing of the 3 ONLINE clamps : open in CURRENT mode and homing of controller", timeout=6000)
    public void homing() {
        block8: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("online clamps homing");){
                if (this.isClosed() || this.isInTravel()) {
                    this.onlineClampYminus.openInCurrentModeAndHoming();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.openInCurrentModeAndHoming(), () -> this.onlineClampXplus.openInCurrentModeAndHoming());
                    break block8;
                }
                if (this.isOpened()) {
                    FcsUtils.AsyncTasks asyncRun = FcsUtils.asyncRun();
                    for (AutochangerOnlineClamp clamp : this.clampsList) {
                        asyncRun.asyncRun(() -> clamp.openInCurrentModeAndHoming());
                    }
                    asyncRun.await();
                    break block8;
                }
                throw new RejectedCommandException(this.name + " online clamps should be OPENED or CLOSED before attempting homing.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Perform homing of the three online clamps : open and current threshold homing", timeout=10000)
    public void homingCurrentThreshold() {
        block8: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("Three online clamps homing with current threshold");){
                if (this.isClosed() || this.isInTravel()) {
                    this.onlineClampYminus.openAndHoming();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.openAndHoming(), () -> this.onlineClampXplus.openAndHoming());
                    break block8;
                }
                if (this.isOpened()) {
                    FcsUtils.AsyncTasks asyncRun = FcsUtils.asyncRun();
                    for (AutochangerOnlineClamp clamp : this.clampsList) {
                        asyncRun.asyncRun(() -> clamp.openAndHoming());
                    }
                    asyncRun.await();
                    break block8;
                }
                throw new RejectedCommandException(this.name + " online clamps should be OPENED or CLOSED before attempting homing.");
            }
        }
    }

    public void testPeriodTask() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name + "-updateStateAndCheckSensors", this::updateStateAndCheckSensors).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofMillis(5000L)));
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Close the three online clamps in profile position mode. Homing of the clamps is required", timeout=10000)
    public void closeClamps() {
        block8: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("closeClamps");){
                if (!this.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet. Can't close.");
                }
                this.updateStateAndCheckSensors();
                if (this.isOpened()) {
                    this.autochanger.checkConditionsForActioningOnlineClamps();
                    this.onlineClampYminus.close();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.close(), () -> this.onlineClampXplus.close());
                    break block8;
                }
                if (this.isClosed()) {
                    FCSLOG.info(this.name + " clamps already CLOSED nothing to do");
                    break block8;
                }
                throw new RejectedCommandException(this.name + " has to be unlocked before.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open the three online clamps in profile position mode. Homing of the clamps is required", timeout=10000)
    public void openClamps() {
        block8: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openClamps");){
                if (!this.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet for the 3 clamps. Can't open.");
                }
                this.updateStateAndCheckSensors();
                if (this.isClosed()) {
                    this.onlineClampYminus.checkReadyForAction();
                    this.onlineClampYminus.open();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.open(), () -> this.onlineClampXplus.open());
                    break block8;
                }
                if (this.isOpened()) {
                    FCSLOG.info(this.name + " clamps already OPENED. Nothing to do.");
                    break block8;
                }
                throw new RejectedCommandException(this.name + " has to be closed before.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock the three online clamps for good positioning of the filter", timeout=10000)
    public void lockClamps() {
        block9: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("lockClamps");){
                this.updateStateAndCheckSensors();
                if (this.isClosed()) {
                    this.onlineClampYminus.lock();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.lock(), () -> this.onlineClampXplus.lock());
                    try {
                        FcsUtils.checkAndWaitConditionWithTimeoutAndFixedDelay(() -> this.areAllDisabled(), () -> this.updateStateAndCheckSensors(), "waitForCurrentDisabled", "At least one online clamp controller is still enabled after lockClamps().", 250L, 100L);
                        break block9;
                    }
                    catch (RejectedCommandException e) {
                        String msg = "Autochanger Online Clamps Controllers in an unexpected state:\nThey should have been disabled after lock(), but at least one has been found enabled.\nThis state need to be reviewed by an expert.\nYou should contact a FES expert with the debug information below to confirm the state of the Autochanger Online Clamps Controllers, and decide what to do next.\nDebug info:\nYminus: " + (this.onlineClampYminus.getController().isEnabled() ? "enabled" : "disabled") + ", Xminus: " + (this.onlineClampXminus.getController().isEnabled() ? "enabled" : "disabled") + ", Xplus: " + (this.onlineClampXplus.getController().isEnabled() ? "enabled" : "disabled");
                        this.raiseAlarm(FcsEnumerations.FcsAlert.AC_ONLINE_CLAMPS_STAY_ENABLED, msg);
                        throw e;
                    }
                }
                if (this.isLocked()) {
                    FCSLOG.info(this.name + " is already LOCKED. Nothing to do.");
                    break block9;
                }
                throw new RejectedCommandException(this.name + " have to be CLOSED before being locked.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the three online clamps to put them in closed position and disabled", timeout=10000)
    public void unlockClamps() {
        block7: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("unlockClamps");){
                this.updateStateAndCheckSensors();
                if (this.isLocked()) {
                    this.onlineClampYminus.unlock();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.unlock(), () -> this.onlineClampXplus.unlock());
                    FcsUtils.parallelRun(() -> this.onlineClampYminus.getController().goToSwitchOnDisabled(), () -> this.onlineClampXminus.getController().goToSwitchOnDisabled(), () -> this.onlineClampXplus.getController().goToSwitchOnDisabled());
                    break block7;
                }
                if (this.isClosed()) {
                    FCSLOG.info(this.name + " is already CLOSED. Nothing to do.");
                    break block7;
                }
                throw new RejectedCommandException(this.name + " have to be LOCKED before being unlocked.");
            }
        }
    }

    public void lockFilterAtOnline() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("lockFilterAtOnline");){
            if (this.isLocked()) {
                FCSLOG.info(this.name + " onlineClamps LOCKED : nothing to do");
            } else if (this.isClosed()) {
                this.lockClamps();
            } else if (this.isOpened()) {
                if (!this.isHomingDone()) {
                    this.homing();
                }
                this.closeClamps();
                this.lockClamps();
            }
        }
    }

    public void unlockAndOpen() {
        if (this.isLocked()) {
            this.unlockClamps();
        }
        if (this.isClosed()) {
            if (this.isHomingDone()) {
                this.openClamps();
            } else {
                this.homing();
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready.")
    public boolean myDevicesReady() {
        return this.onlineClampXminus.myDevicesReady() && this.onlineClampXplus.myDevicesReady() && this.onlineClampYminus.myDevicesReady();
    }

    private short computeNormalizedStrain() {
        double temp = 20.0;
        if (!this.tempSensorsDevice2.isBooted()) {
            this.tempSensorsDevice2.updateDeviceInfo();
        }
        if (this.tempSensorsDevice2.isBooted()) {
            temp = this.tempSensorsDevice2.readChannel(1);
        } else {
            this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, " can't read temperature because tempSensorsDevice2 is not booted, temperature is supposed to be 20\u00b0C", this.name);
        }
        if (!this.onlineStrainGauge.isBooted()) {
            this.onlineStrainGauge.updateDeviceInfo();
        }
        if (this.onlineStrainGauge.isBooted()) {
            this.rawStrain = this.onlineStrainGauge.readStrain();
        } else {
            this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, " can't read strainGain because onlineStrainGauge is not booted", this.name);
        }
        this.normalizedStrain = (short)((double)this.rawStrain - this.strainGain * (temp - 20.0));
        FCSLOG.finer("temperature=" + temp + " / ONLINE read strain=" + this.rawStrain + " / normalized strain=" + this.normalizedStrain);
        return this.normalizedStrain;
    }

    public StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps() {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setLockStatus(this.lockStatus);
        status.setOnlineClampStrain((int)this.normalizedStrain);
        status.setOnlineClampRawStrain(this.rawStrain);
        status.setHomingDone(this.isHomingDone());
        return status;
    }

    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByThreeClamps()));
    }

    protected void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state from sensors values.")
    public void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-ac3clamps");){
            for (AutochangerOnlineClamp clamp : this.clampsList) {
                clamp.updateState();
            }
            this.normalizedStrain = this.computeNormalizedStrain();
            this.computeLockStatus();
            this.publishData();
        }
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isClosed() ? FcsEnumerations.LockStatus.CLOSED : (this.isLocked() ? FcsEnumerations.LockStatus.LOCKED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN))));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a lock status computed from the normalizedStrain value")
    public FcsEnumerations.LockStatus computeStrainGaugeLockStatus() {
        this.normalizedStrain = this.computeNormalizedStrain();
        FCSLOG.info(this.name + " ONLINE strain = " + this.normalizedStrain);
        if (this.normalizedStrain > this.maxClosedStrain) {
            return FcsEnumerations.LockStatus.OPENED;
        }
        if (this.normalizedStrain > this.maxLockedStrain) {
            return FcsEnumerations.LockStatus.CLOSED;
        }
        if (this.normalizedStrain > this.minLockedStrain) {
            return FcsEnumerations.LockStatus.LOCKED;
        }
        return FcsEnumerations.LockStatus.ERROR;
    }

    private void computeLockStatusFromStrain() {
        FcsEnumerations.LockStatus strainLockStatus = this.computeStrainGaugeLockStatus();
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : (this.isClosed() ? (strainLockStatus == FcsEnumerations.LockStatus.LOCKED ? FcsEnumerations.LockStatus.LOCKED : (strainLockStatus == FcsEnumerations.LockStatus.CLOSED ? FcsEnumerations.LockStatus.CLOSED : (strainLockStatus == FcsEnumerations.LockStatus.OPENED || strainLockStatus == FcsEnumerations.LockStatus.ERROR ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.ERROR))) : FcsEnumerations.LockStatus.UNKNOWN)));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize autochanger online clamps hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.postStart();
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.postStart();
        }
    }

    public void postStart() {
        FCSLOG.fine(() -> this.name + " BEGIN postStart.");
        if (this.onlineStrainGauge.isBooted()) {
            this.onlineStrainGauge.initializeAndCheckHardware();
        } else {
            this.onlineStrainGauge.raiseAlarmIfMissing();
        }
        if (this.tempSensorsDevice2.isBooted()) {
            try {
                this.computeLockStatusFromStrain();
                this.lockStatusInitialized = true;
                this.publishData();
            }
            catch (SDORequestException ex) {
                this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_READING_ERROR, "could not computeLockStatusFromStrain ", this.name, (Exception)((Object)ex));
            }
        } else {
            this.tempSensorsDevice2.raiseWarningIfMissing();
        }
        this.updateState();
        if (this.isAnyClosed()) {
            StringBuilder debug = new StringBuilder("Debug info:\n");
            for (AutochangerOnlineClamp clamp : this.clampsList) {
                debug.append(clamp.getName() + "'s lockStatus=" + clamp.getLockStatus().name() + ", ");
                debug.append("position=" + clamp.getController().getPosition() + ", ");
                debug.append("targetPositionToClose=" + clamp.getTargetPositionToClose() + ",\n");
            }
            debug.append("normalizedStrain=" + this.normalizedStrain + ".\n");
            String msg = "Autochanger Online Clamps are in an unexpected state at startup:\nThey should all be OPENED or LOCKED at startup but at least one has been found CLOSED.\nSince there is no lock sensor for these clamps, this state needs to be reviewed by an expert.You should contact a FES expert with the debug information below to confirm the state of the Autochanger Online Clamps, and decide what to do next.\n" + debug.toString();
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_ONLINE_CLAMPS_CLOSED_AT_STARTUP, msg);
        }
        FCSLOG.fine(() -> this.name + " END postStart.");
    }
}

