#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from org.lsst.ccs.command import CommandInvocationException
import java.time

timeoutTenMillis = java.time.Duration.ofMillis(10)
timeoutSixtyMillis = java.time.Duration.ofMillis(60)
timeoutOneMin = java.time.Duration.ofSeconds(60)
#
CCS.setThrowExceptions(True)

subsName = "single-filter-test-simu"

sft = CCS.attachSubsystem(subsName)
 

print "***single-filter-test-simu switchToEngineeringMode"
sft.sendSynchCommand(timeoutTenMillis, "switchToEngineeringMode")

carousel = CCS.attachSubsystem(subsName + "/carousel")
autochanger = CCS.attachSubsystem(subsName + "/autochanger")

print "***single-filter-test-simu/carousel isHoldingFilterAtStandby"
isHoldingFilterAtStandby = carousel.sendSynchCommand(timeoutTenMillis, "isHoldingFilterAtStandby")
if not isHoldingFilterAtStandby.getResult():
     raise Exception("carousel not holding a filter at standby")
print "single-filter-test-simu/carousel isHoldingFilterAtStandby:", isHoldingFilterAtStandby.getResult()

#Test initial conditions of autochanger

print "***single-filter-test-simu/autochanger isAtStandby"
isAtStandby = autochanger.sendSynchCommand(timeoutTenMillis, "isAtStandby")
if isAtStandby.getResult():
     raise Exception("autochanger should not be at standby")
print "single-filter-test-simu/autochanger isAtStandby:", isAtStandby.getResult()    

print "***single-filter-test-simu/autochanger isAtStandback"
isAtStandback = autochanger.sendSynchCommand(timeoutTenMillis, "isAtStandback")
if not isAtStandback.getResult():
     raise Exception("autochanger should be at standback")
print "single-filter-test-simu/autochanger isAtStandback:", isAtStandback.getResult()

print "***single-filter-test-simu/autochanger isHoldingFilterAtStandback"
isHoldingFilterAtStandback = autochanger.sendSynchCommand(timeoutTenMillis, "isHoldingFilterAtStandback")
if isHoldingFilterAtStandback.getResult():
     raise Exception("autochanger should not be holding a filter at standback")
print "single-filter-test-simu/autochanger isHoldingFilterAtStandback:", isHoldingFilterAtStandback.getResult()

#Test initial conditions
print "***single-filter-test-simu/autochanger isHoldingFilterAtStandby"
isHoldingFilterAtStandby = autochanger.sendSynchCommand(timeoutTenMillis, "isHoldingFilterAtStandby")
if isHoldingFilterAtStandby.getResult():
     raise Exception("autochanger should not be holding a filter at standby")
print "single-filter-test-simu/autochanger isHoldingFilterAtStandby:", isHoldingFilterAtStandby.getResult() 

CCS.setThrowExceptions(False)

#Test executeSequence1
print "**************************************"
print "***single-filter-test-simu executeSequence1"
print "**************************************"
result = sft.sendSynchCommand(timeoutOneMin, "executeSequence1 2")
if isinstance(result.getResult(), CommandInvocationException):
     raise Exception(result.getResult())
print "***Result of command executeSequence1:", result.getResult()
print "**************************************"
print "***   END  executeSequence1        ***"
print "**************************************"

#Tests on carousel
print "***single-filter-test-simu/carousel unlockClamps"
result = carousel.sendSynchCommand(timeoutTenMillis, "unlockClamps")
if not isinstance(result.getResult(), CommandInvocationException):
     raise Exception("unclamp the filter should throw an exception")

CCS.setThrowExceptions(True)

print "***Moving autochanger to standby position"
autochanger.sendSynchCommand(timeoutSixtyMillis, "goToStandby")

CCS.setThrowExceptions(False)

##this command should throw an Exception
print "***single-filter-test-simu/carousel unlockClamps"
result = carousel.sendSynchCommand(timeoutTenMillis,"unlockClamps")
if not isinstance(result.getResult(), CommandInvocationException):
     raise Exception("unclamp the filter should throw an exception")

CCS.setThrowExceptions(True)

print "***single-filter-test-simu/autochanger closeLatchesAtStandby"
autochanger.sendSynchCommand(timeoutTenMillis, "closeLatchesAtStandby")

#this command should not throw an Exception
print "***single-filter-test-simu/carousel unlockClamps"
result = carousel.sendSynchCommand(timeoutTenMillis, "unlockClamps")
print "single-filter-test-simu/carousel unlockClamps:result=", result

CCS.setThrowExceptions(False)

print "***single-filter-test-simu/autochanger openLatchesAtStandby"
print "openLatchesAtStandby should fail"
result = autochanger.sendSynchCommand(timeoutTenMillis, "openLatchesAtStandby")
if not isinstance(result.getResult(), CommandInvocationException):
     raise Exception("openLatchesAtStandby should throw an exception")


