/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;

public class RedondantSensors
implements BinarySensor,
HasLifecycle {
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<DigitalSensor> sensors = new ArrayList<DigitalSensor>();
    private DigitalSensor sensor;
    private DigitalSensor sensorR;

    public RedondantSensors() {
    }

    RedondantSensors(DigitalSensor sensor, DigitalSensor sensorR) {
        this.sensor = sensor;
        this.sensorR = sensorR;
    }

    public void build() {
        if (this.sensors.size() != 2) {
            throw new RuntimeException("A RedondantSensors instance requires two DigitalSensors as its children. For " + this.path + " there are " + this.sensors.size());
        }
        this.sensor = this.sensors.get(0);
        this.sensorR = this.sensors.get(1);
    }

    public DigitalSensor getSensor() {
        return this.sensor;
    }

    public DigitalSensor getSensorR() {
        return this.sensorR;
    }

    @Override
    public boolean isInError() {
        return this.sensor.isOn() != this.sensorR.isOn();
    }

    @Override
    public boolean isOn() {
        return this.sensor.isOn() && this.sensorR.isOn();
    }
}

