/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public interface EPOSControllerForCarousel
extends EPOSController {
    public int getPositionSensorType();

    public void setPositionSensorType(int var1);

    public void setHoldingBrakes(boolean var1);

    public boolean isHoldingBrakes();

    @Override
    default public boolean isTargetReached() {
        return (this.getStatusWord() >> 10 & 1) == 1;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="GoToSwitchOnDisabled and set PositionSensorType to Absolute encoder SSI : 4")
    default public void setPositionSensorTypeEncoderSSI() {
        FCSLOG.info(this.getName() + " setting PositionSensorType Absolute encoder SSI");
        this.goToSwitchOnDisabled();
        this.doSetEncoderSSI();
    }

    default public void doSetEncoderSSI() {
        int controllerStructure = this.readControllerStructure();
        if (controllerStructure == 0) {
            this.writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 4);
            this.checkPositionSensorType(4);
        } else {
            this.writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 516);
            this.checkPositionSensorType(516);
        }
        int ssiPosition = this.readSSIPosition();
        if (Math.abs(ssiPosition) <= 1) {
            this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " after setPositionSensorTypeEncoderSSI, ssiPosition = " + ssiPosition + " we go back to TypeSinusIncrementalEncoder", this.getName());
            this.doSetSinusIncrementalEncoder();
            this.doSetEncoderSSI();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="GoToSwitchOnDisabled and set PositionSensorType to Sinus Incremental Encoder : 8")
    default public void setPositionSensorTypeSinusIncrementalEncoder() {
        FCSLOG.info(this.getName() + " setting PositionSensorType Sinus Incremental Encoder");
        this.goToSwitchOnDisabled();
        this.doSetSinusIncrementalEncoder();
    }

    default public void doSetSinusIncrementalEncoder() {
        int controllerStructure = this.readControllerStructure();
        if (controllerStructure == 0) {
            this.writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 8);
            this.checkPositionSensorType(8);
        } else {
            this.writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 520);
            this.checkPositionSensorType(520);
        }
    }

    default public void checkPositionSensorType(int sensortype) {
        long timeoutMillis = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        boolean ok = false;
        while (!ok && duration <= timeoutMillis) {
            duration = System.currentTimeMillis() - timeStart;
            FcsUtils.sleep(2, this.getName());
            ok = (long)sensortype == this.readParameter(EPOSEnumerations.Parameter.PositionSensorType);
        }
        if (!ok) {
            String msg = this.getName() + " couldn't change position sensor type during time allocated of " + timeoutMillis + " ms";
            FCSLOG.severe(msg);
            throw new FcsHardwareException(msg);
        }
        this.setPositionSensorType(sensortype);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    default public void defineAbsolutePosition(int position) {
        FCSLOG.finer(() -> this.getName() + " Defining Absolute Position:" + position);
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        if (EPOSEnumerations.EposMode.HOMING != this.readMode()) {
            FcsUtils.sleep(500, "Controller change mode");
            this.changeMode(EPOSEnumerations.EposMode.HOMING);
        }
        this.checkEposMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.goToOperationEnable();
        this.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION);
        this.checkHomingDone();
    }

    default public void activatePowerSave() {
        int val = (int)this.readParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2one(val, 13));
        this.publishData();
        FCSLOG.info(this.getName() + ": POWER SAVE activated.");
    }

    default public void deactivatePowerSave() {
        int val = (int)this.readParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2zero(val, 13));
        this.publishData();
        FCSLOG.info(this.getName() + ": POWER SAVE deactivated.");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read bit holding brake into DigitalOutputFonctionnalityState. For carousel. index:2078 subindex:1 bit:2")
    default public boolean readHoldingBrakes() {
        int digitalOutput = (int)this.readParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        boolean holdingBrakes = (digitalOutput >> 2 & 1) == 1;
        this.setHoldingBrakes(holdingBrakes);
        return holdingBrakes;
    }
}

