/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;

public class FakeFilterHolder
implements FilterHolder,
HasLifecycle {
    private static final Logger FCSLOG = Logger.getLogger(FakeFilterHolder.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    private BinarySensor holdingFilterSensor;
    private BinarySensor notHoldingFilterSensor;
    private String holdingFilterSensorName;
    private String notHoldingFilterSensorName;
    @LookupName
    private String name;

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the fake autochanger is holding the filter. This command doesn't read again the sensor.")
    public boolean isHoldingFilter() {
        return this.holdingFilterSensor.isOn();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the fake autochanger is holding the filter. This command doesn't read again the sensor.")
    public boolean isNotHoldingFilter() {
        return this.notHoldingFilterSensor.isOn();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.publishData();
    }

    public void publishData() {
        KeyValueData kvd = new KeyValueData(this.name, (Serializable)Boolean.valueOf(this.holdingFilterSensor.isOn()));
        this.subs.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public boolean isAtHandoff() {
        return true;
    }

    @Override
    public boolean isAtStandby() {
        return true;
    }

    @Override
    public boolean isAtOnline() {
        return false;
    }

    public void start() {
        FCSLOG.info(this.name + " FakeFilterHolder BEGIN start");
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.holdingFilterSensor = (BinarySensor)lookup.getComponentByPath(this.holdingFilterSensorName);
        if (this.notHoldingFilterSensorName != null) {
            this.notHoldingFilterSensor = (BinarySensor)lookup.getComponentByPath(this.notHoldingFilterSensorName);
        }
        FCSLOG.info(this.name + " FakeFilterHolder END start");
    }

    public void postStart() {
        FCSLOG.info(this.name + " BEGIN postStart");
        FCSLOG.info(this.name + " END postStart");
    }

    @Override
    public int getFilterID() {
        return 0;
    }
}

