/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerThreeOnlineClampsProto
extends AutochangerThreeOnlineClamps {
    private static final Logger FCSLOG = Logger.getLogger(AutochangerThreeOnlineClampsProto.class.getName());

    public AutochangerThreeOnlineClampsProto(AutochangerOnlineClamp onlineClampXminus, AutochangerOnlineClamp onlineClampXplus, AutochangerOnlineClamp onlineClampYminus) {
        super(onlineClampXminus, onlineClampXplus, onlineClampYminus);
    }

    @Override
    public void openClamps() {
        this.openClampsInCurrentMode();
    }

    @Override
    public void closeClamps() {
        this.closeClampsInCurrentMode();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the 3 online clamps.", timeout=6000)
    public void closeClampsInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            this.autochanger.checkConditionsForActioningOnlineClamps();
            this.onlineClampYminus.closeClampInCurrentMode();
            this.closeClampsXInCurrentMode();
        } else if (this.isClosed()) {
            FCSLOG.info(this.name + " clamps already CLOSED nothing to do");
        } else {
            throw new RejectedCommandException(this.name + " has to be unlocked before.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the 3 online clamps with a small pressure.", timeout=15000)
    public void openClampsInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (!this.isClosed()) {
            if (this.isOpened()) {
                FCSLOG.info(this.name + " clamps already OPENED. Nothing to do.");
                throw new RejectedCommandException(this.name + " clamps already OPENED. Nothing to do.");
            }
            throw new RejectedCommandException(this.name + " has to be closed before.");
        }
        this.onlineClampYminus.checkReadyForAction();
        this.onlineClampYminus.openClampInCurrentMode();
        this.openClampsXInCurrentMode();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="open clampXs. for proto only.", timeout=15000)
    public void openClampsXInCurrentMode() {
        FcsUtils.parallelRun(() -> this.onlineClampXminus.openClampInCurrentMode(), () -> this.onlineClampXplus.openClampInCurrentMode());
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="close clamps X", timeout=6000)
    public void closeClampsXInCurrentMode() {
        FcsUtils.parallelRun(() -> this.onlineClampXminus.closeClampInCurrentMode(), () -> this.onlineClampXplus.closeClampInCurrentMode());
    }

    @Override
    public void postStart() {
        super.postStart();
        for (AutochangerOnlineClamp onlineClamp : this.clampsList) {
            onlineClamp.getController().setHomingDone();
        }
    }
}

