/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderClampController;

public class SimuLoaderClampControllerTest
extends CcsTestCaseTemplate {
    private static ComponentLookup lookup;
    private static Subsystem loaderSubsystem;
    private static LoaderClamp clamp;
    private static Loader loader;
    private static SimuLoaderClampController clampController;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("******************************************************");
        System.out.println("TESTS OF LOADER CLAMP CONTROLLER IN STANDALONE MODE");
        System.out.println("******************************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.loader.standalone", "true");
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"Loader");
        loaderSubsystem.startAgent();
        ((AgentStateService)loaderSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        lookup = loaderSubsystem.getComponentLookup();
        clamp = (LoaderClamp)lookup.getComponentByPath("hooks");
        clampController = (SimuLoaderClampController)lookup.getComponentByPath("hooksController");
        loader = (Loader)lookup.getComponentByPath("loader");
    }

    @AfterClass
    public static void after() throws Exception {
        if (loaderSubsystem != null) {
            loaderSubsystem.shutdownAgent();
            ((AgentStateService)loaderSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
        }
        System.getProperties().remove("org.lsst.ccs.fcs.instance.loader.standalone");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testWriteCurrent() {
        System.out.println("###writeCurrent");
        int aValue = 0;
        System.out.println("#aValue = " + aValue);
        clampController.writeCurrent(aValue);
        Assert.assertTrue((String)"target current is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual current is " + aValue), (SimuLoaderClampControllerTest.clampController.actualCurrent == aValue ? 1 : 0) != 0);
        aValue = 5000;
        System.out.println("#aValue = " + aValue);
        clampController.writeCurrent(aValue);
        Assert.assertTrue((String)"target current is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual current is " + aValue), (SimuLoaderClampControllerTest.clampController.actualCurrent == aValue ? 1 : 0) != 0);
        aValue = clamp.getCurrentToClamp();
        System.out.println("#aValue = " + aValue);
        clampController.writeCurrent(aValue);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"target current is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual current is " + aValue), (SimuLoaderClampControllerTest.clampController.actualCurrent == aValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"clamp is CLAMPED", (boolean)clamp.isClamped());
        aValue = clamp.getCurrentToOpen();
        System.out.println("#aValue = " + aValue);
        clampController.writeCurrent(aValue);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"target current is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual current is " + aValue), (SimuLoaderClampControllerTest.clampController.actualCurrent == aValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"clamp is OPENED", (boolean)clamp.isOpened());
    }

    @Test
    public void testWriteTargetPosition() {
        System.out.println("###writeTargetPosition");
        int positionToReached = 0;
        System.out.println("#positionToReached = " + positionToReached);
        clampController.writeTargetPosition(positionToReached);
        Assert.assertTrue((String)"target position is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("current position is " + positionToReached), (clampController.getPosition() == positionToReached ? 1 : 0) != 0);
        positionToReached = clamp.getRelativePositionToClose();
        System.out.println("#positionToReached = " + positionToReached);
        clampController.writeTargetPosition(positionToReached);
        Assert.assertTrue((String)"target position is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("current position is " + positionToReached), (clampController.getPosition() == positionToReached ? 1 : 0) != 0);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is CLOSED", (boolean)clamp.isClosed());
    }

    static {
        loaderSubsystem = null;
    }
}

