/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.io.Serializable;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.common.service.DataAccumulationService;

public class PersistentCounter {
    private final String path;
    private final Subsystem subsys;
    private final DataAccumulationService dataAccumulationService;
    private static final Logger FCSLOG = Logger.getLogger(PersistentCounter.class.getName());

    private PersistentCounter(String path, Subsystem subsys) {
        this.path = path;
        this.subsys = subsys;
        this.dataAccumulationService = (DataAccumulationService)subsys.getAgentService(DataAccumulationService.class);
    }

    public static PersistentCounter newCounter(String path, Subsystem subsys, String actionName) {
        PersistentCounter ctr = new PersistentCounter(path, subsys);
        ctr.register(actionName);
        return ctr;
    }

    private void register(String actionName) {
        DataProviderDictionaryService dataSvc = (DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class);
        dataSvc.registerData(new KeyValueData(this.path, (Serializable)Double.valueOf(0.0)));
        DataProviderInfo info = dataSvc.getDataProviderDictionary().getDataProviderInfoForPath(this.path);
        info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Counter for the action " + actionName);
        info.addAttribute(DataProviderInfo.Attribute.UNITS, "unitless");
        info.addAttribute(DataProviderInfo.Attribute.TYPE, "double");
        this.dataAccumulationService.registerAccumulatedDataPath(this.path);
    }

    public void increment() {
        this.dataAccumulationService.accumulateData(this.path, 1.0);
        double sum = this.getValue();
        if (!Double.isNaN(sum)) {
            this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)Double.valueOf(sum)));
        } else {
            FCSLOG.warning("AccumulatedValue is NaN, not published: check your trending DB");
        }
    }

    private double getValue() {
        return this.dataAccumulationService.getAccumulatedValueForPath(this.path);
    }
}

