/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.trendserver.TrendingClientService;
import org.lsst.ccs.localdb.utils.TrendingConnectionUtils;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.alert.AlertService;

public class DataAccumulationService
implements AgentService,
ServiceLifecycle {
    private static final Logger LOG = Logger.getLogger(DataAccumulationService.class.getCanonicalName());
    private static boolean isNeeded = false;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    PersistencyService persistencyService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private TrendingClientService trendingService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @Persist
    public volatile Map<String, Double> persistedBaselinesMap = new ConcurrentHashMap<String, Double>();
    private final Object CHECK_INTERVAL_LOCK = new Object();
    private final Integer CHECK_INTERVAL = 10000;
    private volatile long lastCheckTime = 0L;
    public volatile Map<String, Double> databaseBaselinesMap = new ConcurrentHashMap<String, Double>();
    private final Object accumulationDataLock = new Object();
    public final Set<String> accumulatedDataSet = new HashSet<String>();
    public final Set<String> missingBaselinesSet = new HashSet<String>();
    private final Alert cannotConnectToRestServerAlert = new Alert("UnavailableRestServer", "Alert raised when the connection to the rest-server could not be achieved.");
    private final Alert problemFetchingBaselines = new Alert("UnavailableDataFromRestServer", "Alert raised when data cannot be retrieved from the rest server.");
    private volatile boolean connectedToRestServer = false;
    private boolean hasBeenInitialized = false;

    public String getAgentServiceName() {
        return "dataAccumulationService";
    }

    public boolean startForAgent(AgentInfo agentInfo) {
        return isNeeded;
    }

    public static void isNeeded() {
        System.setProperty("org.lsst.ccs.agent.usesTrending", "true");
        isNeeded = true;
    }

    public void preStart() {
        this.hasBeenInitialized = true;
        this.persistencyService.load();
        ConcurrentHashMap<String, Double> baselines = new ConcurrentHashMap<String, Double>();
        Iterator<String> iterator = this.accumulatedDataSet.iterator();
        while (iterator.hasNext()) {
            String path;
            Double persistedValue = this.persistedBaselinesMap.remove(path = iterator.next());
            baselines.put(path, persistedValue == null ? 0.0 : persistedValue);
        }
        this.persistedBaselinesMap.clear();
        this.persistedBaselinesMap.putAll(baselines);
    }

    public void preInit() {
        this.alertService.registerAlert(this.cannotConnectToRestServerAlert, new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                if (DataAccumulationService.this.connectedToRestServer) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
        });
        this.alertService.registerAlert(this.problemFetchingBaselines, new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                if (DataAccumulationService.this.missingBaselinesSet.isEmpty()) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
        });
        this.persistencyService.setAutomatic(false, true);
    }

    public void registerAccumulatedDataPath(String path) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("Too late to register accumulated data paths. It has to be done before the HasLifecycle::start phase.");
        }
        if (!this.accumulatedDataSet.add(path)) {
            throw new RuntimeException("Path " + path + " was already added to the data accumulation service.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAccumulatedBaselinesFromDatabase() {
        if (this.databaseBaselinesMap.size() == this.accumulatedDataSet.size()) {
            return;
        }
        TrendingConnectionUtils trendingUtils = this.trendingService.getBusTrendingConnection();
        boolean bl = this.connectedToRestServer = trendingUtils != null;
        if (trendingUtils == null) {
            this.alertService.raiseAlert(this.cannotConnectToRestServerAlert, AlertState.WARNING, "Failed to connect to the database.", AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
            return;
        }
        this.alertService.raiseAlert(this.cannotConnectToRestServerAlert, AlertState.NOMINAL, "Connected to the database", AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
        boolean updatePersistedData = false;
        Object object = this.accumulationDataLock;
        synchronized (object) {
            StringBuilder sb = new StringBuilder();
            for (String path : this.accumulatedDataSet) {
                if (this.databaseBaselinesMap.containsKey(path)) continue;
                String fullName = this.subsys.getName() + "/" + path;
                TrendingData data = trendingUtils.getLatestData(fullName);
                double databaseBaseline = Double.NaN;
                if (data != null) {
                    databaseBaseline = data.getValue("value");
                    if (Double.isNaN(databaseBaseline)) {
                        databaseBaseline = 0.0;
                    }
                    LOG.log(Level.INFO, "Got baseline from database for {0}: {1}", new Object[]{path, databaseBaseline});
                    double persistencyBaseline = this.persistedBaselinesMap.computeIfAbsent(path, p -> 0.0);
                    if (persistencyBaseline != 0.0) {
                        databaseBaseline += persistencyBaseline;
                        this.persistedBaselinesMap.put(path, 0.0);
                        updatePersistedData = true;
                    }
                    this.databaseBaselinesMap.put(path, databaseBaseline);
                    this.missingBaselinesSet.remove(path);
                    continue;
                }
                sb.append(path).append(" ");
                if (!this.missingBaselinesSet.add(path)) continue;
                LOG.log(Level.WARNING, "Could not fetch baseline from database for {0}", new Object[]{path});
            }
        }
        if (updatePersistedData) {
            this.persistencyService.persistNow();
        }
        if (this.missingBaselinesSet.isEmpty()) {
            this.alertService.raiseAlert(this.problemFetchingBaselines, AlertState.NOMINAL, "All baselines have been initialized.", AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
        } else {
            this.alertService.raiseAlert(this.problemFetchingBaselines, AlertState.WARNING, "Baselines could not be fetched for data: " + this.missingBaselinesSet, AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double accumulateData(String path, double increment) {
        long time = System.currentTimeMillis();
        Object object = this.CHECK_INTERVAL_LOCK;
        synchronized (object) {
            if (time - this.lastCheckTime >= (long)this.CHECK_INTERVAL.intValue()) {
                this.lastCheckTime = time;
                this.initializeAccumulatedBaselinesFromDatabase();
            }
        }
        if (Double.isFinite(increment)) {
            object = this.accumulationDataLock;
            synchronized (object) {
                Map<String, Double> accumulationMap = this.getAccumulatedMapForPath(path);
                boolean returnNaN = accumulationMap != this.databaseBaselinesMap;
                double existingAccumulatedValue = accumulationMap.computeIfAbsent(path, p -> 0.0);
                double accumulatedValue = existingAccumulatedValue + increment;
                accumulationMap.put(path, accumulatedValue);
                if (returnNaN) {
                    this.persistencyService.persistNow();
                }
                return returnNaN ? Double.NaN : accumulatedValue;
            }
        }
        return increment;
    }

    public double getAccumulatedValueForPath(String path) {
        Map<String, Double> accumulationMap = this.getAccumulatedMapForPath(path);
        if (!accumulationMap.containsKey(path)) {
            throw new IllegalArgumentException("Path " + path + " has not been registered as an accumulated data channel " + this.getHistoricalDataNames());
        }
        return accumulationMap != this.databaseBaselinesMap ? Double.NaN : accumulationMap.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Double> getAccumulatedMapForPath(String path) {
        Object object = this.accumulationDataLock;
        synchronized (object) {
            boolean baselineIsFromDB = this.databaseBaselinesMap.containsKey(path);
            return baselineIsFromDB ? this.databaseBaselinesMap : this.persistedBaselinesMap;
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the set of accumulated data names")
    public Set<String> getHistoricalDataNames() {
        return new HashSet<String>(this.accumulatedDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Set the historical value for a given data path")
    public void setHistoricalValueForPath(@Argument(description="Data path") String path, @Argument(description="Historical value") double value) {
        if (!this.accumulatedDataSet.contains(path)) {
            throw new IllegalArgumentException("Invalid historical data path: " + path + ". Allowed values are: " + this.accumulatedDataSet);
        }
        if (!Double.isFinite(value)) {
            throw new IllegalAccessError("The provided value (" + value + ") must be finite.");
        }
        Object object = this.accumulationDataLock;
        synchronized (object) {
            this.getAccumulatedMapForPath(path).put(path, value);
        }
        LOG.log(Level.INFO, "Updateded historical data baseline for path {0} to value {1}.", new Object[]{path, value});
    }
}

