/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.time.Instant;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public interface AlertRaiser {
    public static final Logger FCSLOG = Logger.getLogger(AlertRaiser.class.getName());
    public static final char alertSeparator = '/';

    public Subsystem getSubsystem();

    public AlertService getAlertService();

    default public char getAlertSeparator() {
        return '/';
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause) {
        this.getAlertService().raiseAlert(fcsAlert.getAlert(), AlertState.ALARM, cause);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, Exception ex) {
        FCSLOG.severe(ex.toString());
        this.raiseAlarm(fcsAlert, cause + " due to " + ex);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.getAlertService().raiseAlert(fcsAlert.getAlert(deviceName), AlertState.ALARM, cause);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, Exception ex) {
        this.raiseAlarm(fcsAlert, cause + " due to " + ex, deviceName);
    }

    default public void clearAlarm(FcsEnumerations.FcsAlert fcsAlert, String deviceName) {
        this.getAlertService().clearAlerts(new String[]{fcsAlert.getAlert(deviceName).getAlertId()});
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause) {
        this.getAlertService().raiseAlert(fcsAlert.getAlert(), AlertState.WARNING, cause);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause, Exception ex) {
        FCSLOG.severe(ex.toString());
        this.raiseWarning(fcsAlert, cause + " due to " + ex);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.getAlertService().raiseAlert(fcsAlert.getAlert(deviceName), AlertState.WARNING, cause);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, Exception ex) {
        FCSLOG.warning(ex.toString());
        this.raiseWarning(fcsAlert, cause + " due to " + ex, deviceName);
    }

    default public void raiseAlertOnlyIfNew(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, AlertState state) {
        Alert alert = fcsAlert.getAlert(deviceName);
        String alertId = alert.getAlertId();
        RaisedAlertHistory history = this.getAlertService().getRaisedAlertSummary().getRaisedAlert(alertId);
        if (history == null || history.getLatestAlertState() != state) {
            this.getAlertService().raiseAlert(alert, state, cause);
        }
    }

    default public void raiseAlertOnlyEveryTenMinutes(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, AlertState state) {
        Alert alert = fcsAlert.getAlert(deviceName);
        String alertId = alert.getAlertId();
        boolean alertToBeRaised = true;
        RaisedAlertHistory history = this.getAlertService().getRaisedAlertSummary().getRaisedAlert(alertId);
        if (history != null && history.getLatestAlertState() == state) {
            Instant lastAlertInstant = history.getLatestAlertCCSTimeStamp().getUTCInstant();
            alertToBeRaised = Instant.now().minusMillis(600000L).isAfter(lastAlertInstant);
        }
        if (alertToBeRaised) {
            this.getAlertService().raiseAlert(alert, state, cause);
        }
    }

    default public void raiseAlarmOnlyIfNew(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseAlertOnlyIfNew(fcsAlert, cause, deviceName, AlertState.ALARM);
        FCSLOG.severe(() -> deviceName + ": " + cause);
    }

    default public void raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseAlertOnlyIfNew(fcsAlert, cause, deviceName, AlertState.WARNING);
        FCSLOG.warning(() -> deviceName + ": " + fcsAlert + ": " + cause);
    }

    default public void raiseWarningOnlyEveryTenMinutes(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseAlertOnlyEveryTenMinutes(fcsAlert, cause, deviceName, AlertState.WARNING);
        FCSLOG.warning(() -> deviceName + ": " + fcsAlert + ": " + cause);
    }

    default public void raiseAlertOnlyEveryTenMinutes(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, Exception ex) {
        this.raiseAlertOnlyEveryTenMinutes(fcsAlert, cause + " due to " + ex, deviceName, AlertState.WARNING);
    }
}

