#################################################################################
#Script to test the whole fcs simulated hardware (carousel, autochanger, loader).
#This test is a part of integration tests.
#################################################################################
#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from org.lsst.ccs.command import CommandInvocationException
import java.time

 
timeoutFiveMillis = java.time.Duration.ofMillis(5)
timeoutThreeSec = java.time.Duration.ofSeconds(3)
timeoutHundredSec = java.time.Duration.ofSeconds(100)
#
CCS.setThrowExceptions(True)

subsName = "fcs-simu"
fcs = CCS.attachSubsystem(subsName)
print "Connected to fcs for Whole simulated hardware.", fcs

###Filters###
filterMng = CCS.attachSubsystem(subsName + "/filterManager")
result = filterMng.sendSynchCommand(timeoutFiveMillis, "toString")
print "### Filter Manager:", result.getResult()
print "### end Filter Manager"
###end Filters###

#getting timeouts
fcsConfigFuture = fcs.sendAsynchCommand("getConfigurationInfo")
print "getting fcs subsystem configuration"
fcsConfig = fcsConfigFuture.get()

print "FCS config =", fcsConfig.toString()

CCS.setThrowExceptions(False)

#Handle the thrown exceptions                                                                                                 
print "read sensors and update state "
result = fcs.sendSynchCommand(timeoutThreeSec, "updateStateWithSensors")

if isinstance(result.getResult(), CommandInvocationException):
     raise Exception(result.getResult())

print "FCS Subsystem state has been updated"
CCS.setThrowExceptions(True)

print "FCS setFilter U"
fcs.sendSynchCommand(timeoutHundredSec, "setFilter U")
