
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;

import org.lsst.ccs.command.annotations.Command;

import java.util.logging.Logger;


/**
 *
 * @author virieux
 */
public class SimuCarouselSocket extends CarouselSocket {
    private static final Logger FCSLOG = Logger.getLogger(SimuCarouselSocket.class.getName());

    public SimuCarouselSocket(int id, CarouselClamp clampXminus, CarouselClamp clampXplus) {
        super(id, clampXminus, clampXplus);
    }

    /**
     * update field filterID to be used only with whole FCS. In standalone mode,
     * filters can't be removed neither loaded into carousel so filterID never
     * changes.
     */
    @Override
    public void updateFilterID() {
        if (this.isEmpty()) {
            filterID = 0;
        } else if (autochanger.isAtStandby() && autochanger.isHoldingFilter()) {
            filterID = autochanger.getFilterID();
        }
        FCSLOG.finer(() -> name + " filter ID = " + carousel.getSocketAtStandby().getFilterID());
    }

    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING_ADVANCED, description = "Change the filterID on socket")
    public void simulateFilterID(int filterID) {
        this.filterID = filterID;
        boolean atStandby = this.isAtStandby();
        if ( filterID == 0 ) {
            ((SimuCarousel) carousel).simulateSocketEmpty(atStandby, this.getId());
        } else {
            ((SimuCarousel) carousel).simulateSocketHoldingFilter(atStandby, this.getId());
        }
        FCSLOG.info(name + " filter ID = " + filterID);
        publishData();
    }

}
