
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import java.util.logging.Logger;
import static org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSWithPDO.extractAverageCurrent;

import static org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSWithPDO.extractStatusWord;
import static org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSWithPDO.extractAverageVelocity;

/**
 *
 * @author virieux
 */
public class CanOpenEPOSCarouselClamp extends CanOpenEPOS {
    private static final Logger FCSLOG = Logger.getLogger(CanOpenEPOSCarouselClamp.class.getName());

    //clampXminusController nodeID: 0x1A clampXminusController nodeID: 0x1B

    /**
     * define cobid to be able to read values from PDO data.
     */
    protected int cobid1 = this.nodeID + 0x180;

    /**
     * PDO1 represents : velocity: 4 bytes current: 2 bytes statusWord: 2 bytes
     */
    private long pdo1 = 0L;

    @Override
    public void init() {
        super.init();
        cobid1 = nodeID + 0x180;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        tcpProxy.addReceivedPDO(cobid1);
    }

    /**
     * process PDOData to retrieve data from this device.
     *
     * @param pdo
     */
    @Override
    public void updateFromPDO(PDOData pdo) {
        FCSLOG.finer(() -> name + " updatingFromPDO = " + pdo);
        boolean updated = false;
        if (pdo.getPDOs().containsKey(cobid1)) {
            pdo1 = (long) pdo.getPDOs().get(cobid1);
            updated = true;
            /* update from PDO1 */
            FCSLOG.finer(() -> name + " updatingFromPDO1 = " + pdo1 + " binary:" + Long.toBinaryString(pdo1));
            statusWord = extractStatusWord(pdo1);
            this.updateEposState(statusWord);
            current = (short) extractAverageCurrent(pdo1);
            velocity = (int) extractAverageVelocity(pdo1);
        }
        if (updated) {
            this.publishData();
        }
    }

    /**
     * For tests and debug
     *
     * @return values updated by PDOs
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING_ROUTINE, description = "print values updated by PDOs to debug and test")
    public String printValuesUpdatedByPDOs() {
        StringBuilder sb = new StringBuilder("=> pdo1 value = ");
        sb.append(pdo1);
        sb.append(" / pdo1 = 0x");
        sb.append(Long.toHexString(pdo1));
        sb.append(" / status word = 0x");
        sb.append(Long.toHexString(statusWord));
        sb.append("\n status word = 0b");
        sb.append(Long.toBinaryString(statusWord));
        sb.append("\n current average = ");
        sb.append(current);
        sb.append(" / current average = 0x");
        sb.append(Long.toHexString(current));
        sb.append("\n velocity = ");
        sb.append(position);
        sb.append(" / velocity = 0x");
        sb.append(Long.toHexString(position));
        return sb.toString();
    }

}
