package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;

/**
 *
 * A class for the PLC Carousel sensors.
 * @author virieux
 */
public class CarouselPLCSensor extends CarouselSensor {

    @ConfigurationParameter(range = "0..8", description = "The byte number on the PDO "
        + "where the value of this sensor is stored in.", units = "unitless", category = "sensor")
    protected volatile int byteNumero;

    @ConfigurationParameter(range = "0..7", description = "Bit number on the byte "
            + "where the value sensor is stored.", units = "unitless", category = "sensor")
    private volatile int bitNumero;

    public int getByteNumero() {
        return byteNumero;
    }

    public int getBitNumero() {
        return bitNumero;
    }

}
