/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.LoaderMain;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoader;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderStandalonePlutoGateway;

public class LoaderClampTest
extends CcsTestCaseTemplate {
    private static ComponentLookup lookup;
    private static Subsystem loaderSubsystem;
    private static LoaderMain main;
    private static LoaderClamp clamp;
    private static SimuLoader loader;
    private static SimuLoaderStandalonePlutoGateway gateway;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("******************************************");
        System.out.println("TESTS OF LOADER CLAMP IN STANDALONE MODE");
        System.out.println("******************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.loader.standalone", "true");
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"Loader");
        loaderSubsystem.startAgent();
        ((AgentStateService)loaderSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        lookup = loaderSubsystem.getComponentLookup();
        main = (LoaderMain)lookup.getTopComponentNode().getComponent();
        clamp = (LoaderClamp)lookup.getComponentByPath("hooks");
        loader = (SimuLoader)lookup.getComponentByPath("loader");
        gateway = (SimuLoaderStandalonePlutoGateway)lookup.getComponentByPath("loaderPlutoGateway");
    }

    @AfterClass
    public static void after() throws Exception {
        if (loaderSubsystem != null) {
            loaderSubsystem.shutdownAgent();
            ((AgentStateService)loaderSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
        }
        System.getProperties().remove("org.lsst.ccs.fcs.instance.loader.standalone");
    }

    @Before
    public void setUp() {
        Utils.printJoliSetUp("LoaderClampModuleTest");
        gateway.simulateFilterIsOnLoader();
        gateway.simulateLoaderClampIsClamped();
        gateway.simulateLoaderIsConnectedOnCamera();
        gateway.simulateLoaderCarrierIsAtStorage();
        gateway.simulateAutochangerIsNotHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Loader Clamp is clamped.", (boolean)clamp.isClamped());
    }

    @After
    public void tearDown() {
        loader.getAlertService().clearAllAlerts();
    }

    @Test
    public void testGetControllerName() {
        System.out.println("### getControllerName");
        String ctlrName = clamp.getControllerName();
        Assert.assertTrue((String)("Clamp controller name should contains String hooks " + ctlrName), (boolean)ctlrName.contains("hook"));
    }

    public void testOpen() {
        System.out.println("### open");
        try {
            clamp.open();
            Assert.fail((String)"Can't open clamp because carrier is not at HANDOFF position.");
        }
        catch (Exception ex) {
            System.out.println("Can't open clamp because carrier is not at HANDOFF. Exception raised: " + ex);
        }
        gateway.simulateLoaderCarrierIsAtHandoff();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"Carrier is at HANDOFF.", (boolean)loader.isAtHandoff());
        try {
            clamp.open();
            Assert.fail((String)"Can't open clamp because clamp is CLAMPED.");
        }
        catch (Exception ex) {
            System.out.println("Can't open clamp because it's CLAMPED. Exception raised: " + ex);
        }
        gateway.simulateLoaderClampIsClosed();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"Loader Clamp is closed.", (boolean)clamp.isClosed());
        try {
            clamp.open();
            Assert.fail((String)"Can't open clamp because autochanger is not holding it.");
        }
        catch (Exception ex) {
            System.out.println("Can't open clamp because autochanger is not holding it. Exception raised: " + ex);
        }
        gateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"autochanger is now holding filter", (boolean)loader.isAutochangerHoldingFilter());
        clamp.open();
        Assert.assertTrue((String)"Loader Clamp is now opened.", (boolean)clamp.isOpened());
        Assert.assertTrue((String)"Clamp homing should have been done.", (boolean)clamp.isHomingDone());
        clamp.open();
        Assert.assertTrue((String)"Loader Clamp is still opened.", (boolean)clamp.isOpened());
        clamp.close();
        gateway.simulateLoaderClampIsInTravel();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Loader Clamp is in travel.", (clamp.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL ? 1 : 0) != 0);
        clamp.open();
        Assert.assertTrue((String)"Loader Clamp is open again.", (boolean)clamp.isOpened());
    }

    public void testClose() {
        System.out.println("### close");
        try {
            clamp.close();
            Assert.fail((String)"can't close because clamp has to be OPENED before a close action");
        }
        catch (Exception ex) {
            System.out.println("An exception was raised: " + ex);
        }
        gateway.simulateLoaderCarrierIsAtHandoff();
        gateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        clamp.open();
        Assert.assertTrue((String)"Loader Clamp is now opened.", (boolean)clamp.isOpened());
        Assert.assertTrue((String)"homing of clamp controller is done.", (boolean)clamp.isHomingDone());
        clamp.close();
        Assert.assertTrue((String)"Loader Clamp is now closed.", (boolean)clamp.isClosed());
        clamp.close();
        Assert.assertTrue((String)"Loader Clamp is still closed.", (boolean)clamp.isClosed());
        gateway.simulateLoaderClampIsOpened();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"Loader Clamp is now opened.", (boolean)clamp.isOpened());
        gateway.simulateLoaderClampIsInTravel();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Loader Clamp is in travel.", (clamp.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL ? 1 : 0) != 0);
        clamp.close();
        Assert.assertTrue((String)"Loader Clamp is closed again.", (boolean)clamp.isClosed());
    }

    @Test
    public void testClamp() {
        System.out.println("clamp");
        clamp.clamp();
        Assert.assertTrue((String)"Loader Clamp is now clamped.", (boolean)clamp.isClamped());
    }

    @Test
    public void testUnclamp() {
        System.out.println("### unclamp");
        try {
            clamp.unclamp();
            Assert.fail((String)"should raise an Exception because carrier is loaded with a filter but not at handoff position - can't unclamp");
        }
        catch (Exception ex) {
            System.out.println("Exception raised because Autochanger is not at HANDOFF : " + ex);
        }
        Assert.assertTrue((String)"Loader Clamp is clamped.", (boolean)clamp.isClamped());
        gateway.simulateLoaderCarrierIsAtHandoff();
        gateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        try {
            clamp.unclamp();
        }
        catch (RejectedCommandException ex) {
            System.out.println("Exception raised because carrier is AT HANDOFF, can't unclamp.: " + (Object)((Object)ex));
        }
        Assert.assertTrue((String)"Loader Clamp is clamped.", (boolean)clamp.isClamped());
        gateway.simulateAutochangerIsNotHoldingFilter();
        main.updateStateWithSensors();
        try {
            clamp.unclamp();
        }
        catch (RejectedCommandException ex) {
            System.out.println("Exception raised because autochanger is not holding filter, can't unclamp.: " + (Object)((Object)ex));
        }
        Assert.assertTrue((String)"Loader Clamp is clamped.", (boolean)clamp.isClamped());
    }

    static {
        loaderSubsystem = null;
    }
}

