/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.text.DecimalFormat;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.PT100Interface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenPT100
extends CanOpenDevice
implements PT100Interface {
    public static int processValueIndex = 37168;
    Double[] temperatures = new Double[5];

    @Override
    public void init() {
        for (int i = 1; i < 5; ++i) {
            this.temperatures[i] = 0.0;
        }
    }

    @Override
    public double getTemperature(int i) {
        return this.temperatures[i];
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Configure this device to read temperature.")
    public void configure() {
        for (int i = 1; i <= 5; ++i) {
            this.writeSDO(24848, i, 2, 30L);
            FcsUtils.sleep(2, this.name);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="read temperatures on the device and update temperatures fields")
    public void updateTemperatures() {
        for (int i = 1; i < 5; ++i) {
            this.temperatures[i] = (double)this.readTemperature(i) / 1000.0;
            FcsUtils.sleep(2, this.name);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read temperature, argument : 1..4")
    public long readTemperature(int subindex) {
        return this.readSDO(processValueIndex, subindex);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="print the 4 temperatures read by this device")
    public String toString() {
        DecimalFormat formatter = new DecimalFormat("#######.000");
        StringBuilder sb = new StringBuilder("\n");
        for (int i = 1; i < 5; ++i) {
            sb.append("temperature").append(i).append(" = ").append(formatter.format(this.temperatures[i])).append("\n");
        }
        return sb.toString();
    }

    public void postStart() {
        FCSLOG.fine(() -> this.name + " BEGIN postStart.");
        this.initializeAndCheckHardware();
        FCSLOG.fine(() -> this.name + " END postStart.");
    }
}

