/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedDuringMotionWithEncoderAndHoldingBrake;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSWithPDO;

public class CanOpenEPOSCarousel
extends CanOpenEPOS
implements EPOSControllerForCarousel {
    static final Logger FCSLOG = Logger.getLogger(CanOpenEPOSCarousel.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    protected int cobid1;
    protected int cobid2;
    private long pdo1 = 0L;
    private long pdo2 = 0L;
    public int positionSensorType;
    private boolean holdingBrakes = false;

    @Override
    public void setHoldingBrakes(boolean holdingBrakes) {
        this.holdingBrakes = holdingBrakes;
    }

    @Override
    public boolean isHoldingBrakes() {
        return this.holdingBrakes;
    }

    public void setPdo1(long pdo1) {
        this.pdo1 = pdo1;
    }

    public void setPdo2(long pdo2) {
        this.pdo2 = pdo2;
    }

    public long getPdo1() {
        return this.pdo1;
    }

    public long getPdo2() {
        return this.pdo2;
    }

    public int getCobid1() {
        return this.cobid1;
    }

    public int getCobid2() {
        return this.cobid2;
    }

    @Override
    public int getStatusWord() {
        return this.statusWord;
    }

    @Override
    public int getPositionSensorType() {
        return this.positionSensorType;
    }

    @Override
    public void setPositionSensorType(int positionSensorType) {
        this.positionSensorType = positionSensorType;
    }

    @Override
    public void init() {
        super.init();
        this.hasEncoder = true;
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.getName()), alwaysClear);
        this.cobid1 = this.nodeID + 384;
        this.cobid2 = this.nodeID + 640;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
        this.tcpProxy.addReceivedPDO(this.cobid2);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read bit holding brake into DigitalOutputFonctionnalityState. For carousel. index:2078 subindex:1 bit:2")
    public boolean readHoldingBrake() {
        int digitalOutput = (int)this.readParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.holdingBrakes = (digitalOutput >> 2 & 1) == 1;
        return this.holdingBrakes;
    }

    @Override
    public void faultReset() {
        super.faultReset();
        if (this.positionSensorType == 8) {
            this.setPositionSensorTypeEncoderSSI();
        }
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        FCSLOG.fine(() -> this.name + " updatingFromPDO = " + pdo);
        boolean updated = false;
        if (pdo.getPDOs().containsKey(this.cobid1)) {
            this.pdo1 = (Long)pdo.getPDOs().get(this.cobid1);
            updated = true;
            FCSLOG.finer(() -> this.name + " updatingFromPDO1 = " + this.pdo1 + " binary:" + Long.toBinaryString(this.pdo1));
            this.statusWord = CanOpenEPOSCarousel.extractStatusWord(this.pdo1);
            this.averageCurrent = (short)CanOpenEPOSWithPDO.extractAverageCurrent(this.pdo1);
            this.position = CanOpenEPOSWithPDO.extractPosition(this.pdo1);
            this.updateEposState(this.statusWord);
            FCSLOG.finer(() -> this.name + " position = " + this.position + " pdo1 =  binary:" + Long.toBinaryString(this.pdo1));
        }
        if (pdo.getPDOs().containsKey(this.cobid2)) {
            this.pdo2 = (Long)pdo.getPDOs().get(this.cobid2);
            updated = true;
            FCSLOG.finer(() -> this.name + " updatingFromPDO2 = " + this.pdo2 + " binary:" + Long.toBinaryString(this.pdo2));
            this.followingError = (short)CanOpenEPOSWithPDO.extractFollowingError(this.pdo2);
            this.velocity = CanOpenEPOSWithPDO.extractAverageVelocity(this.pdo2);
        }
        if (updated) {
            this.publishData();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update field statusWorld in reading a SDO (readStatusWord)")
    public void updateStatusWord() {
    }

    public static int extractStatusWord(long pdo) {
        return (int)pdo & 0xFFFF;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print values updated by PDOs to debug and test")
    public String printValuesUpdatedByPDOs() {
        StringBuilder sb = new StringBuilder("=> pdo1 value = ");
        sb.append(this.pdo1);
        sb.append(" / pdo1 = 0x");
        sb.append(Long.toHexString(this.pdo1));
        sb.append(" / status word = 0x");
        sb.append(Long.toHexString(this.statusWord));
        sb.append("\n status word = 0b");
        sb.append(Long.toBinaryString(this.statusWord));
        sb.append("\n current average = ");
        sb.append(this.current);
        sb.append(" / current average = 0x");
        sb.append(Long.toHexString(this.current));
        sb.append("\n position = ");
        sb.append(this.position);
        sb.append(" / position = 0x");
        sb.append(Long.toHexString(this.position));
        sb.append("\n => pdo2 value = ");
        sb.append(this.pdo2);
        sb.append(" / pdo2 = 0x");
        sb.append(Long.toHexString(this.pdo2));
        sb.append("\n followingError = ");
        sb.append(this.followingError);
        sb.append(" / followingError = 0x");
        sb.append(Long.toHexString(this.followingError));
        sb.append(this.followingError);
        sb.append("\n Velocity = ");
        sb.append(this.velocity);
        sb.append(" / velocity = 0x");
        sb.append(Long.toHexString(this.velocity));
        return sb.toString();
    }

    public StatusDataPublishedByCarouselController createStatusDataPublishedByCarouselController() {
        StatusDataPublishedByCarouselController status = new StatusDataPublishedByCarouselController(this.isBooted(), this.isInitialized(), this.isInError(), this.getErrorRegister(), this.getErrorHistoryNB(), this.getLastErrorCode(), this.getLastErrorName());
        status.setMode(this.mode);
        status.setState(this.eposState);
        status.setCurrent(this.current);
        status.setPosition(this.position);
        status.setVelocity(this.velocity);
        status.setProfileAcceleration(this.profileAcceleration);
        status.setProfileDeceleration(this.profileDeceleration);
        status.setProfileVelocity(this.profileVelocity);
        status.setAverageCurrent(this.averageCurrent);
        status.setFollowingError(this.followingError);
        status.setPositionSensorType(this.positionSensorType);
        return status;
    }

    public StatusDataPublishedDuringMotionWithEncoderAndHoldingBrake createStatusDataPublishedDuringMotionWithEncoderAndHoldingBrake() {
        StatusDataPublishedDuringMotionWithEncoderAndHoldingBrake status = new StatusDataPublishedDuringMotionWithEncoderAndHoldingBrake();
        status.setCurrent(this.getCurrent());
        status.setAverageCurrent(this.getAverageCurrent());
        status.setVelocity(this.getVelocity());
        status.setFollowingError(this.getFollowingError());
        status.setPosition(this.getPosition());
        status.setHoldingBrakes(this.holdingBrakes);
        return status;
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByCarouselController()));
    }

    @Override
    public void publishDataDuringMotion() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedDuringMotionWithEncoderAndHoldingBrake()));
    }
}

