/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarousel;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;
import org.lsst.ccs.subsystems.fcs.utils.TTC580Utils;

public class SimuTTC580Test
extends CcsTestCaseTemplate {
    private static Subsystem carouselSubsystem;
    private static SimuTTC580 ttc580;
    private static SimuCanOpenInterface canInterface;
    private static SimuCarousel carousel;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF SimuTTC580                 ");
        System.out.println("***************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.carousel.standalone", "true");
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"Carousel", (String)"serialNB:<alias>", (String)"carousel-simu");
        carouselSubsystem.startAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = carouselSubsystem.getComponentLookup();
        ttc580 = (SimuTTC580)lookup.getComponentByPath("hyttc580");
        canInterface = (SimuCanOpenInterface)lookup.getComponentByPath("canInterface");
        carousel = (SimuCarousel)lookup.getComponentByPath("carousel");
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("****************************************************");
        System.out.println("*** shutdown of carousel subsystem               ***");
        System.out.println("****************************************************");
        if (carouselSubsystem != null) {
            carouselSubsystem.shutdownAgent();
            ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        }
        System.getProperties().remove("org.lsst.ccs.fcs.instance.carousel.standalone");
    }

    @Before
    public void setUp() throws DriverException {
        ttc580.initializeAndCheckHardware();
        canInterface.sync();
        ttc580.setPdo1(0L);
        ttc580.setPdo2(0L);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testUpdateFakePDOData() {
        System.out.println("updateFakePDOData");
        long value = 0L;
        ttc580.updateFakePDOData(ttc580.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)ttc580.getPdo1());
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
        value = 1L;
        ttc580.updateFakePDOData(ttc580.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)ttc580.getPdo1());
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
        value = 65535L;
        ttc580.updateFakePDOData(ttc580.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)ttc580.getPdo1());
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
        value = -2234066821449711617L;
        ttc580.updateFakePDOData(ttc580.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)ttc580.getPdo1());
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
        value = -2305671193734396952L;
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
    }

    @Test
    public void testSimulateSocketAtStandby() {
        System.out.println("simulateSocketAtStandby");
        short id = 2;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketAtStandby(id);
        short socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket2 is at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        int expResult = SimuTTC580Test.ttc580.socket2.getStandbyPosition();
        int result = carousel.getPosition();
        Assert.assertEquals((String)"carousel position", (long)expResult, (long)result);
        ttc580.setPdo1(65535L);
        id = 5;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket5 is at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        expResult = SimuTTC580Test.ttc580.socket5.getStandbyPosition();
        result = carousel.getPosition();
        Assert.assertEquals((String)"carousel position", (long)expResult, (long)result);
        ttc580.setPdo1(1024L);
        id = 5;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket5 is at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        long value = -2305671193734396952L;
        id = 1;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        expResult = SimuTTC580Test.ttc580.socket1.getStandbyPosition();
        result = carousel.getPosition();
        Assert.assertEquals((String)"carousel position", (long)expResult, (long)result);
        id = 2;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket2 is at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        expResult = SimuTTC580Test.ttc580.socket2.getStandbyPosition();
        result = carousel.getPosition();
        Assert.assertEquals((String)"carousel position", (long)expResult, (long)result);
        id = 3;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket3 is at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        expResult = SimuTTC580Test.ttc580.socket3.getStandbyPosition();
        result = carousel.getPosition();
        Assert.assertEquals((String)"carousel position", (long)expResult, (long)result);
        id = 4;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket4 is at standby", (boolean)SimuTTC580Test.ttc580.socket4.isAtStandby());
        expResult = SimuTTC580Test.ttc580.socket4.getStandbyPosition();
        result = carousel.getPosition();
        Assert.assertEquals((String)"carousel position", (long)expResult, (long)result);
        id = 5;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("   pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket5 is at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        expResult = SimuTTC580Test.ttc580.socket5.getStandbyPosition();
        result = carousel.getPosition();
        Assert.assertEquals((String)"carousel position", (long)expResult, (long)result);
        id = 1;
        value = -6629247107684441862L;
        System.out.println("socketID=" + id);
        System.out.println("   pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        expResult = SimuTTC580Test.ttc580.socket1.getStandbyPosition();
        result = carousel.getPosition();
        Assert.assertEquals((String)"carousel position", (long)expResult, (long)result);
    }

    @Test
    public void testSimulateSocketNotAtStandby() {
        System.out.println("simulateSocketNotAtStandby");
        short id = 1;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketNotAtStandby(id);
        short socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket1 is not at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        System.out.println("simulateSocketNotAtStandby");
        id = 3;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketNotAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        long value = -2305671193734396952L;
        ttc580.setPdo2(value);
        System.out.println("simulateSocketNotAtStandby with pdo2=" + Long.toBinaryString(value));
        id = 4;
        System.out.println("socketID=" + id);
        System.out.println("   pdo2=" + Long.toBinaryString(value));
        ttc580.simulateSocketNotAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        ttc580.setPdo2(value);
        System.out.println("simulateSocketNotAtStandby");
        id = 5;
        System.out.println("socketID=" + id);
        System.out.println("   pdo2=" + Long.toBinaryString(value));
        ttc580.simulateSocketNotAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket5 is not at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        System.out.println("simulateSocketNotAtStandby");
        id = 1;
        System.out.println("socketID=" + id);
        System.out.println("   pdo2=" + Long.toBinaryString(value));
        ttc580.simulateSocketNotAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket1 is not at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
    }

    @Test
    public void testSimulateSocketAtStandbyOthersNotAtStandby() {
        System.out.println("testSimulateSocketAtStandbyOthersNotAtStandby");
        short id = 1;
        ttc580.simulateSocketAtStandbyOthersNotAtStandby(id);
        System.out.println("socket at STANDBY = " + id);
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        Assert.assertFalse((String)"socket4 is not at standby", (boolean)SimuTTC580Test.ttc580.socket4.isAtStandby());
        Assert.assertFalse((String)"socket5 is not at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        FcsEnumerations.IOModuleStatus result = SimuTTC580Test.ttc580.socket1.getIOModuleStatus();
        FcsEnumerations.IOModuleStatus expResult = FcsEnumerations.IOModuleStatus.IS_SOCKET_AT_STANDBY;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket2.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket3.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket4.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket5.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        id = 3;
        ttc580.simulateSocketAtStandbyOthersNotAtStandby(id);
        System.out.println("socket at STANDBY = " + id);
        Assert.assertTrue((String)"socket3 is at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        Assert.assertFalse((String)"socket1 is not at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertFalse((String)"socket4 is not at standby", (boolean)SimuTTC580Test.ttc580.socket4.isAtStandby());
        Assert.assertFalse((String)"socket5 is not at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        result = SimuTTC580Test.ttc580.socket3.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_SOCKET_AT_STANDBY;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket2.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket1.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket4.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket5.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        id = 5;
        ttc580.simulateSocketAtStandbyOthersNotAtStandby(id);
        System.out.println("socket at STANDBY = " + id);
        Assert.assertTrue((String)"socket5 is at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        Assert.assertFalse((String)"socket1 is not at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertFalse((String)"socket4 is not at standby", (boolean)SimuTTC580Test.ttc580.socket4.isAtStandby());
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        result = SimuTTC580Test.ttc580.socket5.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_SOCKET_AT_STANDBY;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket2.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket1.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket4.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket3.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        id = 4;
        ttc580.simulateSocketAtStandbyOthersNotAtStandby(id);
        System.out.println("socket at STANDBY = " + id);
        Assert.assertTrue((String)"socket4 is at standby", (boolean)SimuTTC580Test.ttc580.socket4.isAtStandby());
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        Assert.assertFalse((String)"socket5 is not at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        Assert.assertFalse((String)"socket1 is not at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        result = SimuTTC580Test.ttc580.socket4.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_SOCKET_AT_STANDBY;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket2.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket5.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket1.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket3.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        id = 1;
        ttc580.simulateSocketAtStandbyOthersNotAtStandby(id);
        System.out.println("socket at STANDBY = " + id);
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        Assert.assertFalse((String)"socket5 is not at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        Assert.assertFalse((String)"socket4 is not at standby", (boolean)SimuTTC580Test.ttc580.socket4.isAtStandby());
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        result = SimuTTC580Test.ttc580.socket1.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_SOCKET_AT_STANDBY;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket2.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket5.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket4.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
        result = SimuTTC580Test.ttc580.socket3.getIOModuleStatus();
        expResult = FcsEnumerations.IOModuleStatus.IS_READY_NOT_IN_POSITION;
        Assert.assertEquals((String)"IO Module Status", (Object)expResult, (Object)result);
    }

    @Test
    public void testSimulateNoSocketAtStandby() {
        ttc580.simulateNoSocketAtStandby();
        Assert.assertFalse((String)"socket1 is not at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        Assert.assertFalse((String)"socket4 is not at standby", (boolean)SimuTTC580Test.ttc580.socket4.isAtStandby());
        Assert.assertFalse((String)"socket5 is not at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
    }

    @Test
    public void testManyTimesSimulateSocketAtStandbyOthersNotAtStandby() {
        for (int i = 1; i < 5; i = (int)((short)(i + 1))) {
            System.out.println("=> testManyTimesSimulateSocketAtStandbyOthersNotAtStandby i=" + i);
            this.testSimulateSocketAtStandbyOthersNotAtStandby();
        }
    }

    @Test
    public void testSimulateLockSensorXminusValue() {
        System.out.println("simulateLockSensorXminusValue");
        long lockValue = 0L;
        ttc580.simulateLockSensorXminusValue(true, lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo1()));
        lockValue = 300L;
        ttc580.simulateLockSensorXminusValue(true, lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo1()));
        lockValue = 4095L;
        ttc580.simulateLockSensorXminusValue(true, lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateLockSensorXminusValueNotAtS() {
        System.out.println("simulateLockSensorXminusValueNotAtS");
        long lockValue = 0L;
        ttc580.simulateLockSensorXminusValue(false, lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo2()));
        lockValue = 300L;
        ttc580.simulateLockSensorXminusValue(false, lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo2()));
        lockValue = 4095L;
        ttc580.simulateLockSensorXminusValue(false, lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo2()));
    }

    @Test
    public void testSimulateFilterPresenceXminusValue() {
        System.out.println("simulateFilterPresenceXminusValue at STANDBY");
        long newValue = 0L;
        ttc580.simulateFilterPresenceXminusValue(true, newValue);
        Assert.assertEquals((String)"filterPresence", (long)newValue, (long)TTC580Utils.getFilterPresenceXm((long)ttc580.getPdo1()));
        newValue = 386L;
        ttc580.simulateFilterPresenceXminusValue(true, newValue);
        Assert.assertEquals((String)"filterPresence", (long)newValue, (long)TTC580Utils.getFilterPresenceXm((long)ttc580.getPdo1()));
        newValue = 4095L;
        ttc580.simulateFilterPresenceXminusValue(true, newValue);
        Assert.assertEquals((String)"filterPresence", (long)newValue, (long)TTC580Utils.getFilterPresenceXm((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateLockSensorXplusValue() {
        System.out.println("simulateLockSensorXplusValue");
        long newValue = 0L;
        ttc580.simulateLockSensorXplusValue(true, newValue);
        Assert.assertEquals((String)"lockValueX+", (long)newValue, (long)TTC580Utils.getLockXp((long)ttc580.getPdo1()));
        newValue = 4000L;
        ttc580.simulateLockSensorXplusValue(true, newValue);
        Assert.assertEquals((String)"lockValueX+", (long)newValue, (long)TTC580Utils.getLockXp((long)ttc580.getPdo1()));
        newValue = 2500L;
        ttc580.simulateLockSensorXplusValue(true, newValue);
        Assert.assertEquals((String)"lockValueX+", (long)newValue, (long)TTC580Utils.getLockXp((long)ttc580.getPdo1()));
        newValue = 4095L;
        ttc580.simulateLockSensorXplusValue(true, newValue);
        Assert.assertEquals((String)"lockValueX+", (long)newValue, (long)TTC580Utils.getLockXp((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateFilterPresenceXplusValue() {
        System.out.println("simulateFilterPresenceXplusValue at STANDBY");
        long newValue = 0L;
        ttc580.simulateFilterPresenceXplusValue(true, newValue);
        Assert.assertEquals((String)"filterPresenceX+", (long)newValue, (long)TTC580Utils.getFilterPresenceXp((long)ttc580.getPdo1()));
        newValue = 24L;
        ttc580.simulateFilterPresenceXplusValue(true, newValue);
        Assert.assertEquals((String)"filterPresenceX+", (long)newValue, (long)TTC580Utils.getFilterPresenceXp((long)ttc580.getPdo1()));
        newValue = 4095L;
        ttc580.simulateFilterPresenceXplusValue(true, newValue);
        Assert.assertEquals((String)"filterPresenceX+", (long)newValue, (long)TTC580Utils.getFilterPresenceXp((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateIOModuleStatus() {
        System.out.println("simulateSimulateIOModuleStatus");
        ttc580.simulateSocketAtStandby((short)1);
        carousel.updateStateWithSensors();
        short newValue = 1;
        ttc580.simulateIOStatus(newValue);
        Assert.assertEquals((String)"IO module status", (long)newValue, (long)TTC580Utils.getIOModuleStatus((long)ttc580.getPdo1()));
        carousel.updateStateWithSensors();
        System.out.println("socket1.getIOModuleStatus()=" + SimuTTC580Test.ttc580.socket1.getIOModuleStatus());
        newValue = 4;
        ttc580.simulateIOStatus(newValue);
        Assert.assertEquals((String)"IO module status", (long)newValue, (long)TTC580Utils.getIOModuleStatus((long)ttc580.getPdo1()));
        carousel.updateStateWithSensors();
        System.out.println("socket1.getIOModuleStatus()=" + SimuTTC580Test.ttc580.socket1.getIOModuleStatus());
        newValue = 7;
        ttc580.simulateIOStatus(newValue);
        Assert.assertEquals((String)"IO module status", (long)newValue, (long)TTC580Utils.getIOModuleStatus((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateIOModuleStatusNotAtS() {
        System.out.println("simulateSimulateIOModuleStatusNotAtS");
        short newValue = 1;
        ttc580.simulateIOStatusNotAtS(newValue);
        Assert.assertEquals((String)"IO module status", (long)newValue, (long)TTC580Utils.getIOModuleStatus((long)ttc580.getPdo2()));
        newValue = 6;
        ttc580.simulateIOStatusNotAtS(newValue);
        Assert.assertEquals((String)"IO module status", (long)newValue, (long)TTC580Utils.getIOModuleStatus((long)ttc580.getPdo2()));
        newValue = 5;
        ttc580.simulateIOStatusNotAtS(newValue);
        Assert.assertEquals((String)"IO module status", (long)newValue, (long)TTC580Utils.getIOModuleStatus((long)ttc580.getPdo2()));
        newValue = 2;
        ttc580.simulateIOStatusNotAtS(newValue);
        Assert.assertEquals((String)"IO module status", (long)newValue, (long)TTC580Utils.getIOModuleStatus((long)ttc580.getPdo2()));
    }

    @Test
    public void testSimuSocketAtSandbyIsLocked() {
        short socketID = 1;
        System.out.println("socket at STANDBY = " + socketID);
        ttc580.simuSocketAtSandbyIsLocked(socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertTrue((String)"clampXminus of socket1 is LOCKED", (boolean)SimuTTC580Test.ttc580.socket1.getClampXminus().isLocked());
        Assert.assertTrue((String)"clampXplus of socket1 is LOCKED", (boolean)SimuTTC580Test.ttc580.socket1.getClampXplus().isLocked());
    }

    @Test
    public void testSimuSocketNotAtSandbyIsLocked() {
        short socketID = 2;
        System.out.println("socket to test = " + socketID);
        ttc580.simuSocketNotAtStandbyIsLocked(socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        Assert.assertTrue((String)"clampXminus of socket2 is LOCKED", (boolean)SimuTTC580Test.ttc580.socket2.getClampXminus().isLocked());
        Assert.assertTrue((String)"clampXplus of socket2 is LOCKED", (boolean)SimuTTC580Test.ttc580.socket2.getClampXplus().isLocked());
    }

    @Test
    public void testSimulateClampIsLocked() {
        short socketID = 1;
        System.out.println("test of simulateClampIsLocked AT STANDBY for clampXminus1");
        ttc580.simulateSocketAtStandby(socketID);
        ttc580.simulateClampIsLocked(true, SimuTTC580Test.ttc580.socket1.getClampXminus());
        int lockValue = 4 * TTC580Utils.getLockXm((long)ttc580.getPdo1());
        int lockMax = SimuTTC580Test.ttc580.carousel.getLockSensorMaxLimitXminus();
        int lockMinLocked = carousel.getMinLockedThreshold();
        System.out.println("lockValue=" + lockValue);
        System.out.println("lockValueMax=" + lockMax);
        System.out.println("lockMinLocked=" + lockMinLocked);
        Assert.assertTrue((String)"lockValue < lockSensorMaxValue", (lockValue < lockMax ? 1 : 0) != 0);
        Assert.assertTrue((String)"lockValue > lockMinLocked", (lockValue > lockMinLocked ? 1 : 0) != 0);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"clampXminus1 lockStatus", (Object)FcsEnumerations.LockStatus.LOCKED, (Object)SimuTTC580Test.ttc580.socket1.getClampXminus().getLockStatus());
        Assert.assertTrue((String)"clampXminus1 is LOCKED", (boolean)SimuTTC580Test.ttc580.socket1.getClampXminus().isLocked());
        System.out.println("test of simulateClampIsLocked AT STANDBY for clampXplus1");
        ttc580.simulateSocketAtStandby(socketID);
        ttc580.simulateClampIsLocked(true, SimuTTC580Test.ttc580.socket1.getClampXplus());
        lockValue = 4 * TTC580Utils.getLockXp((long)ttc580.getPdo1());
        lockMax = SimuTTC580Test.ttc580.carousel.getLockSensorMaxLimitXplus();
        lockMinLocked = carousel.getMinLockedThreshold();
        System.out.println("lockValue=" + lockValue);
        System.out.println("lockValueMax=" + lockMax);
        System.out.println("lockMinLocked=" + lockMinLocked);
        Assert.assertTrue((String)"lockValue < lockSensorMaxValue", (lockValue < lockMax ? 1 : 0) != 0);
        Assert.assertTrue((String)"lockValue > lockMinLocked", (lockValue > lockMinLocked ? 1 : 0) != 0);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"clampXplus1 lockStatus", (Object)FcsEnumerations.LockStatus.LOCKED, (Object)SimuTTC580Test.ttc580.socket1.getClampXplus().getLockStatus());
        Assert.assertTrue((String)"clampXplus1 is LOCKED", (boolean)SimuTTC580Test.ttc580.socket1.getClampXplus().isLocked());
    }

    @Test
    public void testSimuSocketIsUnlocked() {
        short socketID = 5;
        System.out.println("test of simulateClampIsUnlocked AT STANDBY for socket5");
        ttc580.simulateSocketAtStandby(socketID);
        ttc580.simuSocketIsUnlocked(true, socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket5 is at standby", (boolean)SimuTTC580Test.ttc580.socket5.isAtStandby());
        Assert.assertEquals((String)"clampXminus5 lockStatus", (Object)FcsEnumerations.LockStatus.UNLOCKED, (Object)SimuTTC580Test.ttc580.socket5.getClampXminus().getLockStatus());
        Assert.assertEquals((String)"clampXplus5 lockStatus", (Object)FcsEnumerations.LockStatus.UNLOCKED, (Object)SimuTTC580Test.ttc580.socket5.getClampXplus().getLockStatus());
        Assert.assertFalse((String)"clampXminus5 is UNLOCKED", (boolean)SimuTTC580Test.ttc580.socket5.getClampXplus().isLocked());
        Assert.assertFalse((String)"clampXplus5 is UNLOCKED", (boolean)SimuTTC580Test.ttc580.socket5.getClampXplus().isLocked());
        System.out.println("test of simulateClampIsUnlocked NOT AT STANDBY for socket4");
        socketID = 4;
        ttc580.simulateSocketNotAtStandby(socketID);
        ttc580.simuSocketIsUnlocked(false, socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket4 is not at standby", (boolean)SimuTTC580Test.ttc580.socket4.isAtStandby());
        Assert.assertEquals((String)"clampXminus4 lockStatus", (Object)FcsEnumerations.LockStatus.UNLOCKED, (Object)SimuTTC580Test.ttc580.socket4.getClampXminus().getLockStatus());
        Assert.assertEquals((String)"clampXplus4 lockStatus", (Object)FcsEnumerations.LockStatus.UNLOCKED, (Object)SimuTTC580Test.ttc580.socket4.getClampXplus().getLockStatus());
        Assert.assertFalse((String)"clampXminus4 is UNLOCKED", (boolean)SimuTTC580Test.ttc580.socket4.getClampXplus().isLocked());
        Assert.assertFalse((String)"clampXplus4 is UNLOCKED", (boolean)SimuTTC580Test.ttc580.socket4.getClampXplus().isLocked());
    }

    @Test
    public void testSimulateClampIsUnlocked() {
        short socketID = 1;
        System.out.println("test of simulateClampIsUnlocked AT STANDBY for clampXminus1");
        ttc580.simulateSocketAtStandby(socketID);
        ttc580.simulateClampIsUnlocked(true, SimuTTC580Test.ttc580.socket1.getClampXminus());
        int lockValue = 4 * TTC580Utils.getLockXm((long)ttc580.getPdo1());
        int lockMin = SimuTTC580Test.ttc580.carousel.getLockSensorMinLimitXminus();
        int offset1 = SimuTTC580Test.ttc580.socket1.getClampXminus().getLockSensorOffset1();
        System.out.println("lockValue=" + lockValue);
        System.out.println("lockValueMin=" + lockMin);
        System.out.println("offset1=" + offset1);
        Assert.assertTrue((String)"lockValue > lockSensorMinLimit", (lockValue > lockMin ? 1 : 0) != 0);
        Assert.assertTrue((String)"lockValue < offset1", (lockValue < offset1 ? 1 : 0) != 0);
    }

    @Test
    public void testSimuSocketLockable() {
        short socketID = 1;
        System.out.println("test of simuSocketLockable AT STANDBY for socket1");
        ttc580.simulateSocketAtStandby(socketID);
        ttc580.simuSocketLockable(true, socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertEquals((String)"FilterPresenceStatus of clampXminus1", (Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE, (Object)SimuTTC580Test.ttc580.socket1.getClampXminus().getFilterPresenceStatus());
        Assert.assertEquals((String)"FilterPresenceStatus of clampXplus1", (Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE, (Object)SimuTTC580Test.ttc580.socket1.getClampXplus().getFilterPresenceStatus());
        socketID = 2;
        System.out.println("test of simuSocketLockable NOT AT STANDBY for socket2");
        ttc580.simulateSocketNotAtStandby(socketID);
        ttc580.simuSocketLockable(false, socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)SimuTTC580Test.ttc580.socket2.isAtStandby());
        Assert.assertEquals((String)"FilterPresenceStatus of clampXminus2", (Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE, (Object)SimuTTC580Test.ttc580.socket2.getClampXminus().getFilterPresenceStatus());
        Assert.assertEquals((String)"FilterPresenceStatus of clampXplus2", (Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE, (Object)SimuTTC580Test.ttc580.socket2.getClampXplus().getFilterPresenceStatus());
    }

    @Test
    public void testSimuSocketNoFilter() {
        short socketID = 1;
        System.out.println("test of simuSocketNoFilter AT STANDBY for socket1");
        ttc580.simulateSocketAtStandby(socketID);
        ttc580.simuSocketNoFilter(true, socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertEquals((String)"FilterPresenceStatus of clampXminus1", (Object)FcsEnumerations.FilterPresenceStatus.NOFILTER, (Object)SimuTTC580Test.ttc580.socket1.getClampXminus().getFilterPresenceStatus());
        Assert.assertEquals((String)"FilterPresenceStatus of clampXplus1", (Object)FcsEnumerations.FilterPresenceStatus.NOFILTER, (Object)SimuTTC580Test.ttc580.socket1.getClampXplus().getFilterPresenceStatus());
        socketID = 3;
        System.out.println("test of simuSocketNoFilter NOT AT STANDBY for socket3");
        ttc580.simulateSocketNotAtStandby(socketID);
        ttc580.simuSocketNoFilter(false, socketID);
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"socket3 is at standby", (boolean)SimuTTC580Test.ttc580.socket3.isAtStandby());
        Assert.assertEquals((String)"FilterPresenceStatus of clampXminus3", (Object)FcsEnumerations.FilterPresenceStatus.NOFILTER, (Object)SimuTTC580Test.ttc580.socket3.getClampXminus().getFilterPresenceStatus());
        Assert.assertEquals((String)"FilterPresenceStatus of clampXplus3", (Object)FcsEnumerations.FilterPresenceStatus.NOFILTER, (Object)SimuTTC580Test.ttc580.socket3.getClampXplus().getFilterPresenceStatus());
    }

    @Test
    public void testSimuSocketClampedOnFilter() {
        short socketID = 1;
        boolean atStandby = true;
        System.out.println("test of simuClampedOnFilter AT STANDBY for socket1");
        ttc580.simulateSocketClampedOnFilter(atStandby, socketID);
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertTrue((String)"socket is CLAMPEDONFILTER", (boolean)SimuTTC580Test.ttc580.socket1.isClampedOnFilter());
    }

    @Test
    public void testSimuSocketUnclampedOnFilter() {
        short socketID = 1;
        boolean atStandby = true;
        System.out.println("test of simuUnclampedOnFilter AT STANDBY for socket1");
        ttc580.simulateSocketUnclampedOnFilter(atStandby, socketID);
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertTrue((String)"socket1 is UNCLAMPEDONFILTER", (boolean)SimuTTC580Test.ttc580.socket1.isUnclampedOnFilter());
    }

    @Test
    public void testSimuSocketUnclampedEmpty() {
        short socketID = 1;
        boolean atStandby = true;
        System.out.println("test of simuUnclampedEmpty AT STANDBY for socket1");
        ttc580.simulateSocketUnclampedEmpty(atStandby, socketID);
        Assert.assertTrue((String)"socket1 is at standby", (boolean)SimuTTC580Test.ttc580.socket1.isAtStandby());
        Assert.assertTrue((String)"socket1 is UNCLAMPEDEMPTY", (boolean)SimuTTC580Test.ttc580.socket1.isUnclampedEmpty());
    }

    @Test
    public void testSimulateSocketREADYTOCLAMP() {
        short socketID = 1;
        System.out.println("test of SimulateSocketREADYTOCLAMP AT STANDBY for socket1");
        ttc580.simulateSocketREADYTOCLAMP(socketID);
        Assert.assertFalse((String)"clampXminus is Unlocked", (boolean)SimuTTC580Test.ttc580.socket1.getClampXminus().isLocked());
        Assert.assertTrue((String)"clampXplus is Locked", (boolean)SimuTTC580Test.ttc580.socket1.getClampXplus().isLocked());
        Assert.assertEquals((String)"clampXminus state", (Object)FcsEnumerations.FilterClampState.UNCLAMPED_EMPTY, (Object)SimuTTC580Test.ttc580.socket1.getClampXminus().getClampState());
        Assert.assertEquals((String)"clampXplus state", (Object)FcsEnumerations.FilterClampState.READY_TO_CLAMP, (Object)SimuTTC580Test.ttc580.socket1.getClampXplus().getClampState());
        Assert.assertEquals((String)"socket1 state", (Object)FcsEnumerations.FilterClampState.READY_TO_CLAMP, (Object)SimuTTC580Test.ttc580.socket1.getClampsState());
        Assert.assertTrue((String)"socket1 is READYTOCLAMP", (boolean)SimuTTC580Test.ttc580.socket1.isReadyToClamp());
    }
}

