/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;

public class FilterManager
implements HasLifecycle {
    private static final Logger FCSLOG = Logger.getLogger(FilterManager.class.getName());
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<Filter> filters = new ArrayList<Filter>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final TreeMap<String, Filter> filtersMapByName = new TreeMap();
    private final TreeMap<Integer, Filter> filtersMapByID = new TreeMap();

    public TreeMap<String, Filter> getFiltersMapByName() {
        TreeMap filtersMap = (TreeMap)this.filtersMapByName.clone();
        return filtersMap;
    }

    public TreeMap<Integer, Filter> getFiltersMapByID() {
        TreeMap filtersMap = (TreeMap)this.filtersMapByID.clone();
        return filtersMap;
    }

    public void init() {
        for (Filter f : this.filters) {
            FCSLOG.info("Add filter to filterManager:" + f.getName());
            this.filtersMapByID.put(f.getFilterID(), f);
        }
    }

    public Filter getFilterByName(String filterName) {
        return this.filtersMapByName.get(filterName);
    }

    public int getFilterID(String filterName) {
        this.checkFilterName(filterName);
        return this.getFilterByName(filterName).getFilterID();
    }

    public Filter getFilterByID(int id) {
        if (this.filtersMapByID.containsKey(id)) {
            return this.filtersMapByID.get(id);
        }
        FCSLOG.severe(this.name + " filterId=" + id + " is unknown in fcs configuration.");
        Filter unknownF = new Filter(id, 0.0);
        unknownF.setName("filterID_" + id);
        unknownF.setFamily(FcsEnumerations.FilterFamily.U);
        this.filtersMapByID.put(id, unknownF);
        return unknownF;
    }

    public boolean containsFilterID(int id) {
        return this.filtersMapByID.containsKey(id);
    }

    public boolean containsFilterName(String filterName) {
        return this.filtersMapByName.containsKey(filterName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return filter name which correspond to ID.")
    public String getFilterNameByID(int id) {
        if (this.filtersMapByID.containsKey(id)) {
            return this.filtersMapByID.get(id).getName();
        }
        if (id != 0) {
            FCSLOG.warning(this.name + ": " + id + "  unknown filter ID. Please update filterManager configuration.");
        }
        return "filterID_" + id;
    }

    public List<String> getFilterNamesSortedByFilterID() {
        ArrayList<String> namesList = new ArrayList<String>();
        TreeMap<Integer, String> filterNamesByID = new TreeMap<Integer, String>();
        for (Map.Entry<String, Filter> entry : this.filtersMapByName.entrySet()) {
            Filter filter = entry.getValue();
            filterNamesByID.put(filter.getFilterID(), filter.getName());
        }
        namesList.addAll(filterNamesByID.values());
        return namesList;
    }

    public List<String> getFilterNames() {
        ArrayList<String> namesList = new ArrayList<String>();
        namesList.addAll(this.filtersMapByName.keySet());
        return namesList;
    }

    protected void checkFilterName(String filterName) {
        if (this.getFilterByName(filterName) == null) {
            throw new IllegalArgumentException("Unknown filter name : " + filterName);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return a printed list of filters.", alias="printFilterList")
    public String toString() {
        return this.filtersMapByName.toString();
    }
}

