/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForOnlineClamp;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class CanOpenEPOSOnlineClamp
extends CanOpenEPOS
implements EPOSControllerForOnlineClamp {
    private boolean homingDone = false;
    private boolean brakeActivatedPub = false;

    @Override
    public void init() {
        super.init();
        this.hasEncoder = true;
    }

    @Override
    public boolean isBrakeActivatedPub() {
        return this.brakeActivatedPub;
    }

    @Override
    public void setBrakeActivatedPub(boolean brakeActivatedToPublish) {
        this.brakeActivatedPub = brakeActivatedToPublish;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release brake to be able to move clamp.")
    public void releaseBrake() {
        if (!this.isEnabled()) {
            throw new RejectedCommandException(this.name + " can't releaseBrake if not enabled.");
        }
        this.doReleaseBrake();
    }

    public void shutdown() {
        super.shutdown();
        if (this.isBooted()) {
            this.activateBrakeAndDisable();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return true if homing is done: the controller knows its absolute position.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Perform homing procedure of the clamp.")
    public void homing() {
        this.homingDone = false;
        this.defineAbsolutePosition(0);
        this.position = this.readPosition();
        if (this.position != 0) {
            throw new FcsHardwareException(this.name + " could not do homing.");
        }
        this.homingDone = true;
        this.activateBrakeAndDisable();
    }
}

