/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.errors.ControllerFaultException;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenEPOS
extends CanOpenDevice
implements EPOSController {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    protected boolean parametersOK = true;
    protected EPOSEnumerations.EposMode mode;
    protected int statusWord;
    protected EPOSEnumerations.EposState eposState;
    protected int current;
    protected int averageCurrent;
    protected int position;
    protected int followingError;
    protected int velocity;
    protected long profileVelocity;
    protected long profileAcceleration;
    protected long profileDeceleration;
    @ConfigurationParameter(maxLength=20, category="controller")
    private volatile Map<String, Integer> paramsForHoming = new HashMap<String, Integer>();
    @ConfigurationParameter(maxLength=20, category="controller")
    private volatile Map<String, Integer> paramsForProfilePosition = new HashMap<String, Integer>();
    @ConfigurationParameter(maxLength=20, category="controller")
    private volatile Map<String, Integer> paramsForCurrent = new HashMap<String, Integer>();
    protected boolean hasEncoder = false;
    protected boolean simuEnabled = false;

    @Override
    public boolean isInError() {
        return super.isInError();
    }

    @Override
    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByEPOSController.class, this.path);
    }

    @Override
    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        ClearAlertHandler emcyClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                CanOpenEPOS.this.doFaultReset();
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.PARAMETER_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.EMCY.getAlert(this.name), emcyClear);
    }

    @Override
    public int getStatusWord() {
        return this.statusWord;
    }

    @Override
    public void setEposState(EPOSEnumerations.EposState state) {
        this.eposState = state;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="display EPOS state")
    public EPOSEnumerations.EposState getEposState() {
        return this.eposState;
    }

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public int getAverageCurrent() {
        return this.averageCurrent;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getFollowingError() {
        return this.followingError;
    }

    @Override
    public int getVelocity() {
        return this.velocity;
    }

    @Override
    public long getProfileAcceleration() {
        return this.profileAcceleration;
    }

    @Override
    public long getProfileDeceleration() {
        return this.profileDeceleration;
    }

    @Override
    public long getProfileVelocity() {
        return this.profileVelocity;
    }

    @Override
    public void setCurrent(int current) {
        this.current = current;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    @Override
    public void setProfileVelocity(long velocity) {
        this.profileVelocity = velocity;
    }

    @Override
    public void setProfileAcceleration(long acceleration) {
        this.profileAcceleration = acceleration;
    }

    @Override
    public void setProfileDeceleration(long deceleration) {
        this.profileDeceleration = deceleration;
    }

    @Override
    public boolean isParametersOK() {
        return this.parametersOK;
    }

    @Override
    public EPOSEnumerations.EposMode getMode() {
        return this.mode;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Reads the EPOS mode in the CPU of the EPOS device and updates the field mode.")
    public EPOSEnumerations.EposMode readMode() {
        try {
            EPOSEnumerations.EposMode readMode;
            int m = (int)this.readSDO(24673, 0);
            this.mode = readMode = EPOSEnumerations.EposMode.getMode((int)m);
            return readMode;
        }
        catch (SDORequestException ex) {
            String msg = " no response to command: readMode - POWER FAILURE ? ";
            this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, msg, this.name, (Exception)((Object)ex));
            return this.mode;
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Changes EPOS mode in the CPU of the EPOS device and updates the field mode.")
    public void changeMode(EPOSEnumerations.EposMode newMode) {
        this.writeSDO(24672, 0, 1, newMode.getMode());
        this.mode = newMode;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Changes an EPOS parameter for this controller. Writes the new value on the CPU of the controller.Changes the new value in the configuration. But doesn't save the new parameter in the CPU. To save in CPU controller, use command saveParameters. To save the new value in the configuration, use command saveChangesForCategory controller.")
    public void changeEPOSParameter(String key, int value) {
        String paramsToChangeName;
        Map<String, Integer> paramsToChange;
        EPOSEnumerations.Parameter parameter = EPOSEnumerations.Parameter.valueOf((String)key);
        this.writeParameter(parameter, value);
        EPOSEnumerations.EposMode eposMode = EPOSEnumerations.EposMode.getModeForParameter((EPOSEnumerations.Parameter)parameter);
        if (EPOSEnumerations.EposMode.CURRENT.equals((Object)eposMode)) {
            paramsToChange = this.paramsForCurrent;
            paramsToChangeName = "paramsForCurrent";
        } else if (EPOSEnumerations.EposMode.PROFILE_POSITION.equals((Object)eposMode)) {
            paramsToChange = this.paramsForProfilePosition;
            paramsToChangeName = "paramsForProfilePosition";
        } else if (EPOSEnumerations.EposMode.HOMING.equals((Object)eposMode)) {
            paramsToChange = this.paramsForHoming;
            paramsToChangeName = "paramsForHoming";
        } else {
            throw new IllegalArgumentException(key + " no parameter list is defined for mode: " + eposMode);
        }
        paramsToChange.put(key, value);
        ((ConfigurationService)this.subs.getAgentService(ConfigurationService.class)).getComponentConfigurationEnvironment(this.tcpProxy.name + "/" + this.name).change(paramsToChangeName, paramsToChange);
        FCSCst.FCSLOG.info((Object)(this.name + ":changed EPOS parameter " + key + "for mode " + eposMode));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="This methods writes in the CPU of the EPOS device the values of the parameters set for the mode given as argument")
    public void writeParameters(EPOSEnumerations.EposMode mode) {
        String modeIS = mode.toString();
        Map<String, Integer> paramsMap = null;
        switch (mode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false) : mode;
                break;
            }
        }
        if (paramsMap == null) {
            throw new EPOSConfigurationException(this.name + "parameters for mode :" + modeIS + "are NULL");
        }
        if (paramsMap.isEmpty()) {
            throw new EPOSConfigurationException(this.name + "parameters for mode :" + modeIS + "are not defined.");
        }
        this.writeParameters(paramsMap);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the value given as argument.")
    public void writeParameter(EPOSEnumerations.Parameter param, int value) {
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), value);
        switch (param) {
            case ProfileVelocity: {
                this.profileVelocity = value;
                break;
            }
            case ProfileAcceleration: {
                this.profileAcceleration = value;
                break;
            }
            case ProfileDeceleration: {
                this.profileDeceleration = value;
            }
        }
    }

    @Override
    public long readParameter(EPOSEnumerations.Parameter param) {
        try {
            long value = this.readSDO(param.getIndex(), param.getSubindex());
            FCSCst.FCSLOG.debug((Object)(this.name + " readParameter:" + param.name() + "=" + value + " in decimal format  (valueInHexa=" + Long.toHexString(value) + ")"));
            return EPOSController.convertEPOSValue(param, value, this.name);
        }
        catch (SDORequestException ex) {
            String msg = this.getName() + " Error in reading Parameter: " + param;
            this.raiseWarning(FcsEnumerations.FcsAlert.PARAMETER_ERROR, msg, this.name, (Exception)((Object)ex));
            return 0L;
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read controller's parameter in the CPU for each mode and warn if a parameter has not the same value as in the configuration.Then publish data.")
    public void initializeAndCheckHardware() {
        this.checkBooted();
        this.mode = this.readMode();
        this.parametersOK = true;
        this.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        this.checkParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.checkParameters(EPOSEnumerations.EposMode.HOMING);
        this.checkFault();
        this.initialized = true;
        if (!this.parametersOK) {
            FCSCst.FCSLOG.warning((Object)(this.name + " Some parameter values are not the same in CPU and configuration system."));
        }
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.name + ": is INITIALIZED."));
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Restore default parameters. AT YOUR OWN RISK.")
    public void restoreParameters() {
        this.writeSDO(4113, 1, 4, 1684107116L);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Write a value in the control word. index:6040 subindex:0 size:2")
    public void writeControlWord(int value) {
        this.writeSDO(24640, 0, 2, value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read control word and print it in hexadecimal format. index:6040 subindex:0 size:2")
    public String printControlWord() {
        return Integer.toHexString((short)this.readSDO(24640, 0));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read control word in controller CPU. index:6040 subindex:0 size:2")
    public short readControlWord() {
        return (short)this.readSDO(24640, 0);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read status word. index:6041 subindex:0 size:2")
    public int readStatusWord() {
        this.statusWord = (int)this.readSDO(24641, 0);
        return this.statusWord;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update field statusWord in reading a SDO (readStatusWord)")
    public void updateStatusWord() {
        this.readStatusWord();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Sent current to controller the EPOS CPU. UNIT in mA / FORMAT in decimal")
    public void writeCurrent(int aValue) {
        if (!EPOSEnumerations.EposMode.CURRENT.equals((Object)this.mode)) {
            throw new RejectedCommandException(this.name + " is not in CURRENT mode.");
        }
        this.writeSDO(8240, 0, 2, aValue);
        FCSCst.FCSLOG.info((Object)(this.name + ": sent current to controller=" + aValue));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentActualValue", description="In Current Mode this methods returns the current actualy received by the motor. index:0x6078 subindex:0")
    public int readCurrent() {
        long unsCurrent = this.readSDO(24696, 0);
        this.current = FcsUtils.convertInteger16(unsCurrent);
        FCSCst.FCSLOG.debug((Object)(this.name + ":readCurrent=" + this.current + " Integer16 read=" + unsCurrent));
        return this.current;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentAverage", description="In Current Mode this methods returns the average of the current  received by the motor. index:0x2027 subindex:0")
    public int readCurrentAverageValue() {
        long readAverageCurrent = this.readSDO(8231, 0);
        this.averageCurrent = FcsUtils.convertInteger16(readAverageCurrent);
        FCSCst.FCSLOG.debug((Object)(this.name + ":readAverageCurrent SDO=" + readAverageCurrent + " average current = " + this.averageCurrent));
        return this.averageCurrent;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return motor velocity read on controller CPU. Units: rpm. index:0x2028 subindex:0")
    public int readVelocity() {
        long unsVelocity = this.readSDO(8232, 0);
        this.velocity = FcsUtils.convertInteger32(unsVelocity);
        FCSCst.FCSLOG.debug((Object)(this.name + " Velocity actual value averaged:" + this.velocity + " Unsigned value:" + unsVelocity));
        return this.velocity;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return Following Error Actual Value read on controller CPU. index:0x20F4 subindex:0")
    public int readFollowingError() {
        this.followingError = FcsUtils.convertInteger16(this.readSDO(8436, 0));
        FCSCst.FCSLOG.debug((Object)(this.name + " Following Error Actual Value =" + this.followingError));
        return this.followingError;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position. Target position has to be given in microns. index:0x607A subindex:0 size:4")
    public void writeTargetPosition(int aValue) {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new RejectedCommandException(this.name + " is not in PROFILE_POSITION mode");
        }
        this.writeSDO(24698, 0, 4, aValue);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
        this.checkBooted();
        if (this.readNumberOfErrors() > 0) {
            this.inError = true;
            int errorRegisterCode = this.readErrorRegister();
            this.errorRegister = CanOpenErrorsTable.getErrorRegisterNameByCode(errorRegisterCode);
            this.updateErrorHistory();
            this.publishData();
            String errorHistoryString = this.displayErrorHistory();
            FCSCst.FCSLOG.severe((Object)("controller in fault " + this.name + " statusword " + Integer.toBinaryString(this.readStatusWord()) + " error register " + this.getErrorRegister() + " last error code " + this.getLastErrorCode()));
            FCSCst.FCSLOG.severe((Object)("controller in fault " + this.name + " " + errorHistoryString));
            this.raiseAlarm(FcsEnumerations.FcsAlert.EMCY, errorHistoryString, this.name);
            throw new ControllerFaultException(this.name + " is in fault. " + errorHistoryString);
        }
        this.resetError();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Clear faults on the controller and clear the Alert.", alias="resetFault")
    public void faultReset() {
        this.doFaultReset();
        try {
            this.clearAlarm(FcsEnumerations.FcsAlert.EMCY, this.name);
        }
        catch (IllegalArgumentException ex) {
            FCSCst.FCSLOG.info((Object)(this.name + String.format(" no %s alert had been raised for ", FcsEnumerations.FcsAlert.EMCY.toString())), (Throwable)ex);
        }
    }

    private void doFaultReset() {
        this.writeControlWord(0);
        FcsUtils.sleep(10, this.name);
        this.writeControlWord(128);
        this.resetError();
        this.updateEposState();
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="For every parameter to be defined for this mode this method compares the values in configuration with the value stored in controller CPUand throws a FcsHardwareException if these values are not equal.")
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (paramsMap == null) {
            throw new FcsHardwareException(this.name + "parameters for mode :" + aMode.toString() + "are NULL in configuration system.");
        }
        if (paramsMap.isEmpty()) {
            throw new FcsHardwareException(this.name + "parameters for mode :" + aMode.toString() + "are not defined in configuration system.");
        }
        this.checkParameters(paramsMap);
    }

    public void checkParameters(Map<String, Integer> paramsMap) {
        boolean errorFound = false;
        String causeError = "";
        for (Map.Entry<String, Integer> entry : paramsMap.entrySet()) {
            String paramName = entry.getKey();
            int configValue = entry.getValue();
            long controllerValue = 0L;
            try {
                controllerValue = this.readParameter(paramName);
            }
            catch (SDORequestException ex) {
                String cause = this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription() + " to command: checkParameters - POWER FAILURE ? ";
                this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, cause, this.name, (Exception)((Object)ex));
            }
            if ((long)configValue == controllerValue) continue;
            causeError = causeError + paramName + " value found in configuration=" + configValue + " value read in CPU=" + controllerValue + " \n";
            errorFound = true;
        }
        if (errorFound) {
            this.raiseWarning(FcsEnumerations.FcsAlert.PARAMETER_ERROR, causeError, this.name);
        }
        this.parametersOK = !errorFound;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Publish data for the controller on the status bus.")
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByEPOSController()));
    }

    @Override
    public void publishDataDuringMotion() {
        if (this.hasEncoder) {
            this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedDuringMotionWithEncoder()));
        } else {
            this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedDuringMotionNoEncoder()));
        }
    }
}

