/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselBrakes;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.common.AcceleroInterface;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.PT100Interface;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.common.TTC580Interface;
import org.lsst.ccs.subsystems.fcs.errors.ControllerFaultException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Carousel
extends MobileItem
implements FilterHolder,
AlertRaiser {
    private static final long serialVersionUID = -2376279469784152348L;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistenceService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private int rotationTimeout;
    protected int position = 0;
    private int relativeTargetPosition;
    protected int absoluteTargetPosition;
    protected int startPosition;
    @ConfigurationParameter(description="below this value of deltaPosition, carousel position at STANDBY is correct [carousel encoder step]", units="unitless", range="0..2181120", category="carousel")
    private volatile int minStandbyDeltaPosition = 100;
    @ConfigurationParameter(description="over this value of deltaPosition, carousel position at STANDBY is NOT correct [carousel encoder step]", units="unitless", range="0..2181120", category="carousel")
    private volatile int maxStandbyDeltaPosition = 130;
    private final int fullTurn = 4362240;
    private final int halfTurn = 2181120;
    @ConfigurationParameter(description="velocity in slow mode [rpm]", units="unitless", range="0..5000", category="carousel")
    public volatile int slowVelocity = 500;
    @ConfigurationParameter(description="acceleration in slow mode [rpm/s]", units="unitless", range="0..5000", category="carousel")
    public volatile int slowAcceleration = 200;
    @ConfigurationParameter(description="deceleration in slow mode [rpm/s]", units="unitless", range="0..5000", category="carousel")
    public volatile int slowDeceleration = 200;
    @ConfigurationParameter(description="in milliseconds; timeout for the rotation in slow mode", units="millisecond", range="0..300000", category="carousel")
    public volatile int slowRotationTimeout = 100000;
    @ConfigurationParameter(description="velocity in fast mode [rpm]", units="unitless", range="0..5000", category="carousel")
    public volatile int fastVelocity = 3400;
    @ConfigurationParameter(description="acceleration in fast mode [rpm/s]", units="unitless", range="0..5000", category="carousel")
    public volatile int fastAcceleration = 2000;
    @ConfigurationParameter(description="deceleration in fast mode [rpm/s]", units="unitless", range="0..5000", category="carousel")
    public volatile int fastDeceleration = 1000;
    @ConfigurationParameter(description="in milliseconds; timeout for the rotation in fast mode", units="millisecond", range="0..300000", category="carousel")
    public volatile int fastRotationTimeout = 20000;
    @ConfigurationParameter(description="This is the time to wait until protection system changes its status after motions.", units="millisecond", range="0..5000", category="carousel")
    public volatile long timeToUpdateProtectionSystem = 2000L;
    @ConfigurationParameter(description="for command unlock of carousel clamp : current to send to prepare unlock", range="-3200..3200", units="mA", category="carousel")
    protected volatile int currentToPrepareUnlock = -100;
    @ConfigurationParameter(description="for command unlock of carousel clamp : time between little current to prepare hardware and currentToLock ", range="0..500", units="millisecond", category="carousel")
    protected volatile int timeToPrepareUnlock = 200;
    @ConfigurationParameter(description="A current to be sent to clampXminus controller during locking recovery.", units="mV", range="0..1000", category="carousel")
    public volatile int recoveryLockingCurrent = 400;
    @ConfigurationParameter(description="If the velocity in clampXminus controller goes over this value during locking recovery, it means that the recovery process has failed. [rpm]", units="unitless", range="0..100", category="carousel")
    public volatile int recoveryMaxVelocity = 60;
    @ConfigurationParameter(description="A number of steps to go back if after rotation carousel position has exceeded standbyPosition by more than maxStandbyDeltaPosition. [carousel encoder step]", units="unitless", range="0..2181120", category="carousel")
    public volatile int recoveryBackwardStep = 10000;
    @ConfigurationParameter(description="A number of steps to go back if after rotation carousel position has exceeded standbyPosition by more than maxStandbyDeltaPosition. [carousel encoder step]", units="unitless", range="0..2181120", category="carousel")
    public volatile int recoveryForwardStep = 150000;
    @ConfigurationParameter(description="upper brake1 limit for state CLOSED", units="mV", category="carousel")
    private volatile int brake1Limit = 19033;
    @ConfigurationParameter(description="upper brake2 limit for state CLOSED", units="mV", category="carousel")
    private volatile int brake2Limit = 16959;
    @ConfigurationParameter(description="upper brake3 limit for state CLOSED", units="mV", category="carousel")
    private volatile int brake3Limit = 21063;
    private FcsEnumerations.BrakeState brakeState1;
    private FcsEnumerations.BrakeState brakeState2;
    private FcsEnumerations.BrakeState brakeState3;
    private static int BRAKE_NO_SENSOR_LIMIT = 500;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/clampXminusController")
    private EPOSController clampXminusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/clampXplusController")
    private EPOSController clampXplusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/carouselController")
    protected EPOSControllerForCarousel carouselController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/hyttc580")
    private TTC580Interface hyttc580;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/ai814")
    protected ADCInterface ai814;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/pt100")
    private PT100Interface pt100;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/accelerobf")
    public AcceleroInterface accelerobf;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, CarouselSocket> socketsMap = new TreeMap<String, CarouselSocket>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Map<String, SensorPluggedOnTTC580> sensorsMap = new HashMap<String, SensorPluggedOnTTC580>();
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="canbus0")
    protected BridgeToHardware tcpProxy;
    private boolean initialized = false;
    protected boolean clampsStateInitialized = false;
    private int socketAtStandbyID;
    protected CarouselSocket socketAtStandby;
    protected volatile int minLockedThreshold = 9500;
    @ConfigurationParameter(description="If lockSensor side X- returns a value < lockSensorMinLimitXminus, sensor is in ERROR.", range="0..12000", units="mV", category="carousel")
    private volatile int lockSensorMinLimitXminus = 201;
    @ConfigurationParameter(description="If lockSensor side X+ returns a value < lockSensorMinLimitXplus, sensor is in ERROR.", range="0..12000", units="mV", category="carousel")
    private volatile int lockSensorMinLimitXplus = 202;
    @ConfigurationParameter(description="If lockSensor side X- returns a value above lockSensorMaxLimitXminus, the sensor is in error.", range="0..12000", units="mV", category="carousel")
    private volatile int lockSensorMaxLimitXminus = 10001;
    @ConfigurationParameter(description="If lockSensor side X+ returns a value above lockSensorMaxLimitXplus, the sensor is in error.", range="0..12000", units="mV", category="carousel")
    private volatile int lockSensorMaxLimitXplus = 11002;
    @ConfigurationParameter(range="0..12000", units="mV", category="carousel")
    private volatile int filterPresenceMinNoFilter = 9200;
    private long meanClampsTemperature;
    AtomicLong lastUpdateStateWithSensors = new AtomicLong(0L);
    AtomicLong lastUpdateLockSensorMinLocked = new AtomicLong(0L);
    AtomicLong lastUpdateTemperatures = new AtomicLong(0L);

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByCarousel.class, this.name);
        this.registerAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION);
        this.registerAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION);
    }

    public void init() {
        super.init();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.carouselController.getName()), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.IN_FAULT.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY_FAILURE.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY_SUCCESS.getAlert(this.name), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if CANopen devices are booted and initialized and homing has been done.")
    boolean isInitialized() {
        return this.myDevicesReady();
    }

    public boolean isRotationAllowedByPLC() {
        return this.sensorsMap.get("carousel/plc/caEnableRotation").getValue() == 1;
    }

    public boolean isUnclampAllowedByPLC() {
        return this.sensorsMap.get("carousel/plc/caEnableUnclamp").getValue() == 1;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if clamp state is initialized for all clamps.")
    public boolean isClampsStateInitialized() {
        return this.clampsStateInitialized;
    }

    public int getCurrentToPrepareUnlock() {
        return this.currentToPrepareUnlock;
    }

    public int getTimeToPrepareUnlock() {
        return this.timeToPrepareUnlock;
    }

    public Integer getMinLockedThreshold() {
        return this.minLockedThreshold;
    }

    public int getLockSensorMinLimitXminus() {
        return this.lockSensorMinLimitXminus;
    }

    public int getLockSensorMinLimitXplus() {
        return this.lockSensorMinLimitXplus;
    }

    public int getLockSensorMaxLimitXminus() {
        return this.lockSensorMaxLimitXminus;
    }

    public int getLockSensorMaxLimitXplus() {
        return this.lockSensorMaxLimitXplus;
    }

    public int getFilterPresenceMinNoFilter() {
        return this.filterPresenceMinNoFilter;
    }

    public int getRecoveryLockingCurrent() {
        return this.recoveryLockingCurrent;
    }

    public int getRecoveryMaxVelocity() {
        return this.recoveryMaxVelocity;
    }

    public int getFullTurn() {
        return 4362240;
    }

    public Map<String, CarouselSocket> getSocketsMap() {
        return this.socketsMap;
    }

    public CarouselSocket getSocketByName(String socketName) {
        if (this.socketsMap.containsKey(socketName)) {
            return this.socketsMap.get(socketName);
        }
        throw new IllegalArgumentException(this.name + ": no such name for socket:" + socketName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return carousel position.", alias="printPosition")
    public int getPosition() {
        return this.position;
    }

    public EPOSController getClampXminusController() {
        return this.clampXminusController;
    }

    public EPOSController getClampXplusController() {
        return this.clampXplusController;
    }

    public CarouselClamp getClampXminus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXminus();
    }

    public CarouselClamp getClampXplus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXplus();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a socket is HALTED at STANDBY position, false otherwise.")
    public boolean isAtStandby() {
        return this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5;
    }

    public CarouselSocket getSocketAtStandby() {
        return this.socketAtStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="return ID of socket at STANDBY, 0 if carousel is not stopped at STANDBY")
    public int getSocketAtStandbyID() {
        return this.socketAtStandbyID;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns name of filter at STANDBY position  or NO_FILTER if carousel is not at STANDBY or there is no filter at STANDBY.")
    public String getFilterAtStandbyName() {
        if (this.socketAtStandby == null || this.isEmptyAtStandby()) {
            return "NO FILTER";
        }
        return this.socketAtStandby.getFilterName();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns id of filter at STANDBY position  or 0 if there is no filter at STANDBY.")
    public int getFilterIDatStandby() {
        if (this.socketAtStandby == null) {
            return 0;
        }
        return this.socketAtStandby.getFilterID();
    }

    public boolean isFilterOnCarousel(int filterID) {
        return this.socketsMap.values().stream().anyMatch(socket -> socket.getFilterID() == filterID);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To change filterID on socket which ID is given as argument.")
    public void changeFilterID(int filterID, int socketID) {
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + ": bad value - enter a digit between 1 and 5");
        }
        if (this.isFilterOnCarousel(filterID)) {
            int sockID = this.getFilterSocket(filterID).getId();
            throw new IllegalArgumentException(filterID + " filter already on carousel on socket" + sockID);
        }
        String socketName = "socket" + socketID;
        this.socketsMap.get(socketName).setFilterID(filterID);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize carousel hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.tcpProxy.bootProcess();
        this.postStart();
    }

    public void postStart() {
        FCSLOG.info((Object)(this.name + " BEGIN postStart."));
        if (this.carouselController.isBooted()) {
            this.initializeRotationController();
            long profileVelocity = this.carouselController.readProfileVelocity();
            this.carouselController.readProfileAcceleration();
            this.carouselController.readProfileDeceleration();
            this.rotationTimeout = profileVelocity == (long)this.slowVelocity ? this.slowRotationTimeout : this.fastRotationTimeout;
            try {
                this.updatePosition();
            }
            catch (ControllerFaultException ex) {
                FCSLOG.error((Object)ex.toString());
                this.raiseAlarm(FcsEnumerations.FcsAlert.IN_FAULT, ex.toString(), this.name);
            }
        }
        if (this.clampXminusController.isBooted()) {
            this.initializeClampController(this.clampXminusController);
        }
        if (this.clampXplusController.isBooted()) {
            this.initializeClampController(this.clampXplusController);
        }
        if (this.hyttc580.isBooted()) {
            this.initializeClampsState();
        }
        FCSLOG.info((Object)(this.name + " END postStart."));
    }

    private void initializeRotationController() {
        try {
            this.carouselController.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.carouselController.getName(), (Exception)ex);
        }
    }

    private void initializeClampController(EPOSController controller) {
        try {
            controller.initializeAndCheckHardware();
            if (!controller.isInMode(EPOSEnumerations.EposMode.CURRENT)) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "  is not in CURRENT mode.", controller.getName());
            }
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller ", controller.getName(), (Exception)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Disable carousel controller, set the position sensor to TypeEncoderSSI, and check that the ssi position is correct.")
    public void setControllerPositionSensorTypeEncoderSSI() {
        this.carouselController.setPositionSensorTypeEncoderSSI();
        this.position = this.carouselController.readPosition();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="slow down profile velocity, acceleration and deceleration in carousel controller.")
    public void setSlowMode() {
        this.carouselController.changeProfileVelocity(this.slowVelocity);
        this.carouselController.changeProfileAcceleration(this.slowAcceleration);
        this.carouselController.changeProfileDeceleration(this.slowDeceleration);
        this.rotationTimeout = this.slowRotationTimeout;
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="raise profile velocity, acceleration and deceleration in carousel controller.")
    public void setFastMode() {
        this.carouselController.changeProfileVelocity(this.fastVelocity);
        this.carouselController.changeProfileAcceleration(this.fastAcceleration);
        this.carouselController.changeProfileDeceleration(this.fastDeceleration);
        this.rotationTimeout = this.fastRotationTimeout;
        this.publishData();
    }

    public void waitForProtectionSystemUpdate() {
        this.waitForStateUnclampedOnFilter(this.timeToUpdateProtectionSystem);
    }

    public void waitForStateUnclampedOnFilter(long timeout) {
        FcsUtils.waitCondition(() -> this.isUnclampedOnFilterAtStandby(), () -> this.updateSocketAtStandbyReadSensorsNoPublication(), "waitForStateUnclampedOnFilter", timeout);
    }

    public void checkSensorTypeIncremental() {
        int sensorType = this.carouselController.readPositionSensorType();
        if (sensorType != 8) {
            throw new FcsHardwareException(this.name + " PositionSensorType has to be set to Incremental Encoder before motion.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="save persist file to store which filter is in socket and clamps offsets")
    public void persistData() {
        this.persistenceService.persistNow();
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCarousel()));
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name + "/brakes", (Serializable)this.createStatusDataPublishedByCarouselBrakes()));
    }

    public StatusDataPublishedByCarousel createStatusDataPublishedByCarousel() {
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel();
        status.setPosition(this.position);
        status.setPositionSensorType(this.carouselController.getPositionSensorType());
        status.setEstimatedPosition((this.startPosition + this.position) % 4362240);
        status.setAtStandby(this.isAtStandby());
        status.setMoving(this.moving);
        status.setSocketAtStandbyID(this.socketAtStandbyID);
        status.setFilterAtStandbyName(this.getFilterAtStandbyName());
        status.setFilterAtStandbyId(this.getFilterIDatStandby());
        if (this.isAtStandby()) {
            status.setSocketAtStandbyName(this.socketAtStandby.getName());
            status.setEmptyAtStandby(this.isEmptyAtStandby());
            status.setDeltaPositionAtStandby(this.socketAtStandby.getDeltaPosition());
            status.setClampsStateAtStandby(this.socketAtStandby.getClampsState());
            status.setIOStatusAtStandby(this.socketAtStandby.getIOModuleStatus());
        } else if (this.socketAtStandbyID == 0) {
            status.setSocketAtStandbyName("NO_SOCKET_AT_STANDBY");
        } else if (this.socketAtStandbyID == 7) {
            status.setSocketAtStandbyName("ERROR_READING_ID");
        }
        status.setRotationTimeout((long)this.rotationTimeout);
        status.setMinLocked((long)this.minLockedThreshold);
        status.setMeanClampsTemperature(this.meanClampsTemperature);
        return status;
    }

    public StatusDataPublishedByCarouselBrakes createStatusDataPublishedByCarouselBrakes() {
        StatusDataPublishedByCarouselBrakes status = new StatusDataPublishedByCarouselBrakes();
        status.setSensor1(this.ai814.getInput(0));
        status.setSensor2(this.ai814.getInput(1));
        status.setSensor3(this.ai814.getInput(2));
        status.setBrakeState1(Carousel.computeBrakeState(this.brake1Limit, this.ai814.getInput(0)));
        status.setBrakeState2(Carousel.computeBrakeState(this.brake2Limit, this.ai814.getInput(1)));
        status.setBrakeState3(Carousel.computeBrakeState(this.brake3Limit, this.ai814.getInput(2)));
        status.setTemperature1(this.pt100.getTemperature(1));
        status.setTemperature2(this.pt100.getTemperature(2));
        status.setTemperature3(this.pt100.getTemperature(3));
        status.setTemperature4(this.pt100.getTemperature(4));
        return status;
    }

    private static FcsEnumerations.BrakeState computeBrakeState(int limit, long sensorValue) {
        if (sensorValue > (long)limit) {
            return FcsEnumerations.BrakeState.CLOSED;
        }
        if (sensorValue > (long)BRAKE_NO_SENSOR_LIMIT) {
            return FcsEnumerations.BrakeState.NOBRAKE;
        }
        return FcsEnumerations.BrakeState.NO_SENSOR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if Carousel is stopped and no filter is at STANDBY position")
    public boolean isReadyToGrabAFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (this.socketAtStandby == null) {
            return false;
        }
        if (!this.socketAtStandby.isAvailable()) {
            return false;
        }
        return this.socketAtStandby.isEmpty() && this.socketAtStandby.isReadyToClamp();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if a filter is clamped at STANDBY position")
    public boolean isHoldingFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (this.socketAtStandby == null || this.socketAtStandby.isEmpty()) {
            return false;
        }
        return this.socketAtStandby.isClampedOnFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns false if carousel controller is SWITCH_ON_DISABLED.")
    public boolean isRotating() {
        return !this.carouselController.isInState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="PLC value for carousel brakes activated")
    public boolean isStatusBrakesActivated() {
        return this.sensorsMap.get("carousel/plc/caBrakesActivated").getValue() == 1;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="NOBRAKE signal on all 3 AI814 sensors")
    public boolean areBrakesDisabledFromAI814() {
        return this.brakeState1 == FcsEnumerations.BrakeState.NOBRAKE && this.brakeState2 == FcsEnumerations.BrakeState.NOBRAKE && this.brakeState2 == FcsEnumerations.BrakeState.NOBRAKE;
    }

    protected boolean areBrakesAllowingRotation() {
        return !this.carouselController.isHoldingBrakes() && !this.isStatusBrakesActivated() && this.areBrakesDisabledFromAI814();
    }

    private void updateBrakesStatesFromAI814() {
        this.brakeState1 = Carousel.computeBrakeState(this.brake1Limit, this.ai814.getInput(0));
        this.brakeState2 = Carousel.computeBrakeState(this.brake2Limit, this.ai814.getInput(1));
        this.brakeState3 = Carousel.computeBrakeState(this.brake3Limit, this.ai814.getInput(2));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update brakes status from all sensors")
    public void updateBrakesStatus() {
        this.carouselController.readHoldingBrakes();
        this.tcpProxy.updatePDOData();
        this.updateBrakesStatesFromAI814();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Set position sensor type SSI and update carousel position in reading controller.")
    public void updatePosition() {
        this.setControllerPositionSensorTypeEncoderSSI();
        try {
            this.position = this.carouselController.readPosition();
        }
        catch (SDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    public void updateClampsStateWithSensorsFromPDO() {
        this.tcpProxy.updatePDOData();
        PDOData pdoStore = this.tcpProxy.getPDOData();
        FCSLOG.finest((Object)(this.name + ":pdoStore=" + pdoStore.toString()));
        this.socketsMap.values().stream().forEach(socket -> socket.updateState());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamps state in sending 5 sync.")
    public void initializeClampsState() {
        FCSLOG.info((Object)(this.name + " Initializing clamps state...."));
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        for (int count = 1; count <= 5; count = (int)((byte)(count + 1))) {
            FCSLOG.info((Object)(this.name + " sync no " + count));
            this.tcpProxy.updatePDOData();
            this.hyttc580.updateFromPDO(this.tcpProxy.getPDOData());
            this.updateState();
        }
        this.clampsStateInitialized = true;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carousel clamps offset1 and offset2 in reading hyttc580 and launch an ALARM if values read and different from previous values. The new values are saved in persistence file.")
    public void initializeAndCheckClampsOffset() {
        FCSLOG.info((Object)(this.name + " Initializing clamps offsets...."));
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        this.socketsMap.values().stream().forEach(socket -> {
            byte socketId = (byte)socket.getId();
            long offset2 = this.hyttc580.readOffset2SDO(socketId);
            socket.checkAndUpdateOffset2(offset2);
            long offset1 = this.hyttc580.readOffset1SDO(socketId);
            socket.checkAndUpdateOffset1(offset1);
            socket.getClampXminus().publishData();
            socket.getClampXplus().publishData();
        });
        this.persistData();
    }

    public CarouselSocket getFilterSocket(int filterID) {
        CarouselSocket socket = null;
        for (CarouselSocket sock : this.socketsMap.values()) {
            if (sock.getFilterID() != filterID) continue;
            return sock;
        }
        return socket;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release clamps at standby position to get ready to clamp again")
    public void releaseClamps() {
        this.updateStateWithSensors();
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't release clamps when no socket is halted at standby position.");
        }
        this.socketAtStandby.releaseClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamps at STANDBY.")
    public void unlockClamps() {
        this.updateSocketAtStandbyReadSensorsNoPublication();
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't unlock clamps while a socket is not halted at standby position.");
        }
        FCSLOG.info((Object)"Unlocking clamps at standby.");
        this.socketAtStandby.unlockClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock clampXminus when clampXplus is already locked.")
    public void recoveryLockingXminus() {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't use command recoveryLockingXminus.");
        }
        if (this.socketAtStandby.getClampXplus().getClampState() == FcsEnumerations.FilterClampState.CLAMPEDONFILTER && this.socketAtStandby.getClampXminus().getClampState() != FcsEnumerations.FilterClampState.CLAMPEDONFILTER) {
            this.socketAtStandby.getClampXminus().recoveryLocking();
        }
    }

    public boolean isAtStandby(int filterID) {
        return this.socketAtStandby.getFilterID() != 0 && this.socketAtStandby.getFilterID() == filterID;
    }

    public void releaseClampsContact() {
    }

    @Override
    public boolean myDevicesReady() {
        return this.carouselController.isBooted() && this.carouselController.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if carousel rotation is permitted.")
    public void checkConditionsForRotation() {
        if (!this.initialized) {
            throw new FcsHardwareException("Carousel hardware is not initialized. Can't rotate.");
        }
        if (this.isAtStandby() && this.socketAtStandby.isUnclampedOnFilter()) {
            String message = "Filter at STANDBY position is not held by clamps. Can't rotate carousel.";
            FCSLOG.error((Object)message);
            throw new RejectedCommandException(message);
        }
        if (!this.autochanger.isAtHandoff()) {
            throw new RejectedCommandException(this.name + " can't rotate if autochanger is not at HANDOFF position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to a new absolute position.", timeout=60000)
    public void rotateToAbsolutePosition(int newPos) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("rotateToAbsolutePosition");){
            int absolutePosition;
            if (this.pt100.isBooted()) {
                this.pt100.updateTemperatures();
            }
            this.checkReadyForAction();
            this.carouselController.checkInitialized();
            this.carouselController.checkFault();
            if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                throw new RejectedCommandException(this.name + " can rotate only if autochanger is at Handoff or at Online  ");
            }
            double airmass = this.accelerobf.getAirmass();
            if (airmass > 3.0) {
                this.setSlowMode();
            } else {
                this.setFastMode();
            }
            FcsUtils.sleep(10, this.name);
            this.carouselController.setPositionSensorTypeEncoderSSI();
            this.startPosition = absolutePosition = this.carouselController.readPosition();
            this.carouselController.setPositionSensorTypeSinusIncrementalEncoder();
            int incrementalPosition = this.carouselController.readPosition();
            FCSLOG.info((Object)(this.name + " absolutePosition = " + absolutePosition + " incrementalPosition = " + incrementalPosition));
            int diffPos = newPos - absolutePosition;
            this.absoluteTargetPosition = Math.abs(diffPos) <= 2181120 ? diffPos + incrementalPosition : (diffPos < 0 ? diffPos + incrementalPosition + 4362240 : diffPos + incrementalPosition - 4362240);
            FCSLOG.info((Object)(this.name + " is at incremental position: " + incrementalPosition + "; about to rotate to incremental position" + this.absoluteTargetPosition));
            this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION, this.rotationTimeout);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to a relative position.", timeout=60000)
    public void rotateToRelativePosition(int relativePos, long timeout) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("rotateToRelativePosition");){
            this.carouselController.checkInitialized();
            this.carouselController.checkFault();
            if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
                throw new RejectedCommandException(this.name + " can rotate only if autochanger is at Handoff or at Online.");
            }
            this.carouselController.setPositionSensorTypeSinusIncrementalEncoder();
            int incrementalPosition = this.carouselController.readPosition();
            this.relativeTargetPosition = relativePos + incrementalPosition;
            this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION, timeout);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a socket which name is given as argument to STANDBY position.", alias="moveSocketToStandby", timeout=50000)
    public void rotateSocketToStandby(String socketName) {
        FcsUtils.checkSocketName(socketName);
        CarouselSocket socketToMove = this.socketsMap.get(socketName);
        if (!socketToMove.isAtStandby() || this.socketAtStandbyNeedsRotation(socketToMove)) {
            int requiredPosition = socketToMove.getStandbyPosition();
            FCSLOG.info((Object)(this.name + " is at position: " + this.position + "; about to rotate to position: " + requiredPosition));
            this.rotateToAbsolutePosition(requiredPosition);
            this.checkDeltaPosition();
        }
        FCSLOG.info((Object)(this.name + ":" + socketName + " is at STANDBY position on carousel."));
    }

    public void checkDeltaPosition() {
        if (this.socketAtStandby != null) {
            this.socketAtStandby.updateDeltaPosition();
            long deltaPos = this.socketAtStandby.getDeltaPosition();
            if (Math.abs(deltaPos) > (long)this.maxStandbyDeltaPosition) {
                this.recoveryRotation();
            } else if (Math.abs(deltaPos) > (long)this.minStandbyDeltaPosition) {
                this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " delta position at standby is over " + this.minStandbyDeltaPosition, this.name);
            }
        }
    }

    private boolean socketAtStandbyNeedsRotation(CarouselSocket socket) {
        socket.updateDeltaPosition();
        return Math.abs(socket.getDeltaPosition()) > this.maxStandbyDeltaPosition;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel full turn. A number of turns can be given as argument.")
    public void rotateFullTurn(int nbTurn) {
        if (Math.abs(nbTurn) > 3) {
            throw new IllegalArgumentException("nbTurn=" + nbTurn + " should not be more than 3");
        }
        long timeout = Math.abs(nbTurn) * 2 * this.slowRotationTimeout;
        int rpos = 4362240 * nbTurn;
        this.rotateToRelativePosition(rpos, timeout);
    }

    private void recoveryRotation() {
        if (!this.autochanger.isAtOnline() && !this.autochanger.isAtHandoff()) {
            FCSLOG.info((Object)(this.name + " can rotate only if autochanger is at HANDOFF or ONLINE. Can't execute recoveryRotation."));
            return;
        }
        double airmass = this.accelerobf.getAirmass();
        if (airmass > 2.0) {
            this.recoveryRotationBackward();
            if (Math.abs(this.socketAtStandby.getDeltaPosition()) > this.maxStandbyDeltaPosition) {
                this.recoveryRotationStraight();
            }
        } else {
            this.recoveryRotationStraight();
            this.socketAtStandby.updateDeltaPosition();
            if (Math.abs(this.socketAtStandby.getDeltaPosition()) > this.maxStandbyDeltaPosition) {
                this.recoveryRotationBackward();
            }
        }
        this.socketAtStandby.updateDeltaPosition();
        if (Math.abs(this.socketAtStandby.getDeltaPosition()) > this.maxStandbyDeltaPosition) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY_FAILURE, String.format("After 2 recovery tries delta position at standby is %s is still over %s", this.socketAtStandby.getDeltaPosition(), this.maxStandbyDeltaPosition), this.name);
        } else {
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY_SUCCESS, "After recovery delta position at standby is " + this.socketAtStandby.getDeltaPosition(), this.name);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To be executed when at the end of rotation, carousel positionexceeded position by more than standbyPosition + deltaPositionMax (value around 200).Explanation : If the carousel  socket selected for a filter exchange between the Autochanger and the carousel has a too large offset with the StandBy position, the operation will be stopped/forbidden . To overcome this issue , the carousel socket should be aligned with the StandBy position using a dedicated  recovery  rotation command.  The recoveryRotationBackward command will try to align the carousel socket to the StandBy position by going backward in respect of the previous move , and re-doing the rotation to StandBy but taking into account that an offset (to compensate the play in the brakes) should be added . This method should be the most precise and always work, but it is slow ( ~ 7s ). It is recommended to use it when the \u201cStraight\u201d recovery didn\u2019t work or in case of large unbalance filter configuration (= when loading/unloading  filter in the camera).")
    public void recoveryRotationBackward() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " no socket at STANBY method recoveryRotationBackward is not relevant.");
        }
        int deltaPositionAtStandby = this.socketAtStandby.getDeltaPosition();
        this.raiseWarning(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY, String.format(" delta position at standby = %d is over %d about to try recoveryRotationBackward", this.socketAtStandby.getDeltaPosition(), this.maxStandbyDeltaPosition), this.name);
        int delta_sign = deltaPositionAtStandby >= 0 ? 1 : -1;
        int relativePosition = delta_sign * this.recoveryBackwardStep;
        FCSLOG.info((Object)(this.name + " about to rotateToRelativePosition " + relativePosition));
        this.rotateToRelativePosition(relativePosition, 7000L);
        int newPos = this.socketAtStandby.getStandbyPosition() - deltaPositionAtStandby;
        FCSLOG.info((Object)(this.name + " about to rotateToAbsolutePosition to " + newPos));
        this.rotateToAbsolutePosition(newPos);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To be executed when at the end of rotation, carousel positionexceeded position by more than standbyPosition + deltaPositionMax (value around 200).Explanation: If the carousel  socket selected for a filter exchange between the Autochanger and the carousel has a too large offset with the StandBy position, the operation will be stopped/forbidden. To overcome this issue, the carousel socket should be aligned with the StandBy position using a dedicated  recovery  rotation command.  The recoveryRotationForward command will try to align the carousel socket to the StandBy position by going forward in respect of the previous move, and rotating back to StandBy location. The filter unbalance weight should have then no impact on the precision of the rotation. This recovery method is not the preferred one, as it is slow (~7s) and less precise than the other recovery methods.")
    public void recoveryRotationForward() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " no socket at STANBY method recoveryRotationForward is not relevant.");
        }
        int deltaPositionAtStandby = this.socketAtStandby.getDeltaPosition();
        int delta_sign = deltaPositionAtStandby >= 0 ? 1 : -1;
        int relativePosition = -delta_sign * this.recoveryForwardStep;
        FCSLOG.info((Object)(this.name + " about to rotateToRelativePosition " + relativePosition));
        this.rotateToRelativePosition(relativePosition, 7000L);
        int newPos = this.socketAtStandby.getStandbyPosition();
        FCSLOG.info((Object)(this.name + " about to rotateToAbsolutePosition to " + newPos));
        this.rotateToAbsolutePosition(newPos);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To be executed when at the end of rotation, carousel positionexceeded position by more than standbyPosition + deltaPositionMax (value around 200).Explanation : If the carousel  socket selected for a filter exchange between the Autochanger and the carousel has a too large offset with its StandBy position, the operation will be stopped/forbidden . To overcome this issue , the carousel socket should be aligned with the StandBy position using a dedicated  recovery  rotation command.  The recoveryRotationStraight command will try to align the carousel socket to the StandBy position by doing a simple \u201cstraight\u201d rotation of the measured miss-alignement quantity. This is the fastest method (~3s ) and should work in  most of the cases , in particular if the camera is not horizontal and the filter weight unbalance small.")
    public void recoveryRotationStraight() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " no socket at STANBY method recoveryRotationForward is not relevant.");
        }
        int deltaPositionAtStandby = this.socketAtStandby.getDeltaPosition();
        this.raiseWarning(FcsEnumerations.FcsAlert.CA_ROTATION_RECOVERY, String.format(" delta position at standby = %d is over %d about to try recoveryRotationStraight", this.socketAtStandby.getDeltaPosition(), this.maxStandbyDeltaPosition), this.name);
        int newPos = this.socketAtStandby.getStandbyPosition() - deltaPositionAtStandby;
        FCSLOG.info((Object)(this.name + " about to rotateToAbsolutePosition to " + newPos));
        this.rotateToAbsolutePosition(newPos);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            return this.carouselController.isTargetReached();
        }
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            return this.carouselController.isTargetReached();
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensorsDuringMotion();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.main.updateAgentState(FcsEnumerations.FilterState.valueOf((String)"ROTATING"));
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            this.carouselController.enableAndWriteRelativePosition(this.relativeTargetPosition);
        } else if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            this.carouselController.writeTargetPosition(this.absoluteTargetPosition);
            FcsUtils.checkAndWaitConditionWithTimeoutAndFixedDelay(() -> this.isRotationAllowedByPLC(), () -> this.tcpProxy.updatePDOData(), "checkRotationAllowedByPLC", this.name + ": PLC did not allow motion after trying every 100ms during 500 ms", 500L, 100L);
            FcsUtils.sleep(100, this.name);
            this.carouselController.goToOperationEnable();
            this.updateBrakesStatus();
            if (!this.areBrakesAllowingRotation()) {
                FcsUtils.checkAndWaitConditionWithTimeout(() -> this.areBrakesAllowingRotation(), () -> this.updateBrakesStatus(), "checkCarouselBrakesReleased", this.name + ": carousel brakes are still activated.", 500L);
            }
            this.carouselController.writeControlWord(63);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.carouselController.stopPosition();
        this.carouselController.goToSwitchOnDisabled();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        int deltaPosBeforeDisable = this.position - this.absoluteTargetPosition;
        FCSLOG.info((Object)(this.name + " delta position before disable = " + deltaPosBeforeDisable));
        this.carouselController.goToSwitchOnDisabled();
        this.main.updateAgentState(FcsEnumerations.FilterState.valueOf((String)"CAROUSEL_STOPPED"));
        this.setControllerPositionSensorTypeEncoderSSI();
        this.position = this.carouselController.readPosition();
        this.startPosition = 0;
        FCSLOG.info((Object)(this.name + " position after disable = " + this.position + " delta " + (this.position - this.absoluteTargetPosition)));
        this.initializeClampsState();
        this.updateStateWithSensors();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.carouselController.stopPosition();
        this.carouselController.goToSwitchOnDisabled();
    }

    @Override
    public boolean isHoldingFilter() {
        return this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isNotHoldingFilter() {
        return !this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isAtHandoff() {
        return false;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the ID of filter at STANDBY")
    public int getFilterID() {
        return this.socketAtStandby.getFilterID();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read sensors and update state", timeout=2000)
    public synchronized void updateStateWithSensors() {
        if (System.currentTimeMillis() - this.lastUpdateStateWithSensors.get() < 100L && !FcsUtils.isSimu()) {
            return;
        }
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateStateWithSensors-carousel");){
            this.hyttc580.checkBooted();
            if (!this.clampsStateInitialized) {
                throw new FcsHardwareException(this.name + ": clamps state not initialized.  Please launch command initializeClampsState.");
            }
            this.tcpProxy.updatePDOData();
            this.updateState();
            this.updateMinLockedThreshold();
            this.updateTemperatures();
            this.publishData();
            this.lastUpdateStateWithSensors.set(System.currentTimeMillis());
        }
    }

    private void updateStateWithSensorsDuringMotion() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateStateWithSensorsDuringMotion-carousel");){
            this.hyttc580.checkBooted();
            if (!this.clampsStateInitialized) {
                throw new FcsHardwareException(this.name + ": clamps state not initialized.  Please launch command initializeClampsState.");
            }
            this.tcpProxy.updatePDOData();
            this.updateState();
            this.publishData();
            this.carouselController.readHoldingBrakes();
            this.carouselController.publishDataDuringMotion();
        }
    }

    public void updateMinLockedThreshold() {
        if (System.currentTimeMillis() - this.lastUpdateLockSensorMinLocked.get() < 60000L) {
            return;
        }
        this.minLockedThreshold = (int)this.readLockSensorMinLocked();
        this.lastUpdateLockSensorMinLocked.set(System.currentTimeMillis());
    }

    public long readLockSensorMinLocked() {
        return this.hyttc580.readLockSensorMinLocked();
    }

    @Override
    public boolean isAtOnline() {
        return false;
    }

    public void updateSocketAtStandbyReadSensorsNoPublication() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateSocketAtStandbyReadSensorsNoPublication-carousel");){
            this.hyttc580.checkBooted();
            this.hyttc580.checkInitialized();
            this.tcpProxy.updatePDOData();
            this.updateSocketAtStandbyState();
        }
    }

    public void updateSocketAtStandbyState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateSocketAtStandbyState-carousel");){
            this.socketAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo1());
            if (this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5) {
                this.socketAtStandby = this.socketsMap.get("socket" + this.socketAtStandbyID);
                this.socketAtStandby.updateState();
                this.socketAtStandby.updateFilterID();
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update socket at standby state from hyttc580 data.", timeout=2000)
    public void updateSocketAtStandbyWithSensors() {
        this.updateSocketAtStandbyReadSensorsNoPublication();
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update state from hyttc580 data.", timeout=2000)
    public void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-carousel");){
            this.updateSocketAtStandbyState();
            this.position = this.carouselController.getPosition();
            int level = FcsUtils.getTimingLevel();
            this.subs.getScheduler().schedule(() -> {
                FcsUtils.startAsync(level);
                this.updateSocketNotAtStandby();
                FcsUtils.endAsync();
            }, 0L, TimeUnit.SECONDS);
        }
    }

    public void updateSocketNotAtStandby() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateSocketNotAtStandby");){
            short socketNotAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo2());
            if (socketNotAtStandbyID >= 1 && socketNotAtStandbyID <= 5) {
                CarouselSocket socketToUpdate = this.socketsMap.get("socket" + socketNotAtStandbyID);
                socketToUpdate.updateState();
            }
        }
    }

    public FcsEnumerations.FilterClampState getClampsStateAtStandby() {
        if (this.socketAtStandby == null) {
            return FcsEnumerations.FilterClampState.UNDEFINED;
        }
        return this.socketAtStandby.getClampsState();
    }

    public boolean isEmptyAtStandby() {
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isEmpty();
    }

    public boolean isUnclampedOnFilterAtStandby() {
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isUnclampedOnFilter();
    }

    public void updateTemperatures() {
        if (System.currentTimeMillis() - this.lastUpdateTemperatures.get() < 60000L) {
            return;
        }
        this.readBrakesAndMotorTemperatures();
        this.meanClampsTemperature = this.readMeanClampsTemperature();
        this.lastUpdateTemperatures.set(System.currentTimeMillis());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read on pt100 the temperatures", timeout=2000)
    public void readBrakesAndMotorTemperatures() {
        this.pt100.updateTemperatures();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read on hyttc580 the mean temperature for all the clamps", timeout=2000)
    public long readMeanClampsTemperature() {
        return this.hyttc580.readMeanClampsTemperature();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Activate POWER SAVE mode.", alias="activatePowerSave")
    public void powerSaveActivate() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("powerSaveActivate");){
            this.carouselController.activatePowerSave();
            FCSLOG.info((Object)(this.getName() + ": POWER SAVE activated."));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disactivate POWER SAVE mode.")
    public void powerSaveDisactivate() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("powerSaveDisactivate");){
            this.carouselController.disactivatePowerSave();
            FCSLOG.info((Object)(this.getName() + ": POWER SAVE disactivated."));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Disable interlock shutter. Do it only if you understand what you are doing.")
    public void interlockShutterDisable() {
        this.hyttc580.interlockShutterDisable();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable interlock shutter. Do it only if you understand what you are doing.")
    public void interlockShutterEnable() {
        this.hyttc580.interlockShutterEnable();
    }
}

