/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsMain;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochanger;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarousel;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class FcsMainTest
extends FCSTestTemplate {
    private static Subsystem fcsSubsystem = null;
    private static FcsMain main;
    private static SimuCarousel carousel;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static SimuTTC580 hyttc580;
    private static SimuCarouselController carouselController;
    private static SimuAutochangerPlutoGateway acPlutoGateway;
    private static CarouselSocket socket1;
    private static CarouselSocket socket2;
    private static CarouselSocket socket3;
    private static CarouselSocket socket4;
    private static CarouselSocket socket5;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static AutochangerOnlineClamp[] onelineClampsList;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("************************************************************************************");
        System.out.println("***                  TESTS OF THE WHOLE FCS SIMULATED                            ***");
        System.out.println("************************************************************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.fcs.run.mode", "simulation");
        fcsSubsystem = BootUtils.getSubsystemFromFile((String)"Fcs", (String)"serialNB:<alias>,controller:defaultInitial|<alias>", (String)"fcs-simu");
        fcsSubsystem.startAgent();
        ((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = fcsSubsystem.getComponentLookup();
        main = (FcsMain)lookup.getTopComponentNode().getComponent();
        carousel = (SimuCarousel)lookup.getComponentByPath("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByPath("carouselController");
        hyttc580 = (SimuTTC580)lookup.getComponentByPath("hyttc580");
        autochanger = (SimuAutochanger)lookup.getComponentByPath("autochanger");
        acPlutoGateway = (SimuAutochangerPlutoGateway)lookup.getComponentByPath("acSensorsGateway");
        trucks = (AutochangerTwoTrucks)lookup.getComponentByPath("autochangerTrucks");
        trucks.updatePosition();
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampYminus");
        for (AutochangerOnlineClamp clamp : onelineClampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus}) {
            clamp.setIncrementCurrentToClose(300);
            clamp.setIncrementCurrentToOpen(300);
            clamp.setIncrementCurrentToClamp(532);
            clamp.setInitialCurrentToClose(300);
            clamp.setFinalCurrentToClose(1800);
            clamp.setCurrentToOpen(-300);
            clamp.setCurrentToClamp(4992);
            clamp.setTargetPositionToClose(99000);
            clamp.setTargetPositionToOpen(10000);
        }
        socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
        socket2 = (CarouselSocket)lookup.getComponentByPath("socket2");
        socket3 = (CarouselSocket)lookup.getComponentByPath("socket3");
        socket4 = (CarouselSocket)lookup.getComponentByPath("socket4");
        socket5 = (CarouselSocket)lookup.getComponentByPath("socket5");
    }

    @AfterClass
    public static void after() throws Exception {
        fcsSubsystem.shutdownAgent();
        ((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
    }

    @Before
    public void setUp() throws DriverException {
        Utils.printJoliSetUp("FcsTest");
        socket1.setFilterID(3);
        socket2.setFilterID(15);
        socket3.setFilterID(34);
        socket4.setFilterID(29);
        socket5.setFilterID(60);
        carouselController.simulateSWITCH_ON_DISABLED();
    }

    public void testSetFilter() throws DriverException {
        System.out.println("*******************************************************");
        System.out.println("***                test setFilter                   ***");
        System.out.println("*******************************************************");
        System.out.println("*** ");
        Assert.assertEquals((String)"socketID which holds filter 15", (long)2L, (long)carousel.getFilterSocket(15).getId());
        Assert.assertEquals((String)"filter ID on AC", (long)0L, (long)autochanger.getFilterID());
        Assert.assertTrue((String)"autochanger empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger at HANDOFF", (boolean)autochanger.isAtHandoff());
        main.setFilter(15);
        Assert.assertEquals((String)"filter online ID", (long)15L, (long)autochanger.getFilterID());
        main.setFilter(3);
        Assert.assertEquals((String)"filter online ID", (long)3L, (long)autochanger.getFilterID());
        main.setFilter(34);
        Assert.assertEquals((String)"filter online ID", (long)34L, (long)autochanger.getFilterID());
        main.setFilter(60);
        Assert.assertEquals((String)"filter online ID", (long)60L, (long)autochanger.getFilterID());
        main.setFilter(29);
        Assert.assertEquals((String)"filter online ID", (long)29L, (long)autochanger.getFilterID());
    }

    public void testStoreFilterOnCarousel() {
        System.out.println("*******************************************************");
        System.out.println("*** test StoreFilterOnCarousel                      ***");
        System.out.println("*******************************************************");
        hyttc580.simulateSocketAtStandby((short)2);
        hyttc580.simulateSocketREADYTOCLAMP((short)2);
        hyttc580.simuSocketNoFilter(true, (short)2);
        carousel.releaseClamps();
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"socket ID at standby", (long)2L, (long)carousel.getSocketAtStandby().getId());
        Assert.assertTrue((String)"socket at standby is empty", (boolean)carousel.getSocketAtStandby().isEmpty());
        Assert.assertFalse((String)"clampXminus is Unlocked", (boolean)carousel.getSocketAtStandby().getClampXminus().isLocked());
        Assert.assertTrue((String)"clampXplus is Locked", (boolean)carousel.getSocketAtStandby().getClampXplus().isLocked());
        Assert.assertEquals((String)"socket at standby state", (Object)FcsEnumerations.FilterClampState.READYTOCLAMP, (Object)carousel.getSocketAtStandby().getClampsState());
        Assert.assertTrue((String)"socket at standby is READYTOCLAMP", (boolean)carousel.getSocketAtStandby().isReadyToClamp());
        acPlutoGateway.simulateFilterIDOnAutochanger(15);
        acPlutoGateway.simulateAutochangerLatchesAreLocked();
        acPlutoGateway.simulateAutochangerTrucksAreAtHandoff();
        main.storeFilterOnCarousel();
        Assert.assertTrue((String)"carousel is holding filter At STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertEquals((String)"filter ID on carousel", (long)15L, (long)carousel.getFilterIDatStandby());
        Assert.assertEquals((String)"filter ID on AC", (long)0L, (long)autochanger.getFilterID());
    }

    public void testGrabFilterAtStandby() {
        System.out.println("*******************************************************");
        System.out.println("*** test GrabFilterAtStandby                     ***");
        System.out.println("*******************************************************");
        hyttc580.simulateSocketAtStandby((short)1);
        hyttc580.simulateSocketClampedOnFilter(true, (short)1);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"filterID on carousel at standby", (long)3L, (long)carousel.getFilterIDatStandby());
        acPlutoGateway.simulateAutochangerIsEmpty();
        acPlutoGateway.simulateAutochangerTrucksAreAtHandoff();
        acPlutoGateway.simulateAutochangerLatchesAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)"filterID on AC", (long)0L, (long)autochanger.getFilterID());
        Assert.assertTrue((String)"autochanger empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger latches open", (boolean)autochanger.isNotHoldingFilter());
        Assert.assertTrue((String)"autochanger at handoff", (boolean)autochanger.isAtHandoff());
        autochanger.grabFilterAtStandby();
        Assert.assertTrue((String)"latches closed", (boolean)autochanger.getLatches().isClosed());
        Assert.assertTrue((String)"autochanger at standby", (boolean)autochanger.isAtStandby());
        Assert.assertTrue((String)"autochanger is holding a filter", (boolean)autochanger.isHoldingFilter());
        Assert.assertEquals((String)"filterID on carousel at standby", (long)3L, (long)carousel.getFilterIDatStandby());
        Assert.assertEquals((String)"filterID on AC", (long)3L, (long)autochanger.getFilterID());
    }
}

