package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * Represents a model for the CANopen device SYSTEC IO-X5 which is used in
 * autochanger to monitor 8 temperatures. 8 temperature sensors are connected on
 * the analog inputs of the systec device. An analog input on the device is also
 * named a channel.
 *
 * The device SYSTEC IO-X5 has been replaced by a SENECA_4RTD.
 *
 * @author virieux
 */
@Deprecated
public class CanOpenSystecIO extends CanOpenDevice implements MonitorDeviceInterface {

    public int defaultSensorType = 0x21;
    public int digitalDigit = 1;
    public int lowerLimitValue = -20;
    public int upperLimitValue = 50;
    /* by default the physical unit for sensors are °C so no need to change */

    /**
     * Initialize and configure the device in order to be able to read temperatures.
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
             description = "Initialize and configure the device in order to be able to read temperatures.")
    @Override
    public void initialize() {
        for (int i = 1; i < 9; i++) {
            setAISensorType(i, defaultSensorType);
            setDigitalDigit(i, digitalDigit);
            setLowerLimit(i, lowerLimitValue);
            setUpperLimit(i, upperLimitValue);
            enableChannel(i);
        }
        this.initialized = true;
        // publishData for the GUI
        this.publishData();
        FCSLOG.info(name + ": is INITIALIZED.");
    }

    /**
     * set gain value for a channel
     *
     * @param channelNO
     * @param gainValue
     */
    public void setGain(int channelNO, int gainValue) {

    }

    /**
     * Set sensor type for a given channel. A channel is an input on the device.
     *
     * Sensor type specifies the type of sensor which is connected to the device. in
     * decimal : 30 is a PT100 in decimal : 33 is a PT1000 (21 in hexa) default
     * value on the device : 30
     *
     * @param channelNO
     * @param sensorType
     */
    public void setAISensorType(int channelNO, int sensorType) {
        this.writeSDO(0x6110, channelNO, 0x2, sensorType);
    }

    /**
     * Set decimal digital digit for a given channel. This parameter specifies the
     * number of decimal digits following the decimal point for interpretation of
     * data type integer16. Example : a process value of 98.2°C will be coded as 982
     * in decimal if the parameter digitalDigit is set to 1, and to 98 if
     * decimalDigit is set to 0. 98.2 => 982 if digitalDigit = 1 98.2 => 98 if
     * digitalDigit = 0 Default value = 0
     *
     *
     * @param chanelNO
     * @param digitalDigit
     */
    public void setDigitalDigit(int chanelNO, int digitalDigit) {
        this.writeSDO(0x6132, chanelNO, 0x01, digitalDigit);
    }

    /**
     * Set the lower limit for triggering PDO transmission of an analog input
     * channel.
     *
     * @param chanelNO
     * @param lowerLimitValue
     */
    public void setLowerLimit(int chanelNO, int lowerLimitValue) {
        this.writeSDO(0x7134, chanelNO, 0x02, lowerLimitValue);
    }

    /**
     * Set the upper limit for triggering PDO transmission of an analog input
     * channel.
     *
     * @param chanelNO
     * @param upperLimitValue
     */
    public void setUpperLimit(int chanelNO, int upperLimitValue) {
        this.writeSDO(0x7135, chanelNO, 0x02, upperLimitValue);
    }

    /**
     * Set an operation mode for a given channel. operation can be : 0 - to disable
     * channel 1 - to enable channel Default value : 0H
     *
     * @param chanelNO
     * @param operationMode
     */
    public void setAIOperationMode(int chanelNO, int operationMode) {
        this.writeSDO(0x6112, chanelNO, 0x01, operationMode);
    }

    /**
     * enable channel which numero is given as argument
     *
     * @param channelNO
     */
    public void enableChannel(int channelNO) {
        setAIOperationMode(channelNO, 1);
    }

    /**
     * disable channel which numero is given as argument
     *
     * @param channelNO
     */
    public void disableChannel(int channelNO) {
        setAIOperationMode(channelNO, 0);
    }

    /**
     * read channel and return temperature read as a double
     *
     * @param channelNO
     * @return
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1, description = "read channel and return its value")
    @Override
    public double readChannel(int channelNO) {
        /* Object 0x7130 of device SystecIO is an INTEGER16 */
        return (short) readSDO(0x7130, channelNO);
    }

}
