
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.command.annotations.Command;

/**
 * This interface is to be implemented by every class which is a model for a
 * hardware that is moved by an EPOSController. The goal of this interface is to
 * factorise methods :
 * - to process emergency messages coming from the CANbus either when a
 * controller is in fault or when a command faultReset has been sent to the
 * controller.
 * - to monitor current
 *
 * @author virieux
 */
public interface MovedByEPOSController {


    /**
     *
     * @return my controller
     */
    EPOSController getController();

    /**
     * Return the name of the controller.
     *
     * @return
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1, description = "Returns controller name.")
    default String getControllerName() {
        return getController().getName();
    }

    /**
     * publishes data on the STATUS bus
     */
    void publishData();

}
