/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.StrainGauge;
import org.lsst.ccs.subsystems.fcs.drivers.MonitorDeviceInterface;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class AutochangerThreeOnlineClamps
implements ControlledBySensors,
AlertRaiser,
SignalHandler,
HasLifecycle {
    public static final Logger FCSLOG = FCSCst.FCSLOG;
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/onlineStrainGauge")
    private StrainGauge onlineStrainGauge;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/tempSensorsDevice1")
    private MonitorDeviceInterface tempSensorsDevice1;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    protected final AutochangerOnlineClamp onlineClampXminus;
    protected final AutochangerOnlineClamp onlineClampXplus;
    protected final AutochangerOnlineClamp onlineClampYminus;
    protected final AutochangerOnlineClamp[] clampsList;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    protected ScheduledFuture<?> currentRampHandle;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="autochanger")
    protected volatile int timeoutForLockingClamps = 15000;
    @ConfigurationParameter(description="timeout in milliseconds : if unlocking the clamps last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="autochanger")
    protected volatile int timeoutForUnlockingClamps = 20000;
    @ConfigurationParameter(description="maximum time in milliseconds to lock the 3 clamps", units="millisecond", category="autochanger")
    protected volatile int maxTimeToLockAllClamps = 3000;
    @ConfigurationParameter(description="maximum time in milliseconds to unlock the 3 clamps", units="millisecond", category="autochanger")
    protected volatile int maxTimeToUnlockAllClamps = 3000;
    @ConfigurationParameter(description="maximum time in milliseconds to open the 3 clamps", units="millisecond", category="autochanger")
    protected volatile int maxTimeToOpenClampsX = 2000;
    @ConfigurationParameter(description="maximum time in milliseconds to close the 3 clamps", units="millisecond", category="autochanger")
    protected volatile int maxTimeToCloseClampsX = 2000;
    @ConfigurationParameter(description="minimal period for current ramps. should be > 50", units="millisecond", range="50..1000", category="autochanger")
    protected volatile int minPeriod = 200;
    @ConfigurationParameter(description="if strain < maxLockedStrain, clamps are LOCKED", category="autochanger")
    private volatile short maxLockedStrain = (short)1484;
    @ConfigurationParameter(description="if strain < minLockedStrain, clamps may be in ERROR", category="autochanger")
    private volatile short minLockedStrain = (short)500;
    @ConfigurationParameter(description="if strain >= maxClosedStrain, clamps are OPENED", category="autochanger")
    private volatile short maxClosedStrain = (short)1572;
    @ConfigurationParameter(description="UNDEFINED", category="autochanger")
    private volatile double strainGain = 2.978;
    private short readStrain = 0;
    private short normalizedStrain = 0;
    private boolean lockStatusInitialized = false;

    public AutochangerThreeOnlineClamps(AutochangerOnlineClamp onlineClampXminus, AutochangerOnlineClamp onlineClampXplus, AutochangerOnlineClamp onlineClampYminus) {
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampYminus = onlineClampYminus;
        this.clampsList = new AutochangerOnlineClamp[]{onlineClampYminus, onlineClampXminus, onlineClampXplus};
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerThreeClamps.class, this.path);
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CAN_BUS_READING_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if lockStatus has been first initialized from strain.")
    public boolean isLockStatusInitialized() {
        return this.lockStatusInitialized;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if homing has been done for the 3 ONLINE clamp controllers.")
    public boolean isHomingDone() {
        return this.onlineClampXminus.isHomingDone() && this.onlineClampXplus.isHomingDone() && this.onlineClampYminus.isHomingDone();
    }

    @ConfigurationParameterChanger
    public void setMinPeriod(int minPeriod) {
        if (minPeriod < 50) {
            throw new IllegalArgumentException(minPeriod + " bad value for minPeriod. should be > 50");
        }
        this.minPeriod = minPeriod;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are LOCKED.")
    public boolean isLocked() {
        return this.onlineClampXminus.isLocked() && this.onlineClampXplus.isLocked() && this.onlineClampYminus.isLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are CLOSED.")
    public boolean isClosed() {
        return this.onlineClampXminus.isClosed() && this.onlineClampXplus.isClosed() && this.onlineClampYminus.isClosed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are OPENED.")
    public boolean isOpened() {
        return this.onlineClampXminus.isOpened() && this.onlineClampXplus.isOpened() && this.onlineClampYminus.isOpened();
    }

    private boolean isInTravel() {
        return this.onlineClampXminus.isInTravel() && this.onlineClampXplus.isInTravel() && this.onlineClampYminus.isInTravel();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if one of the clamp is in error.")
    public boolean isInError() {
        return this.onlineClampXminus.isInError() || this.onlineClampXplus.isInError() || this.onlineClampYminus.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready : controllers ready, controllers parameters checked and controllers configured.")
    public boolean isInitialized() {
        return this.onlineClampXminus.isInitialized() && this.onlineClampXplus.isInitialized() && this.onlineClampYminus.isInitialized();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="do homing of the 3 ONLINE clamps : open in CURRENT mode and homing of controller", timeout=6000)
    public void homing() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamps homing");){
            FcsUtils.AsyncTasks asyncRun = FcsUtils.asyncRun();
            for (AutochangerOnlineClamp clamp : this.clampsList) {
                asyncRun.asyncRun(() -> clamp.openInCurrentModeAndHoming());
            }
            asyncRun.await();
        }
    }

    public void testPeriodTask() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name + "-updateStateAndCheckSensors", this::updateStateAndCheckSensors).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofMillis(5000L)));
    }

    public void closeClamps() {
        block15: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("closeClamps");){
                if (!this.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet. Can't close.");
                }
                this.updateStateAndCheckSensors();
                if (this.isOpened()) {
                    this.autochanger.checkConditionsForActioningOnlineClamps();
                    this.onlineClampYminus.close();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.close(), () -> this.onlineClampXplus.close());
                    break block15;
                }
                if (this.isClosed()) {
                    FCSLOG.info((Object)(this.name + " clamps already CLOSED nothing to do"));
                    break block15;
                }
                throw new RejectedCommandException(this.name + " has to be unlocked before.");
            }
        }
    }

    public void openClamps() {
        block15: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openClamps");){
                if (!this.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet for the 3 clamps. Can't open.");
                }
                this.updateStateAndCheckSensors();
                if (this.isClosed()) {
                    this.onlineClampYminus.checkReadyForAction();
                    this.onlineClampYminus.open();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.open(), () -> this.onlineClampXplus.open());
                    break block15;
                }
                if (this.isOpened()) {
                    FCSLOG.info((Object)(this.name + " clamps already OPENED. Nothing to do."));
                    break block15;
                }
                throw new RejectedCommandException(this.name + " has to be closed before.");
            }
        }
    }

    public void lockClamps() {
        block15: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("lockClamps");){
                this.updateStateAndCheckSensors();
                if (this.isClosed()) {
                    this.onlineClampYminus.lock();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.lock(), () -> this.onlineClampXplus.lock());
                    if (this.onlineClampYminus.getController().isEnabled() || this.onlineClampXminus.getController().isEnabled() || this.onlineClampXplus.getController().isEnabled()) {
                        FCSLOG.info((Object)"online clamps controllers sleep try again");
                        FcsUtils.sleep(50, "lockClamps");
                        FCSLOG.info((Object)("online clamps controllers " + this.onlineClampYminus.getController().isEnabled() + " " + this.onlineClampXminus.getController().isEnabled() + " " + this.onlineClampXplus.getController().isEnabled()));
                    }
                    break block15;
                }
                if (this.isLocked()) {
                    FCSLOG.info((Object)(this.name + " is already LOCKED. Nothing to do."));
                    break block15;
                }
                throw new RejectedCommandException(this.name + " have to be CLOSED before to be locked.");
            }
        }
    }

    public void unlockClamps() {
        block14: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("unlockClamps");){
                this.updateStateAndCheckSensors();
                if (this.isLocked()) {
                    this.onlineClampYminus.unlock();
                    FcsUtils.parallelRun(() -> this.onlineClampXminus.unlock(), () -> this.onlineClampXplus.unlock());
                    FcsUtils.parallelRun(() -> this.onlineClampYminus.getController().goToSwitchOnDisabled(), () -> this.onlineClampXminus.getController().goToSwitchOnDisabled(), () -> this.onlineClampXplus.getController().goToSwitchOnDisabled());
                    break block14;
                }
                if (this.isClosed()) {
                    FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
                    break block14;
                }
                throw new RejectedCommandException(this.name + " have to be CLOSED before to be locked.");
            }
        }
    }

    public void lockFilterAtOnline() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("lockFilterAtOnline");){
            if (this.isLocked()) {
                FCSLOG.info((Object)(this.name + " onlineClamps LOCKED : nothing to do"));
            } else if (this.isClosed()) {
                this.lockClamps();
            } else if (this.isOpened()) {
                if (!this.isHomingDone()) {
                    this.homing();
                }
                this.closeClamps();
                this.lockClamps();
            }
        }
    }

    public void unlockAndOpen() {
        if (this.isLocked()) {
            this.unlockClamps();
        }
        if (this.isClosed()) {
            if (this.isHomingDone()) {
                this.openClamps();
            } else {
                this.homing();
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready.")
    public boolean myDevicesReady() {
        return this.onlineClampXminus.myDevicesReady() && this.onlineClampXplus.myDevicesReady() && this.onlineClampYminus.myDevicesReady();
    }

    private short computeNormalizedStrain() {
        double temp = 20.0;
        if (!this.tempSensorsDevice1.isBooted()) {
            this.tempSensorsDevice1.updateDeviceInfo();
        }
        if (this.tempSensorsDevice1.isBooted()) {
            temp = this.tempSensorsDevice1.readChannel(3) / 10.0;
        } else {
            this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, " can't read temperature because tempSensorsDevice1 is not booted, temperature is supposed to be 20\u00b0C", this.name);
        }
        if (!this.onlineStrainGauge.isBooted()) {
            this.onlineStrainGauge.updateDeviceInfo();
        }
        if (this.onlineStrainGauge.isBooted()) {
            this.readStrain = this.onlineStrainGauge.readStrain();
        } else {
            this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, " can't read strainGain because onlineStrainGauge is not booted", this.name);
        }
        this.normalizedStrain = (short)((double)this.readStrain - this.strainGain * (temp - 20.0));
        FCSLOG.info((Object)("temperature=" + temp + " / ONLINE read strain=" + this.readStrain + " / normalized strain=" + this.normalizedStrain));
        return this.normalizedStrain;
    }

    public StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps() {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setLockStatus(this.lockStatus);
        status.setOnlineClampStrain(this.normalizedStrain);
        status.setOnlineClampRawStrain(this.readStrain);
        status.setHomingDone(this.isHomingDone());
        return status;
    }

    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByThreeClamps()));
    }

    protected void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state from sensors values.")
    public void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-ac3clamps");){
            for (AutochangerOnlineClamp clamp : this.clampsList) {
                clamp.updateState();
            }
            this.normalizedStrain = this.computeNormalizedStrain();
            this.computeLockStatus();
            this.publishData();
        }
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isClosed() ? FcsEnumerations.LockStatus.CLOSED : (this.isLocked() ? FcsEnumerations.LockStatus.LOCKED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN))));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a lock status computed from the normalizedStrain value")
    public FcsEnumerations.LockStatus computeStrainGaugeLockStatus() {
        this.normalizedStrain = this.computeNormalizedStrain();
        FCSLOG.info((Object)(this.name + " ONLINE strain = " + this.normalizedStrain));
        if (this.normalizedStrain > this.maxClosedStrain) {
            return FcsEnumerations.LockStatus.OPENED;
        }
        if (this.normalizedStrain > this.maxLockedStrain) {
            return FcsEnumerations.LockStatus.CLOSED;
        }
        if (this.normalizedStrain > this.minLockedStrain) {
            return FcsEnumerations.LockStatus.LOCKED;
        }
        return FcsEnumerations.LockStatus.ERROR;
    }

    private void computeLockStatusFromStrain() {
        FcsEnumerations.LockStatus strainLockStatus = this.computeStrainGaugeLockStatus();
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : (this.isClosed() ? (strainLockStatus == FcsEnumerations.LockStatus.LOCKED ? FcsEnumerations.LockStatus.LOCKED : (strainLockStatus == FcsEnumerations.LockStatus.CLOSED ? FcsEnumerations.LockStatus.CLOSED : (strainLockStatus == FcsEnumerations.LockStatus.OPENED || strainLockStatus == FcsEnumerations.LockStatus.ERROR ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.ERROR))) : FcsEnumerations.LockStatus.UNKNOWN)));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize AC online clamps hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.postStart();
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.postStart();
        }
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.onlineStrainGauge.isBooted()) {
            this.onlineStrainGauge.initializeAndCheckHardware();
        } else {
            this.onlineStrainGauge.raiseAlarmIfMissing();
        }
        if (this.tempSensorsDevice1.isBooted()) {
            try {
                this.computeLockStatusFromStrain();
                this.lockStatusInitialized = true;
                this.publishData();
            }
            catch (SDORequestException ex) {
                this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_READING_ERROR, "could not computeLockStatusFromStrain ", this.name, ex);
            }
        } else {
            this.tempSensorsDevice1.raiseWarningIfMissing();
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }
}

