/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerLatch
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final EPOSController latchController;
    private final ComplementarySensors filterEngagedSensors;
    private final ComplementarySensors closeSensors;
    private final ComplementarySensors openSensors;
    @ConfigurationParameter(description="current to be sent to the controller to open the latch.", units="mA", category="autochanger")
    private volatile int currentToOpen = 300;
    @ConfigurationParameter(description="timeout for opening or closing latch", units="millisecond", category="autochanger")
    private volatile long timeoutForLatchMotion = 3000L;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;

    public AutochangerLatch(EPOSController latchController, ComplementarySensors closeSensors, ComplementarySensors openSensors, ComplementarySensors filterEngagedSensors) {
        this.latchController = latchController;
        this.closeSensors = closeSensors;
        this.openSensors = openSensors;
        this.filterEngagedSensors = filterEngagedSensors;
    }

    @Override
    public EPOSController getController() {
        return this.latchController;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latch is initialized.")
    public boolean isInitialized() {
        return this.latchController.isInitialized();
    }

    public int getCurrentToClose() {
        return -this.currentToOpen;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LOCKED. Doesn't read again sensors.", alias="isClosed")
    public boolean isClosed() {
        return this.closeSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if UNLOCKED. Doesn't read again sensors.", alias="isOpen")
    public boolean isOpened() {
        return this.openSensors.isOn();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if in ERROR, this means that openSensor and closeSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger is empty. Doesn't read again sensors.")
    public boolean isEmpty() {
        return !this.filterEngagedSensors.isOn();
    }

    public boolean isFilterEngagedInError() {
        return this.filterEngagedSensors.isInError();
    }

    public void init() {
        if (this.latchController == null) {
            FCSLOG.error((Object)(this.name + "==>>> latchController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.name + "==>>> null latchController - fix groovy description file.");
        }
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.latchController.getName()), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.SDO_ERROR.getAlert(this.latchController.getName()), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerLatch.class, this.path);
        this.registerAction(FcsEnumerations.MobileItemAction.OPEN);
        this.registerAction(FcsEnumerations.MobileItemAction.CLOSE);
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.latchController.isBooted()) {
            this.initializeController();
            this.latchController.updateEposState();
            this.latchController.publishData();
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeController() {
        try {
            this.latchController.initializeAndCheckHardware();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " could not initialize controller", this.latchController.getName(), (Exception)((Object)ex));
        }
        try {
            this.latchController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        }
        catch (FcsHardwareException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " could not change mode of controller", this.latchController.getName(), (Exception)((Object)ex));
        }
    }

    protected void updateState() {
        boolean inError;
        boolean closed = this.closeSensors.isOn();
        boolean opened = this.openSensors.isOn();
        boolean someSensorsInError = this.filterEngagedSensors.isInError() || this.closeSensors.isInError() || this.openSensors.isInError();
        boolean bl = inError = closed && opened || someSensorsInError;
        this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (closed ? FcsEnumerations.LockStatus.CLOSED : (opened ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update latch current in reading controller.")
    public void updateCurrent() {
        try {
            this.latchController.readCurrent();
            this.publishData();
        }
        catch (Exception ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, " could not updateCurrent", this.latchController.getName(), ex);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger CANopen hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.latchController.isInitialized();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latch.")
    public void close() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("ACLatch-close");){
            this.updateStateAndCheckSensors();
            if (this.isClosed()) {
                FCSLOG.info((Object)(this.name + " is already CLOSED. No action."));
                return;
            }
            this.autochanger.checkConditionsForClosingLatches();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForLatchMotion);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Close latch even if latch sensors are in error.")
    public void recoveryClose() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("ACLatch-recoveryClose");){
            this.updateStateAndCheckSensors();
            if (this.isClosed()) {
                FCSLOG.info((Object)(this.name + " is already CLOSED. No action."));
                return;
            }
            this.autochanger.checkConditionsForClosingLatches(true);
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForLatchMotion);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open latch.")
    public void open() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("ACLatch-open");){
            this.updateStateAndCheckSensors();
            if (this.isOpened()) {
                FCSLOG.info((Object)(this.name + " is already OPENED. No action."));
                return;
            }
            this.autochanger.checkConditionsForOpeningLatches();
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForLatchMotion);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Open latch even if latch sensors are in error.")
    public void recoveryOpen() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("ACLatch-recoveryOpen");){
            this.updateStateAndCheckSensors();
            if (this.isOpened()) {
                FCSLOG.info((Object)(this.name + " is already OPENED. No action."));
                return;
            }
            this.autochanger.checkConditionsForOpeningLatches(true);
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForLatchMotion);
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
            }
            case CLOSE: {
                return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
            }
        }
        assert (false) : action;
        return false;
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.autochanger.checkLatchMotionAllowed();
        switch (action) {
            case OPEN: {
                this.latchController.enableAndWriteCurrent((short)this.getCurrentToOpen());
                break;
            }
            case CLOSE: {
                this.latchController.enableAndWriteCurrent((short)this.getCurrentToClose());
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " STOPPING action " + action.toString() + " within delay " + delay));
        this.latchController.stopAction();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " ENDING action " + action.toString()));
        this.latchController.stopAction();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.abortAction(action, delay);
    }

    public StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch() {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setLockSensorValue(this.closeSensors.isOn());
        status.setUnlockSensorValue(this.openSensors.isOn());
        status.setFilterPresenceSensorValue(this.filterEngagedSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorsInError(this.closeSensors.isInError());
        status.setUnlockSensorsInError(this.openSensors.isInError());
        status.setFilterEngagedSensorsInError(this.filterEngagedSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        return status;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish Data on the Status Bus.")
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.createStatusDataPublishedByLatch();
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)status));
    }
}

