/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarousel;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;

public class SimuCarouselControllerTest
extends FCSTestTemplate {
    private static Subsystem carouselSubsystem;
    private static AgentStateService agentStateService;
    private static SimuCarousel carousel;
    private static SimuCarouselController carouselController;
    private static CarouselSocket socket1;
    private static CarouselSocket socket2;
    private static CarouselSocket socket3;
    private static CarouselSocket socket4;
    private static CarouselSocket socket5;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF SimuCarouselController        ");
        System.out.println("***************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.carousel.standalone", "true");
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"Carousel", (String)"serialNB:<alias>,carousel:defaultInitial|<alias>,nodeID:defaultInitial|<alias>", (String)"carousel-simu");
        carouselSubsystem.startAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = carouselSubsystem.getComponentLookup();
        carousel = (SimuCarousel)lookup.getComponentByPath("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByPath("carouselController");
        socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
        socket2 = (CarouselSocket)lookup.getComponentByPath("socket2");
        socket3 = (CarouselSocket)lookup.getComponentByPath("socket3");
        socket4 = (CarouselSocket)lookup.getComponentByPath("socket4");
        socket5 = (CarouselSocket)lookup.getComponentByPath("socket5");
        agentStateService = (AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class);
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("****************************************************");
        System.out.println("*** shutdown of carousel subsystem               ***");
        System.out.println("****************************************************");
        if (carouselSubsystem != null) {
            carouselSubsystem.shutdownAgent();
            ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        }
        System.getProperties().remove("org.lsst.ccs.fcs.instance.carousel.standalone");
    }

    @Before
    public void setUp() throws DriverException {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testInitializeAndCheckHardware() {
        System.out.println("initializeAndCheckHardware");
        carouselController.initializeAndCheckHardware();
        Assert.assertTrue((String)"controller is initialized", (boolean)carouselController.isInitialized());
    }

    @Test
    public void testGetMode() {
        System.out.println("getMode");
        carouselController.changeMode(EPOSEnumerations.EposMode.HOMING);
        Assert.assertEquals((String)"mode is HOMING", (Object)EPOSEnumerations.EposMode.HOMING, (Object)carouselController.getMode());
    }

    @Test
    public void testReadMode() {
        System.out.println("readMode");
        carouselController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        Assert.assertEquals((String)"mode is CURRENT", (Object)EPOSEnumerations.EposMode.CURRENT, (Object)carouselController.readMode());
    }

    @Test
    public void testChangeMode_EPOSEnumerationsEposMode() {
        System.out.println("changeMode");
        carouselController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        Assert.assertEquals((String)"mode is CURRENT", (Object)EPOSEnumerations.EposMode.CURRENT, (Object)carouselController.getMode());
    }

    @Test
    public void testIsInMode() {
        System.out.println("Test of method isInMode of class CanOpenEPOS");
        EPOSEnumerations.EposMode aMode = EPOSEnumerations.EposMode.PROFILE_POSITION;
        carouselController.changeMode(aMode);
        Assert.assertTrue((String)("controller should be in mode " + aMode), (boolean)carouselController.isInMode(aMode));
    }

    @Test
    public void testDefineAbsolutePosition() {
        System.out.println("defineAbsolutePosition");
        int position = 35;
        carouselController.defineAbsolutePosition(position);
        Assert.assertEquals((String)("position controller is " + position), (long)position, (long)carouselController.getPosition());
    }

    @Test
    public void testDisableOperation() {
        System.out.println("disableOperation");
        carouselController.disableOperation();
        Assert.assertEquals((String)"controller state", (Object)EPOSEnumerations.EposState.SWITCHED_ON, (Object)carouselController.getEposState());
    }

    @Test
    public void testDisableVoltage() {
        System.out.println("disableVoltage");
        carouselController.disableVoltage();
        Assert.assertEquals((String)"controller state", (Object)EPOSEnumerations.EposState.SWITCH_ON_DISABLED, (Object)carouselController.getEposState());
    }

    @Test
    public void testShutdownController() {
        System.out.println("shutdownController");
        carouselController.shutdownController();
        Assert.assertEquals((String)"controller state", (Object)EPOSEnumerations.EposState.READY_TO_SWITCH_ON, (Object)carouselController.getEposState());
    }

    @Test
    public void testSwitchOnEnableOperation() {
        System.out.println("switchOnEnableOperation");
        carouselController.switchOnEnableOperation();
        Assert.assertEquals((String)"controller state", (Object)EPOSEnumerations.EposState.OPERATION_ENABLE, (Object)carouselController.getEposState());
    }

    @Test
    public void testEnable() {
        System.out.println("enable");
        carouselController.enable();
        Assert.assertTrue((String)"controller is enabled", (boolean)carouselController.isEnabled());
    }

    @Test
    public void testConvertEPOSValue() {
        System.out.println("test convertEPOSValue  of class CanOpenEPOS");
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.MaxFollowingError;
        long value = Long.MAX_VALUE;
        long paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        value = (long)Math.pow(2.0, 31.0);
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        param = EPOSEnumerations.Parameter.MaxPositionLimit;
        value = (long)Math.pow(2.0, 31.0) - 1L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        value = (long)Math.pow(2.0, 31.0);
        param = EPOSEnumerations.Parameter.MaxPositionLimit;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)(-value), (long)paramValue);
        param = EPOSEnumerations.Parameter.CurrentThresholdHomingMode;
        value = 500L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)500L, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        value = 65534L;
        Assert.assertEquals((String)"paramValue", (long)-2L, (long)((short)value));
        param = EPOSEnumerations.Parameter.PolePairNumber;
        value = 255L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        param = EPOSEnumerations.Parameter.HomingMethod;
        value = 255L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)-1L, (long)paramValue);
        value = 35L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)35L, (long)paramValue);
    }

    @Test
    public void testWriteCurrent() {
        System.out.println("writeCurrent");
        int aValue = 2314;
        carouselController.writeCurrent(aValue);
        Assert.assertEquals((String)("actualCurrent is " + aValue), (long)aValue, (long)SimuCarouselControllerTest.carouselController.actualCurrent);
    }

    @Test
    public void testReadPosition() {
        System.out.println("readPosition");
        int position = 378;
        carouselController.writeTargetPosition(position);
        Assert.assertEquals((String)("controller position is " + position), (long)position, (long)carouselController.readPosition());
    }

    @Test
    public void testReadCurrent() {
        System.out.println("readCurrent");
        int current = 6547;
        carouselController.writeCurrent(current);
        Assert.assertEquals((String)("controller current is " + current), (long)current, (long)carouselController.readCurrent());
    }

    @Test
    public void testWriteTargetPosition() {
        System.out.println("###############################################################");
        System.out.println("test of testWriteTargetPosition of class SimuCarouselController");
        System.out.println("###############################################################");
        int finalPosition = socket2.getStandbyPosition();
        int initialPosition = carousel.getPosition();
        System.out.println("test with finalPosition=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket2 is at standby", (boolean)socket2.isAtStandby());
        Assert.assertFalse((String)"socket1 is not at standby", (boolean)socket1.isAtStandby());
        Assert.assertEquals((String)"carouselController.readPosition", (long)finalPosition, (long)carouselController.readPosition());
        finalPosition = socket4.getStandbyPosition();
        initialPosition = carousel.getPosition();
        System.out.println("test with finalPosition=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket4 is at standby", (boolean)socket4.isAtStandby());
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)socket2.isAtStandby());
        finalPosition = socket5.getStandbyPosition();
        initialPosition = carousel.getPosition();
        System.out.println("test with pos=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket5 is at standby", (boolean)socket5.isAtStandby());
        Assert.assertFalse((String)"socket4 is not at standby", (boolean)socket4.isAtStandby());
        finalPosition = socket3.getStandbyPosition();
        initialPosition = carousel.getPosition();
        System.out.println("test with pos=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket3 is at standby", (boolean)socket3.isAtStandby());
        Assert.assertFalse((String)"socket5 is not at standby", (boolean)socket5.isAtStandby());
        finalPosition = socket1.getStandbyPosition();
        initialPosition = carousel.getPosition();
        System.out.println("test with pos=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket1 is at standby", (boolean)socket1.isAtStandby());
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)socket3.isAtStandby());
    }

    @Test
    public void testUpdateFakePDOData() {
        System.out.println("updateFakePDOData of class SimuCarouselController");
        long value = 0L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = 1L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = 65535L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = -2234066821449711617L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = -2305671193734396952L;
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
    }

    @Test
    public void testSimulatePosition() {
        System.out.println("simulatePosition of class SimuCarouselController");
        int pos = 1;
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        Assert.assertEquals((String)"carouselController position", (long)pos, (long)carouselController.readPosition());
        pos = 0;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = 1;
        System.out.println("pos = " + pos);
        long pdo = (long)pos << 32;
        long mask = 0xFFFFFFFFL;
        long newpdo = pdo | carouselController.getPdo1() & mask;
        carouselController.simulatePosition(pos);
        Assert.assertEquals((String)"pdo1", (long)newpdo, (long)carouselController.getPdo1());
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = 3000;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = -204200;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        carousel.updateState();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1075906;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1948470;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -2821074;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -3694258;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
    }

    @Test
    public void testSimulateStatusWord() {
        System.out.println("simulateStatusWord of class SimuCarouselController");
        int sw = 0;
        System.out.println("statusWord = " + sw);
        carouselController.simulateStatusWord(sw);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carouselController status word", (long)sw, (long)carouselController.getStatusWord());
        sw = 1;
        carouselController.simulateStatusWord(sw);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carouselController status word", (long)sw, (long)carouselController.getStatusWord());
        sw = 39;
        carouselController.simulateStatusWord(sw);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carouselController status word", (long)sw, (long)carouselController.getStatusWord());
    }

    @Test
    public void testSimulateSWITCH_ON_DISABLED() {
        System.out.println("simulateSimulateSWITCH_ON_DISABLED of class SimuCarouselController");
        carouselController.simulateSWITCH_ON_DISABLED();
        Assert.assertEquals((String)"carouselController state", (Object)EPOSEnumerations.EposState.SWITCH_ON_DISABLED, (Object)carouselController.getEposState());
    }
}

