/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;

public class SimuAutochangerLinearRailControllerTest
extends FCSTestTemplate {
    private static Subsystem subs;
    private static SimuAutochangerLinearRailController masterController;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***********************************************");
        System.out.println("  TESTS OF SimuAutochangerLinearRailController");
        System.out.println("***********************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.autochanger.standalone", "true");
        subs = BootUtils.getSubsystemFromFile((String)"Autochanger", (String)"serialNB:<alias>,nodeID:<alias>,controller:defaultInitial|<alias>", (String)"autochanger-simu");
        subs.startAgent();
        ((AgentStateService)subs.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = subs.getComponentLookup();
        masterController = (SimuAutochangerLinearRailController)lookup.getComponentByPath("acTruckXminusController");
    }

    @AfterClass
    public static void after() throws Exception {
        System.getProperties().remove("org.lsst.ccs.fcs.instance.autochanger.standalone");
        if (subs != null) {
            subs.shutdownAgent();
        }
        System.out.println("********* end of SimuAutochangerLinearRailController tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSetSsiPosition() {
        System.out.println("setSsiPosition");
        int ssiPosition = 6532;
        masterController.setSsiPosition(ssiPosition);
        Assert.assertEquals((String)("masterController.readSSIPosition() should return " + ssiPosition), (long)ssiPosition, (long)masterController.readSSIPosition());
    }

    @Test
    public void testWriteTargetPosition() {
        System.out.println("writeTargetPosition");
        int positionToReached = 45000;
        masterController.writeTargetPosition(positionToReached);
        Assert.assertEquals((String)"masterController.readPosition()", (long)masterController.readPosition(), (long)positionToReached);
    }

    @Test
    public void testHoming() {
        System.out.println("homing");
        masterController.homing();
        Assert.assertTrue((String)"homing is done", (boolean)masterController.isHomingDone());
    }

    @Test
    public void testActivateBrakeAndDisable() {
        System.out.println("activateBrakeAndDisable");
        masterController.activateBrakeAndDisable();
        Assert.assertTrue((String)"masterController brake should be activated", (boolean)masterController.isBrakeActivated());
        Assert.assertFalse((String)"masterController should be disabled", (boolean)masterController.isEnabled());
    }

    @Test
    public void testEnableAndReleaseBrake() {
        System.out.println("enableAndReleaseBrake");
        masterController.enableAndReleaseBrake();
        Assert.assertFalse((String)"masterController brake is no more activated", (boolean)masterController.isBrakeActivated());
        Assert.assertTrue((String)"masterController is enabled", (boolean)masterController.isEnabled());
    }

    @Test
    public void testDoReleaseBrake() {
        System.out.println("doReleaseBrake");
        masterController.doReleaseBrake();
        Assert.assertFalse((String)"masterController brake should be released", (boolean)masterController.isBrakeActivated());
    }

    @Test
    public void testDisableOperation() {
        masterController.disableOperation();
        Assert.assertFalse((String)"controller is not enabled", (boolean)masterController.isEnabled());
    }
}

