
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;

/**
 * Main Module for the subsystem to test the carousel hardware at LPNHE.
 *
 * @author virieux
 */
public class CarouselTestbenchMain {

    private final BridgeToHardware bridge;

    /**
     * A constructor to build this Main Module with a bridge.
     *
     * @param bridge
     */
    public CarouselTestbenchMain(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    /**
     * This method returns a String with the list of hardware that this bridge
     * manages.
     *
     * @return
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1, description = "Return the list of CANopen hardware that this subsystem manages.")
    public String printHardwareList() {
        return this.bridge.printHardwareList();
    }

}
