/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class LoaderCarrier
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    public static final int TIMEOUT_FOR_MOVING_CARRIER = 120000;
    public static final String cmdDesc = " Check and change ProfileVelocity, ProfileAcceleration and ProfileDeceleration if needed. low velocity when filter is in loader, high velocity otherwise, low acceleration when filter is in loader and between handoff and engaged, high acceleration otherwise, low deceleration when filter is in loader and between handoff and engaged, high deceleration otherwise.";
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderHandoffSensors")
    private BinarySensor handoffSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderStorageSensors")
    private BinarySensor storageSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderEngagedSensors")
    private BinarySensor engagedSensors;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private int position = 0;
    private int absoluteTargetPosition = 0;
    private int carrierMotionTimeout;
    @ConfigurationParameter(description="delta position : used to know if carrier position is in a range of 2*deltaPosition around a given position", units="micron", category="loader")
    private volatile int deltaPosition = 50;
    @ConfigurationParameter(description="Loader Handoff position", units="micron", category="loader")
    private volatile int handoffPosition = 1037500;
    @ConfigurationParameter(description="Loader Engaged position", units="micron", category="loader")
    private volatile int engagedPosition = 987500;
    @ConfigurationParameter(description="Loader Storage position", units="micron", category="loader")
    private volatile int storagePosition = 0;
    @ConfigurationParameter(description="For the Loader GUI : Maximum current to be sent to the Loader Carrier controller.", units="mA", category="loader")
    private volatile int maxCurrent = 1000;
    @ConfigurationParameter(description="For the Loader GUI : Loader Carrier Maximum speed. [rpm]", units="unitless", category="loader")
    private volatile int maxSpeed = 227;
    @ConfigurationParameter(description="timeout in milliseconds to go from storage to handoff on loader", units="millisecond", category="loader")
    private volatile long timeoutForGoingToHandOff = 120000L;
    @ConfigurationParameter(description="timeout in milliseconds to go from storage to engaged on loader", units="millisecond", category="loader")
    private volatile long timeoutForGoingToEngaged = 120000L;
    @ConfigurationParameter(description="timeout in milliseconds to go from handoff to storage on loader", units="millisecond", category="loader")
    private volatile long timeoutForGoingToStorage = 120000L;
    @ConfigurationParameter(description="low speed to go with a filter from ENGAGED to HANDOFF position [rpm]", units="unitless", category="loader")
    private volatile int lowSpeed = 50;
    @ConfigurationParameter(description="high speed to move carrier when it's empty or with a filter from ENGAGED to STORAGE position [rpm]", units="unitless", category="loader")
    private volatile int highSpeed = 187;
    @ConfigurationParameter(description="low acceleration to move carrier with a filter from ENGAGED to STORAGE position", category="loader")
    private volatile int lowAcceleration = 30;
    @ConfigurationParameter(description="high acceleration to move carrier empty from ENGAGED to STORAGE position", category="loader")
    private volatile int highAcceleration = 100;
    @ConfigurationParameter(description="low deceleration to move carrier with a filter from ENGAGED to STORAGE position", category="loader")
    private volatile int lowDeceleration = 30;
    @ConfigurationParameter(description="high deceleration to move carrier with a filter from ENGAGED to STORAGE position", category="loader")
    private volatile int highDeceleration = 50;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/carrierController")
    private EPOSController carrierController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="loaderTcpProxy")
    private BridgeToHardware loaderTcpProxy;
    private volatile boolean initialized = false;
    private volatile boolean homingDone = true;
    private int speed;
    private int current;
    private long profileVelocity;
    private long profileAcceleration;
    private long profileDeceleration;

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderCarrier.class, this.path);
        this.registerAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_HANDOFF);
        this.registerAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ENGAGED);
        this.registerAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_STORAGE);
        this.registerAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION);
    }

    public void init() {
        super.init();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.SDO_ERROR.getAlert(this.name), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns carrier position.")
    public int getPosition() {
        return this.position;
    }

    protected int getCurrent() {
        return this.current;
    }

    @Override
    public EPOSController getController() {
        return this.carrierController;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carrier is initialized and ready to receive commands.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max speed in rpm/mn (format decimal).")
    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max current in mA (format decimal).")
    public int getMaxCurrent() {
        return this.maxCurrent;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the handoff position in microns (format decimal).")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    public int getEngagedPosition() {
        return this.engagedPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the storage position in microns (format decimal).")
    public int getStoragePosition() {
        return this.storagePosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Handoff in millis (format decimal).")
    public long getTimeoutForGoingToHandOff() {
        return this.timeoutForGoingToHandOff;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Storage in millis (format decimal).")
    public long getTimeoutForGoingToStorage() {
        return this.timeoutForGoingToStorage;
    }

    @Override
    public boolean isInError() {
        return false;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Homing of carrier controller. Should be done only if necessary.")
    public void homing() {
        this.carrierController.definePositionFromNegativeLimitSwitch();
        this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        FCSLOG.info((Object)(this.name + " homing done."));
    }

    public void initializeController() {
        try {
            this.carrierController.initializeAndCheckHardware();
            this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.initialized = true;
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize controller", this.name, ex);
        }
    }

    public void postStart() {
        FCSLOG.info((Object)(this.name + " postStart"));
        this.carrierMotionTimeout = (int)this.timeoutForGoingToStorage;
        if (this.carrierController.isBooted()) {
            this.initializeController();
            this.profileVelocity = this.readProfileVelocity();
            this.profileAcceleration = this.carrierController.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration);
            this.profileDeceleration = this.carrierController.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration);
            this.carrierMotionTimeout = this.profileVelocity == (long)this.lowSpeed ? 4 * (int)this.timeoutForGoingToStorage : (int)this.timeoutForGoingToStorage;
        }
    }

    @Override
    public boolean myDevicesReady() {
        return this.loaderTcpProxy.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STORAGE position. This command doesn't read again the sensors.")
    public boolean isAtStorage() {
        return this.storageSensors.isOn() && this.isCarrierAlmostAtPosition(this.storagePosition);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at HANDOFF position. This command doesn't read again the sensors.At HANDOFF engagedSensors and handoffSensors are ON.")
    public boolean isAtHandoff() {
        return this.handoffSensors.isOn() && this.isCarrierAlmostAtPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ENGAGED position. This command doesn't read again the sensors.")
    public boolean isAtEngaged() {
        return this.engagedSensors.isOn() && this.isCarrierAlmostAtPosition(this.engagedPosition);
    }

    public boolean isStrictlyBetweenStorageAndEngaged() {
        this.updatePosition();
        return this.position < this.engagedPosition - this.deltaPosition;
    }

    public boolean isLooslyBetweenEngagedAndHandoff() {
        this.updatePosition();
        return this.position >= this.engagedPosition - this.deltaPosition;
    }

    public boolean isStrictlyBetweenEngagedAndHandoff() {
        this.updatePosition();
        return this.position > this.engagedPosition + this.deltaPosition;
    }

    public boolean isLooslyBetweenStorageAndEngaged() {
        this.updatePosition();
        return this.position <= this.engagedPosition + this.deltaPosition;
    }

    @Command(type=Command.CommandType.ACTION, level=1, alias="goToHandoff", description="Move the carrier to Handoff position. This command ", timeout=120000)
    public void goToHandOff() {
        if (this.isAtHandoff()) {
            FCSLOG.info((Object)(this.name + " is already at Handoff position. Nothing to do."));
        } else {
            this.loader.checkConditionsForCarrierMotion(this.handoffPosition);
            this.absoluteTargetPosition = this.handoffPosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_HANDOFF, this.timeoutForGoingToHandOff);
            this.afterMotion();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to Engaged position. Check and change ProfileVelocity, ProfileAcceleration and ProfileDeceleration if needed. low velocity when filter is in loader, high velocity otherwise, low acceleration when filter is in loader and between handoff and engaged, high acceleration otherwise, low deceleration when filter is in loader and between handoff and engaged, high deceleration otherwise.", timeout=120000)
    public void goToEngaged() {
        if (this.isAtEngaged()) {
            FCSLOG.info((Object)(this.name + " is already at Engaged position. Nothing to do."));
        } else {
            this.loader.checkConditionsForCarrierMotion(this.engagedPosition);
            this.absoluteTargetPosition = this.engagedPosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ENGAGED, this.carrierMotionTimeout);
            this.afterMotion();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to STORAGE position. Check and change ProfileVelocity, ProfileAcceleration and ProfileDeceleration if needed. low velocity when filter is in loader, high velocity otherwise, low acceleration when filter is in loader and between handoff and engaged, high acceleration otherwise, low deceleration when filter is in loader and between handoff and engaged, high deceleration otherwise.", timeout=120000)
    public void goToStorage() {
        if (this.isAtStorage()) {
            FCSLOG.info((Object)(this.name + " is already at Storage position. Nothing to do."));
        } else {
            this.loader.checkConditionsForCarrierMotion(this.storagePosition);
            this.absoluteTargetPosition = this.storagePosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_STORAGE, this.carrierMotionTimeout);
            this.afterMotion();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to absolute position given as argument (in decimal format). Check and change ProfileVelocity, ProfileAcceleration and ProfileDeceleration if needed. low velocity when filter is in loader, high velocity otherwise, low acceleration when filter is in loader and between handoff and engaged, high acceleration otherwise, low deceleration when filter is in loader and between handoff and engaged, high deceleration otherwise.", timeout=120000)
    public void goToAbsolutePosition(int absolutePosition) {
        this.updatePosition();
        if (this.position == absolutePosition) {
            FCSLOG.info((Object)(this.name + " is already at position " + absolutePosition));
        } else {
            this.loader.checkConditionsForCarrierMotion(absolutePosition);
            this.absoluteTargetPosition = absolutePosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, this.timeoutForGoingToStorage);
            this.afterMotion();
        }
    }

    private void checkAndChangeProfileVelocity() {
        boolean betweenEngagedAndHandoff = this.position >= this.engagedPosition && this.absoluteTargetPosition >= this.engagedPosition;
        long velocity = this.readProfileVelocity();
        if (this.loader.isClosedOnFilter() && betweenEngagedAndHandoff && velocity > (long)this.lowSpeed) {
            FCSLOG.info((Object)(this.name + " velocity too high with a filter in loader : slowing ProfileVelocity"));
            this.slowProfileVelocity();
        }
    }

    private void checkAndChangeProfileAcceleration() {
        boolean betweenEngagedAndHandoff;
        long acceleration = this.carrierController.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration);
        boolean bl = betweenEngagedAndHandoff = this.position >= this.engagedPosition && this.absoluteTargetPosition >= this.engagedPosition;
        if (this.loader.isClosedOnFilter() && betweenEngagedAndHandoff && acceleration > (long)this.lowAcceleration) {
            FCSLOG.info((Object)(this.name + " ProfileAcceleration too high with a filter in the loader : slowing ProfileAcceleration"));
            this.slowProfileAcceleration();
        }
    }

    private void checkAndChangeProfileDeceleration() {
        boolean fromStorageToHandoff;
        boolean betweenEngagedAndHandoff;
        long deceleration = this.carrierController.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration);
        boolean bl = betweenEngagedAndHandoff = this.position >= this.engagedPosition && this.absoluteTargetPosition >= this.engagedPosition;
        if (this.loader.isClosedOnFilter() && betweenEngagedAndHandoff && deceleration > (long)this.lowDeceleration) {
            FCSLOG.info((Object)(this.name + " ProfileDeceleration too high with a filter in the loader. I slow it."));
            this.slowProfileDeceleration();
        }
        boolean bl2 = fromStorageToHandoff = this.absoluteTargetPosition > this.position;
        if (this.loader.isEmpty() && fromStorageToHandoff && deceleration > (long)this.lowDeceleration) {
            FCSLOG.info((Object)(this.name + " ProfileDeceleration too high to go to handoff without a filter."));
            this.slowProfileDeceleration();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="For tests only. Slow down profile velocity, acceleration and deceleration in loader controller.")
    public void setSlowMode() {
        this.slowProfileVelocity();
        this.slowProfileAcceleration();
        this.slowProfileDeceleration();
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="For tests only. Raise profile velocity, acceleration and deceleration in loader controller.")
    public void setFastMode() {
        this.raiseProfileVelocity();
        this.raiseProfileAcceleration();
        this.raiseProfileDeceleration();
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileVelocity parameter to lowSpeed")
    public void slowProfileVelocity() {
        this.carrierController.changeProfileVelocity(this.lowSpeed);
        this.profileVelocity = this.lowSpeed;
        this.carrierMotionTimeout = (int)(4L * this.timeoutForGoingToStorage);
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.lowSpeed));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileVelocity parameter to highSpeed")
    public void raiseProfileVelocity() {
        this.carrierController.changeProfileVelocity(this.highSpeed);
        this.profileVelocity = this.highSpeed;
        this.carrierMotionTimeout = (int)this.timeoutForGoingToStorage;
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.highSpeed));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileAcceleration parameter to highAcceleration")
    public void raiseProfileAcceleration() {
        this.carrierController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.highAcceleration);
        this.profileAcceleration = this.highAcceleration;
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.highAcceleration));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileAcceleration parameter to lowAcceleration")
    public void slowProfileAcceleration() {
        this.carrierController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.lowAcceleration);
        this.profileAcceleration = this.lowAcceleration;
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.lowAcceleration));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileAcceleration parameter to highAcceleration")
    public void raiseProfileDeceleration() {
        this.carrierController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.highDeceleration);
        this.profileDeceleration = this.highDeceleration;
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.highDeceleration));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileAcceleration parameter to lowAcceleration")
    public void slowProfileDeceleration() {
        this.carrierController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.lowDeceleration);
        this.profileDeceleration = this.lowDeceleration;
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.lowDeceleration));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="read ProfileVelocity parameter in carrierController CPU")
    public long readProfileVelocity() {
        return this.carrierController.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        return this.position == this.absoluteTargetPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carrier position in reading controller.")
    public void updatePosition() {
        this.position = this.carrierController.readPosition();
        this.publishData();
    }

    @Override
    public void updateCurrent() {
        this.current = this.carrierController.readCurrent();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="To update and display position for end user.Updates carrier position in reading controller and returns it.")
    public int readPosition() {
        this.updatePosition();
        return this.position;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.carrierController.checkFault();
            this.position = this.carrierController.readPosition();
            this.updateCurrent();
            this.loader.updateStateWithSensors();
            this.speed = this.carrierController.readVelocity();
            this.loader.checkFilterDistanceOpened();
        }
        catch (SDORequestException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, "error in updateStateWithSensorsToCheckIfActionIsCompleted: ", this.name, ex);
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (!this.loader.isCarrierMotionAllowedByPLC()) {
            throw new RejectedCommandException(this.name + " PLC does not allow carrier motion. Carrier Relay is OFF. Ckeck PLCLoaderPanel.");
        }
        this.carrierController.checkFault();
        this.checkAndChangeProfileVelocity();
        this.checkAndChangeProfileAcceleration();
        this.checkAndChangeProfileDeceleration();
        this.carrierController.enableAndWriteAbsolutePosition(this.absoluteTargetPosition);
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " ABORTING action " + action.toString() + " within delay " + delay));
        this.carrierController.quickStop();
        this.carrierController.goToSwitchOnDisabled();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " ENDING action " + action.toString()));
        this.carrierController.goToSwitchOnDisabled();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is STOPPING action " + action.toString() + " within delay " + delay));
        this.carrierController.stopPosition();
    }

    private void afterMotion() {
        this.checkPositionSensors();
        this.loader.updateFCSStateToReady();
        this.absoluteTargetPosition = 0;
    }

    public void checkPositionSensors() {
        String abortMessage = " Did you abort the loader carrier motion ?";
        if (this.absoluteTargetPosition == this.storagePosition && !this.isAtStorage()) {
            throw new FailedCommandException(this.name + ": storage sensors don't confirm carrier position." + abortMessage);
        }
        if (this.absoluteTargetPosition == this.engagedPosition && !this.isAtEngaged()) {
            throw new FailedCommandException(this.name + ": engaged sensors don't confirm carrier position." + abortMessage);
        }
        if (this.absoluteTargetPosition == this.handoffPosition && !this.isAtHandoff()) {
            throw new FailedCommandException(this.name + ": handoff sensors don't confirm carrier position." + abortMessage);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if hardware is ready to be started.")
    public void initializeHardware() {
        this.carrierController.checkInitialized();
        this.loader.updateStateWithSensors();
        try {
            this.updatePosition();
        }
        catch (SDORequestException ex) {
            String msg = this.name + ": couldn't update position";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(this.name, ex);
        }
        if (this.isCarrierAlmostAtPosition(this.handoffPosition) && !this.isAtHandoff()) {
            this.homingDone = this.handoffSensors.isInError();
            throw new FcsHardwareException(this.name + ": handoff sensors don't confirm position read on carrierController.");
        }
        if (this.isCarrierAlmostAtPosition(this.engagedPosition) && !this.isAtEngaged()) {
            this.homingDone = this.engagedSensors.isInError();
            throw new FcsHardwareException(this.name + ": engaged sensors don't confirm position read on carrierController.");
        }
        if (this.isCarrierAlmostAtPosition(this.storagePosition) && !this.isAtStorage()) {
            this.homingDone = this.storageSensors.isInError();
            throw new FcsHardwareException(this.name + ": storage sensors don't confirm position read on carrierController.");
        }
        this.initialized = true;
        this.loader.updateFCSStateToReady();
    }

    private boolean isCarrierAlmostAtPosition(int position) {
        return Math.abs(this.position - position) < this.deltaPosition;
    }

    protected boolean isCarrierApproachingHandoff() {
        return this.absoluteTargetPosition > this.handoffPosition - 5000 && this.position > this.handoffPosition - 5000;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.isInitialized()) {
            sb.append(" is INITIALIZED.");
        } else {
            sb.append(" is NOT INITIALIZED.");
        }
        return sb.toString();
    }

    public StatusDataPublishedByLoaderCarrier createStatusDataPublishedByLoaderCarrier() {
        StatusDataPublishedByLoaderCarrier status = new StatusDataPublishedByLoaderCarrier();
        status.setPosition(this.position);
        status.setSpeed(this.speed);
        status.setProfileVelocity(this.profileVelocity);
        status.setProfileAcceleration(this.profileAcceleration);
        status.setProfileDeceleration(this.profileDeceleration);
        status.setCurrent(this.current);
        status.setAtHandoff(this.isAtHandoff());
        status.setAtStorage(this.isAtStorage());
        status.setAtEngaged(this.isAtEngaged());
        status.setEngagedSensorOn(this.engagedSensors.isOn());
        status.setControllerInError(this.carrierController.isInError());
        status.setHomingDone(true);
        return status;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByLoaderCarrier status = this.createStatusDataPublishedByLoaderCarrier();
        KeyValueData kvd = new KeyValueData(this.path, (Serializable)status);
        this.subs.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.carrierController.isBooted()) {
            this.carrierController.goToSwitchOnDisabled();
        }
        FCSLOG.info((Object)(this.name + " is shutdown."));
    }
}

