/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FcsUtilsTest
extends FCSTestTemplate {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testForce2zero() {
        System.out.println("force2zero");
        Assert.assertEquals((long)32767L, (long)FcsUtils.force2zero((int)65535, (int)15));
        Assert.assertEquals((long)0L, (long)FcsUtils.force2zero((int)0, (int)15));
        Assert.assertEquals((long)0L, (long)FcsUtils.force2zero((int)0, (int)15));
        Assert.assertEquals((long)255L, (long)FcsUtils.force2zero((int)255, (int)15));
        Assert.assertEquals((long)255L, (long)FcsUtils.force2zero((int)255, (int)15));
        Assert.assertEquals((long)32767L, (long)FcsUtils.force2zero((int)Short.MAX_VALUE, (int)15));
        Assert.assertEquals((long)12287L, (long)FcsUtils.force2zero((int)45055, (int)15));
        Assert.assertEquals((long)32512L, (long)FcsUtils.force2zero((int)65280, (int)15));
        Assert.assertEquals((long)65280L, (long)FcsUtils.force2zero((int)65281, (int)0));
        for (int bit = 0; bit < 15; ++bit) {
            Assert.assertEquals((long)0L, (long)FcsUtils.force2zero((int)0, (int)bit));
        }
        Assert.assertEquals((long)0L, (long)FcsUtils.force2zero((int)1, (int)0));
        Assert.assertEquals((String)"UNE.force2zero(1)=3", (long)1L, (long)FcsUtils.force2zero((int)1, (int)1));
        Assert.assertEquals((long)2L, (long)FcsUtils.force2zero((int)2, (int)0));
        Assert.assertEquals((String)"DEUX.force2zero(1)=0", (long)0L, (long)FcsUtils.force2zero((int)2, (int)1));
    }

    @Test
    public void testForce2one() {
        int bit;
        System.out.println("force2one");
        Assert.assertEquals((long)65535L, (long)FcsUtils.force2one((int)65535, (int)15));
        Assert.assertEquals((long)32768L, (long)FcsUtils.force2one((int)0, (int)15));
        Assert.assertEquals((long)33023L, (long)FcsUtils.force2one((int)255, (int)15));
        Assert.assertEquals((long)65535L, (long)FcsUtils.force2one((int)Short.MAX_VALUE, (int)15));
        Assert.assertEquals((long)45055L, (long)FcsUtils.force2one((int)45055, (int)15));
        Assert.assertEquals((long)65280L, (long)FcsUtils.force2one((int)65280, (int)15));
        Assert.assertEquals((long)1L, (long)FcsUtils.force2one((int)0, (int)0));
        Assert.assertEquals((long)65281L, (long)FcsUtils.force2one((int)65280, (int)0));
        for (bit = 0; bit < 15; ++bit) {
            Assert.assertEquals((long)65535L, (long)FcsUtils.force2one((int)65535, (int)bit));
        }
        for (bit = 0; bit < 15; ++bit) {
            Assert.assertEquals((String)"FcsUtils.force2one(ZERO,bit) = 2**bit", (long)(1 << bit), (long)FcsUtils.force2one((int)0, (int)bit));
        }
        Assert.assertEquals((long)1L, (long)FcsUtils.force2one((int)1, (int)0));
        Assert.assertEquals((String)"UNE.force2one(1)=3", (long)3L, (long)FcsUtils.force2one((int)1, (int)1));
        Assert.assertEquals((String)"UNE.force2one(2)=3", (long)5L, (long)FcsUtils.force2one((int)1, (int)2));
        Assert.assertEquals((long)3L, (long)FcsUtils.force2one((int)2, (int)0));
        Assert.assertEquals((String)"DEUX.force2one(1)=2", (long)2L, (long)FcsUtils.force2one((int)2, (int)1));
        Assert.assertEquals((String)"DEUX.force2one(2)=6", (long)6L, (long)FcsUtils.force2one((int)2, (int)2));
        System.out.println("test AFFF.force2one");
        for (bit = 0; bit < 15; ++bit) {
            if (bit == 12) {
                Assert.assertEquals((long)49151L, (long)FcsUtils.force2one((int)45055, (int)bit));
                continue;
            }
            if (bit == 14) {
                Assert.assertEquals((long)61439L, (long)FcsUtils.force2one((int)45055, (int)bit));
                continue;
            }
            Assert.assertEquals((long)45055L, (long)FcsUtils.force2one((int)45055, (int)bit));
        }
    }

    @Test
    public void testCheckSocketName() {
        System.out.println("checkSocketName");
        String msg = "is a valid socket name - should NOT have raised exception:";
        String name = "";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "AC";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("AC" + msg + ex));
        }
        name = "socket1";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "socket2";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "socket5";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        msg = " is an invalid socket name - IllegalArgumentException should be raised.";
        name = "COUCOU";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "1";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket12";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socketb";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socketBidon";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket0";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket6";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
    }

    @Test
    public void testConvertInteger8() {
        System.out.println("** convertInteger8");
        long unsigned8 = 0L;
        int expResult = 0;
        byte result = FcsUtils.convertInteger8((long)unsigned8);
        Assert.assertEquals((String)"UNSIGNED8=0 => Value=0", (long)expResult, (long)result);
        unsigned8 = 255L;
        expResult = -1;
        result = FcsUtils.convertInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 255L;
        expResult = -1;
        result = FcsUtils.convertInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 127L;
        expResult = 127;
        result = FcsUtils.convertInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 128L;
        expResult = -128;
        result = FcsUtils.convertInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 129L;
        expResult = -127;
        result = FcsUtils.convertInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 254L;
        expResult = -2;
        result = FcsUtils.convertInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 253L;
        expResult = -3;
        result = FcsUtils.convertInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 65535L;
        try {
            FcsUtils.convertInteger8((long)unsigned8);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("FcsUtils.convertInteger8(0xFFFF) should fail. exception=" + ex);
        }
        unsigned8 = 256L;
        try {
            FcsUtils.convertInteger8((long)unsigned8);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("FcsUtils.convertInteger8(256) should fail. exception=" + ex);
        }
    }

    @Test
    public void testConvertToInteger16() {
        System.out.println("** convertToInteger16");
        long unsigned16 = 0L;
        int expResult = 0;
        short result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=0 =>INTEGER16=0", (long)expResult, (long)result);
        unsigned16 = 2356L;
        expResult = 2356;
        result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=2356 =>INTEGER16=2356", (long)expResult, (long)result);
        unsigned16 = 65342L;
        expResult = -194;
        result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=65342 =>INTEGER16=-194", (long)expResult, (long)result);
        unsigned16 = 32767L;
        expResult = Short.MAX_VALUE;
        result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=32767 =>INTEGER16=32767", (long)expResult, (long)result);
        unsigned16 = 32768L;
        expResult = Short.MIN_VALUE;
        result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=32768 =>INTEGER16=-32768", (long)expResult, (long)result);
        unsigned16 = 65535L;
        expResult = -1;
        result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=65535 =>INTEGER16=-1", (long)expResult, (long)result);
        unsigned16 = 65535L;
        expResult = -1;
        result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=0xFFFF =>INTEGER16=-1", (long)expResult, (long)result);
        unsigned16 = -400L;
        expResult = -400;
        result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=-400 =>INTEGER16=-400", (long)expResult, (long)result);
        unsigned16 = -20L;
        expResult = -20;
        result = FcsUtils.convertInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=-400 =>INTEGER16=-400", (long)expResult, (long)result);
        unsigned16 = 0xFFFFFFL;
        try {
            FcsUtils.convertInteger16((long)unsigned16);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("FcsUtils.convertToInteger16(0xFFFFFF) should fail. exception=" + ex);
        }
        unsigned16 = 65536L;
        try {
            FcsUtils.convertInteger16((long)unsigned16);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("FcsUtils.convertToInteger16(65536) should fail. exception=" + ex);
        }
    }

    @Test
    public void testComputeNewCurrentValue() {
        System.out.println("**computeNewCurrentValue");
        int stepHeight = 100;
        int currentValue = 200;
        int finalValue = 400;
        int expResult = 300;
        int result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 300;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 400;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 350;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 450;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 10000;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        finalValue = -500;
        currentValue = -1000;
        expResult = -900;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = -600;
        expResult = finalValue;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        stepHeight = -100;
        finalValue = 400;
        currentValue = 700;
        expResult = 600;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        currentValue = 200;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        currentValue = 450;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        finalValue = -500;
        currentValue = -700;
        expResult = -500;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        currentValue = -300;
        expResult = -400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        currentValue = -500;
        expResult = -500;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
    }

    @Test
    public void testReturnIndex() {
        System.out.println("returnIndex");
        int byteNumero = 0;
        int expResult = 24576;
        int result = FcsUtils.returnIndex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 3;
        expResult = 24576;
        result = FcsUtils.returnIndex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 4;
        expResult = 24577;
        result = FcsUtils.returnIndex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 7;
        expResult = 24577;
        result = FcsUtils.returnIndex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 8;
        expResult = 24578;
        result = FcsUtils.returnIndex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 11;
        expResult = 24578;
        result = FcsUtils.returnIndex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 12;
        expResult = 24579;
        result = FcsUtils.returnIndex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 13;
        expResult = 24579;
        result = FcsUtils.returnIndex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
    }

    @Test
    public void testReturnSubindex() {
        System.out.println("returnSubindex");
        int byteNumero = 0;
        int expResult = 1;
        int result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 1;
        expResult = 2;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 2;
        expResult = 3;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 3;
        expResult = 4;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 4;
        expResult = 1;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 5;
        expResult = 2;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 6;
        expResult = 3;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 7;
        expResult = 4;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 8;
        expResult = 1;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 8;
        expResult = 1;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 9;
        expResult = 2;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 10;
        expResult = 3;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 11;
        expResult = 4;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 12;
        expResult = 1;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 13;
        expResult = 2;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 14;
        expResult = 3;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
        byteNumero = 15;
        expResult = 4;
        result = FcsUtils.returnSubindex((int)byteNumero);
        Assert.assertEquals((long)expResult, (long)result);
    }
}

