/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselMain;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarousel;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class CarouselTest
extends FCSTestTemplate {
    private static Subsystem carouselSubsystem = null;
    private static CarouselMain main;
    private static Carousel carousel;
    private static CarouselSocket socket1;
    private static CarouselSocket socket2;
    private static CarouselSocket socket3;
    private static CarouselSocket socket4;
    private static CarouselSocket socket5;
    private static CarouselClamp clampXminus1;
    private static SimuCarouselClampController clampXminusController;
    private static SimuCarouselController carouselController;
    private static SimuTTC580 hyttc580;
    private static FilterManager filterManager;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("********************************************************************************");
        System.out.println("                   TESTS OF CAROUSEL IN STANDALONE MODE");
        System.out.println("********************************************************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.carousel.standalone", "true");
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"Carousel", (String)"serialNB:<alias>", (String)"carousel-simu");
        carouselSubsystem.startAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = carouselSubsystem.getComponentLookup();
        main = (CarouselMain)lookup.getTopComponentNode().getComponent();
        carousel = (SimuCarousel)lookup.getComponentByPath("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByPath("carouselController");
        clampXminusController = (SimuCarouselClampController)lookup.getComponentByPath("clampXminusController");
        hyttc580 = (SimuTTC580)lookup.getComponentByPath("hyttc580");
        filterManager = (FilterManager)lookup.getComponentByPath("filterManager");
        filterManager.init();
        socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
        socket2 = (CarouselSocket)lookup.getComponentByPath("socket2");
        socket3 = (CarouselSocket)lookup.getComponentByPath("socket3");
        socket4 = (CarouselSocket)lookup.getComponentByPath("socket4");
        socket5 = (CarouselSocket)lookup.getComponentByPath("socket5");
        clampXminus1 = (CarouselClamp)lookup.getComponentByPath("clampXminus1");
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF CAROUSEL IN STANDALONE MODE *************");
        System.out.println("*******************************************************************");
        if (carouselSubsystem != null) {
            carouselSubsystem.shutdownAgent();
            ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        }
        System.getProperties().remove("org.lsst.ccs.fcs.instance.carousel.standalone");
    }

    @Before
    public void setUp() throws FcsHardwareException, DriverException {
        System.out.println("################################################");
        System.out.println("###            CarouselTest                  ###");
        System.out.println("###  Go back to initial conditions:          ###");
        System.out.println("###   socket1 at STANDBY                     ###");
        System.out.println("###   carousel holding a filter at STANDBY   ###");
        System.out.println("###   socket at STANDBY CLAMPEDONFILTER      ###");
        System.out.println("################################################");
        ((AlertService)carouselSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
        hyttc580.simulateAllSocketCLAMPEDONFILTER();
        carouselController.simulateSWITCH_ON_DISABLED();
        carousel.updateStateWithSensors();
    }

    @Test
    public void testWriteCurrent() {
        System.out.println("*** test of method writeCurrent of class SimuCarouselClampController ***");
        int currentToUnlock = -4660;
        clampXminusController.writeCurrent(currentToUnlock);
        Assert.assertEquals((String)"clampXminus1 clamp state", (Object)FcsEnumerations.FilterClampState.UNCLAMPED_ON_FILTER, (Object)clampXminus1.getClampState());
    }

    @Test
    public void testIsHoldingFilter() {
        System.out.println("*** test of isHoldingFilterAtStandby ***");
        boolean atStandby = true;
        hyttc580.simulateClampIsUnlocked(atStandby, carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsUnlocked(atStandby, carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"carousel is NOT holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        System.out.println("Go back to initial conditions");
        int socketID = carousel.getSocketAtStandby().getId();
        hyttc580.simuSocketAtSandbyIsLocked((short)socketID);
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testCheckConditionForRotation() {
        System.out.println("*** test of checkConditionsForRotation");
        try {
            carousel.checkConditionsForRotation();
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("in initial conditions, rotation is allowed. No exception should be raised:" + ex));
        }
        System.out.println("Simulate clamps at STANDBY are UNLOCKED");
        short socketID = (short)carousel.getSocketAtStandby().getId();
        hyttc580.simuSocketIsUnlocked(true, socketID);
        carousel.updateStateWithSensors();
        String msg = "Clamps are UNLOCKED but filter is still there.";
        Assert.assertTrue((String)msg, (boolean)carousel.getSocketAtStandby().isUnclampedOnFilter());
        try {
            carousel.checkConditionsForRotation();
            Assert.fail((String)(msg + " checkConditionsForRotation should raise an Exception."));
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Carousel can't rotate because " + msg + ex);
        }
        System.out.println("Go back to initial conditions. simulate clamps at STANDBY are LOCKED");
        hyttc580.simuSocketAtSandbyIsLocked(socketID);
        carousel.updateStateWithSensors();
    }

    @Test
    public void testRotateSocketToStandby() {
        System.out.println("TEST rotateSocketToStandby");
        System.out.println("rotateSocketToStandby socket2");
        carousel.rotateSocketToStandby("socket2");
        Assert.assertEquals((String)"carousel position", (long)socket2.getStandbyPosition(), (long)carousel.getPosition());
        Assert.assertEquals((String)"socket at STANDBY id", (long)2L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket4");
        carousel.rotateSocketToStandby("socket4");
        Assert.assertEquals((String)"socket at STANDBY id", (long)4L, (long)carousel.getSocketAtStandby().getId());
        Assert.assertEquals((String)"carousel position", (long)socket4.getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("rotateSocketToStandby socket3");
        carousel.rotateSocketToStandby("socket3");
        Assert.assertEquals((String)"socket at STANDBY id", (long)3L, (long)carousel.getSocketAtStandby().getId());
        Assert.assertEquals((String)"carousel position", (long)socket3.getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("rotateSocketToStandby socket5");
        carousel.rotateSocketToStandby("socket5");
        Assert.assertEquals((String)"socket at STANDBY id", (long)5L, (long)carousel.getSocketAtStandby().getId());
        Assert.assertEquals((String)"carousel position", (long)socket5.getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("rotateSocketToStandby socket1");
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"carousel position", (long)socket1.getStandbyPosition(), (long)carousel.getPosition());
        Assert.assertEquals((String)"socket at STANDBY id", (long)1L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket3");
        carousel.rotateSocketToStandby("socket3");
        Assert.assertEquals((String)"socket at STANDBY id", (long)3L, (long)carousel.getSocketAtStandby().getId());
        Assert.assertEquals((String)"carousel position", (long)socket3.getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("rotateSocketToStandby socket5");
        carousel.rotateSocketToStandby("socket5");
        Assert.assertEquals((String)"socket at STANDBY id", (long)5L, (long)carousel.getSocketAtStandby().getId());
        Assert.assertEquals((String)"carousel position", (long)socket5.getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("rotateSocketToStandby socket1");
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"carousel position", (long)socket1.getStandbyPosition(), (long)carousel.getPosition());
        Assert.assertEquals((String)"socket at STANDBY id", (long)1L, (long)carousel.getSocketAtStandby().getId());
    }

    public void launchScript() throws Exception {
        System.out.println("************************************************");
        System.out.println("*** Launch Python SCRIPT carouselTest.py ***");
        System.out.println("************************************************");
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/carouselTest.py", (String[])new String[0]);
    }
}

