/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenPlutoGateway
extends PlutoGateway {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;

    @Override
    public void init() {
        super.init();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.SDO_ERROR.getAlert(this.name), alwaysClear);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the Gateway.")
    public void initializeAndCheckHardware() {
        this.checkBooted();
        try {
            FCSLOG.info(this.name + " BEGIN initializeHardware");
            this.configurePlutoGateway();
            this.initialized = true;
            FCSLOG.info(this.name + " is INITIALIZED.");
            FCSLOG.info(this.name + " END initializeHardware");
            this.publishData();
        }
        catch (FailedCommandException | SDORequestException ex) {
            throw new FcsHardwareException(this.name, ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configures this gateway for subsystem needs. If gateway's name contains loader it executes configureLoaderPlutoGatewayelse it executes configureAutochangerPlutoGateway.")
    public void configurePlutoGateway() {
        if (this.name.contains("loader")) {
            this.configureLoaderPlutoGateway();
        } else if (this.getName().startsWith("acSensors")) {
            this.configureAutochangerPlutoGateway();
        }
    }

    private void configureAutochangerPlutoGateway() {
        FCSLOG.info(this.name + " configureAutochangerGateway");
        this.writeSDO(8208, 1, 1, 0L);
        this.writeSDO(8209, 1, 2, 23L);
        this.writeSDO(8209, 2, 2, 4L);
        this.writeSDO(8210, 1, 2, 279L);
        this.writeSDO(8210, 2, 2, 323L);
    }

    private void configureLoaderPlutoGateway() {
        FCSLOG.info(this.name + " configureLoaderPlutoGateway");
        this.writeSDO(8208, 1, 1, 1L);
        this.writeSDO(8209, 1, 2, 1L);
        this.writeSDO(8209, 2, 2, 2L);
        this.writeSDO(8210, 1, 2, 3L);
        this.writeSDO(8194, 1, 1, 7L);
    }

    public void writeTransmissionType(int transmissionType) {
        this.writeSDO(8197, 1, 1, transmissionType);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return values read on the device.")
    public int[] readNewValues() {
        this.checkBooted();
        try {
            int lastBytePlusOne = 17;
            if ("loaderPlutoGateway".equals(this.getName())) {
                lastBytePlusOne = 15;
            }
            for (int byteNumero = 0; byteNumero < lastBytePlusOne; ++byteNumero) {
                int index = FcsUtils.returnIndex(byteNumero);
                int subindex = FcsUtils.returnSubindex(byteNumero);
                this.readValues[byteNumero] = (int)this.readSDO(index, subindex);
                if (byteNumero <= 0) continue;
                this.reReadValueInError(byteNumero, index, subindex);
            }
        }
        catch (SDORequestException ex) {
            String message = this.name + "=> ERROR IN READING SENSOR:";
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, message, this.name, (Exception)((Object)ex));
        }
        return this.readValues;
    }

    private void reReadValueInError(int i, int index, int subindex) {
        if (this.readValues[i] == this.readValues[i - 1]) {
            FCSLOG.info(this.name + " error in reading values for byte=" + i + ",index=0x" + Integer.toHexString(index) + ", subindex=" + subindex);
            FcsUtils.sleep(2, this.name);
            this.readValues[i] = (int)this.readSDO(index, subindex);
        }
    }
}

