/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.drivers.MonitorDeviceInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class TempMonitorDevice
extends Device
implements AlertRaiser {
    protected static final Logger FCSLOG = Logger.getLogger(TempMonitorDevice.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    double[] temperatures;
    MonitorDeviceInterface tempSensorsDevice;

    public TempMonitorDevice(MonitorDeviceInterface tempSensorsDevice) {
        this.tempSensorsDevice = tempSensorsDevice;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.s;
    }

    public void init() {
        super.init();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.tempSensorsDevice.getName()), alwaysClear);
    }

    public void postStart() {
        FCSLOG.fine(() -> this.name + " BEGIN postStart.");
        if (this.tempSensorsDevice.isBooted()) {
            this.initializePostStart();
        }
        FCSLOG.fine(() -> this.name + " END postStart.");
    }

    public void initializePostStart() {
        try {
            this.tempSensorsDevice.initialize();
            this.temperatures = new double[9];
            for (int i = 1; i < 9; ++i) {
                this.temperatures[i] = 0.0;
            }
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize temperature sensor device", this.tempSensorsDevice.getName(), (Exception)((Object)ex));
        }
    }

    public void initialize() {
        this.setOnline(true);
    }

    public double[] readTemperatures() {
        return this.temperatures;
    }

    protected void close() {
    }

    public double readChannel(int channelNO, int type) {
        double temp = this.temperatures[channelNO];
        try {
            temp = this.tempSensorsDevice.readChannel(channelNO);
        }
        catch (Exception ex) {
            FCSLOG.log(Level.WARNING, this.getName() + " : couldn't read temperatures", ex);
        }
        return temp;
    }
}

