/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.aiousb.USB_DIO_96;
import org.lsst.ccs.drivers.aiousb.USB_DIO_96_Interface;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class LoaderMain
extends MainModule
implements USB_DIO_96_Interface {
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loader")
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="autochanger")
    private FilterHolder autochanger;
    private USB_DIO_96_Interface usbdio96Card;

    @Override
    public void init() {
        ((AgentPropertiesService)this.subs.getAgentService(AgentPropertiesService.class)).setAgentProperty("org.lsst.ccs.subsystem.fcs.loader", "loader");
        super.init();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update loader state in reading the sensors.")
    public void updateStateWithSensors() {
        this.loader.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void initializeHardware() {
        this.loader.initializeHardware();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Connect the loader hardware.")
    public void connectLoader() {
        this.bridge.connectHardware();
        this.loader.postStart();
    }

    public void postStart() {
        this.connectLoader();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print the list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.bridge.printHardwareState());
        sb.append("\n ");
        sb.append(this.loader.printHardwareState());
        return sb.toString();
    }

    public void connectUSB_DIO_96card() {
        if (this.usbdio96Card == null) {
            this.usbdio96Card = new USB_DIO_96();
            try {
                ((USB_DIO_96)this.usbdio96Card).connect();
            }
            catch (DriverException ex) {
                throw new FcsHardwareException("Could not connect to DIO_USB_96. Check that a DIO_USB_96 is present on this HCU and connected throw a USB cable.", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new FcsHardwareException("Could not connect to DIO_USB_96.  because : " + ex.toString());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("\n").append(this.loader.toString());
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Print PLC loader signals read on card USB_DIO_96.")
    public String printUSBDIO96Signals() {
        this.connectUSB_DIO_96card();
        return this.usbdio96Card.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Simulate PLC signals that say there is no filter at HANDOFF (AP2 & AF0 & NOLOCKOUT).")
    public void simulateAutochangerEmpty() {
        this.connectUSB_DIO_96card();
        this.usbdio96Card.simulateAutochangerEmpty();
        FcsUtils.sleep(20, this.name);
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Simulate PLC signals that say there is a filter at HANDOFF and it is held (AP2 & AF3 & NOLOCKOUT).")
    public void simulateAutochangerHoldFilter() {
        this.connectUSB_DIO_96card();
        this.usbdio96Card.simulateAutochangerHoldFilter();
        FcsUtils.sleep(20, this.name);
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Load a filter into bench or storage box. Simulate signals coming from autochanger.", timeout=480000, autoAck=false)
    public void loadFilterIntoBenchOrStorageBox() {
        this.simulateAutochangerEmpty();
        if (this.loader.isClampedOnFilter() || this.loader.isClosedOnFilter()) {
            this.loader.moveFilterToHandoff();
        }
        this.simulateAutochangerHoldFilter();
        this.loader.openClampAndMoveEmptyToStorage();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Unload a filter from bench or storage box.", timeout=480000, autoAck=false)
    public void unloadFilterFromBenchOrStorageBox() {
        this.simulateAutochangerHoldFilter();
        if (this.loader.isEmpty()) {
            this.loader.moveEmptyToHandoffAndClose();
        }
        this.simulateAutochangerEmpty();
        this.loader.moveFilterToStorage();
    }
}

