/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderHook;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class LoaderClamp
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    private static final Logger FCSLOG = Logger.getLogger(LoaderClamp.class.getName());
    private final LoaderHook hook1;
    private final LoaderHook hook2;
    private final LoaderHook hook3;
    private final LoaderHook hook4;
    private final ForceSensor forceSensor0;
    private final ForceSensor forceSensor1;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="unclampedStatusSensor")
    private DigitalSensor unclampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="underClampedStatusSensor")
    private DigitalSensor underClampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="clampedStatusSensor")
    private DigitalSensor clampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="overClampedStatusSensor")
    private DigitalSensor overClampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private LoaderHook[] hooks;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/hooksController")
    private EPOSController hooksController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="canbus1")
    private BridgeToHardware loaderTcpProxy;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private FcsEnumerations.LockStatus forceStatus;
    @ConfigurationParameter(description="Trigger to know when action clamp is completed. If force sensor voltage is over this limit then action clamp is completed.", units="0.1 Volt", category="loader")
    private volatile int minClampedVoltage = 25;
    @ConfigurationParameter(description="timeout : if closing the clamp last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="loader")
    private volatile int timeoutForClosingHooks = 60000;
    @ConfigurationParameter(description="timeout : if closing strongly the clamp last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="loader")
    private volatile int timeoutForClampingHooks = 30000;
    @ConfigurationParameter(description="timeout : if opening the clamp last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="loader")
    private volatile int timeoutForOpeningHooks = 60000;
    private static final int TIMEOUT_FOR_MOVING_CLAMP = 60000;
    @ConfigurationParameter(description="target encoder absolute value in qc when hooks are CLOSED", category="loader")
    private volatile int absolutePositionToClose = 325000;
    @ConfigurationParameter(description="relative position in qc to unclamp when hooks are CLAMPED", category="loader")
    private volatile int relativePositionToUnclamp = -25000;
    @ConfigurationParameter(description="current to clamp hooks", units="mA", category="loader")
    private volatile int currentToClamp = 445;
    @ConfigurationParameter(description="current to open hooks", units="mA", category="loader")
    private volatile int currentToOpen = -200;
    @ConfigurationParameter(description="current to open hooks in homing mode", units="mA", category="loader")
    private volatile int currentThreshold = 300;
    private int positionToReach = 0;
    private volatile boolean homingDone = false;
    private int position;
    private int readCurrent;

    public LoaderClamp(LoaderHook hook1, LoaderHook hook2, LoaderHook hook3, LoaderHook hook4, ForceSensor forceSensor0, ForceSensor forceSensor1) {
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
        this.hooks = new LoaderHook[]{hook1, hook2, hook3, hook4};
        this.forceSensor0 = forceSensor0;
        this.forceSensor1 = forceSensor1;
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderClamp.class, this.path);
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderHook.class, this.path + "/statusPublishedByHook1");
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderHook.class, this.path + "/statusPublishedByHook2");
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderHook.class, this.path + "/statusPublishedByHook3");
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderHook.class, this.path + "/statusPublishedByHook4");
        this.registerAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS);
        this.registerAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS);
        this.registerAction(FcsEnumerations.MobileItemAction.OPENHOMINGLOADERHOOKS);
        this.registerAction(FcsEnumerations.MobileItemAction.UNCLAMPLOADERHOOKS);
    }

    public void init() {
        super.init();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.SDO_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    @Override
    public EPOSController getController() {
        return this.hooksController;
    }

    public int getRelativePositionToClose() {
        return this.absolutePositionToClose;
    }

    public int getRelativePositionToUnclamp() {
        return this.relativePositionToUnclamp;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Display position for end user.Do not read again controller.")
    public int getPosition() {
        return this.position;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if homing of loader clamp has been done.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CLOSED")
    public boolean isClosed() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if OPENED")
    public boolean isOpened() {
        return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CLAMPED")
    public boolean isClamped() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLAMPED;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if in ERROR or UNKNOWN.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Override
    public boolean myDevicesReady() {
        return this.loaderTcpProxy.allDevicesBooted();
    }

    public void postStart() {
        FCSLOG.info(this.name + " postStart");
        if (this.hooksController.isBooted()) {
            this.initializeController();
        }
    }

    public void initializeController() {
        try {
            this.hooksController.initializeAndCheckHardware();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize loader clamp controller", (Exception)((Object)ex));
        }
    }

    public void checkInitialized() {
        if (!this.hooksController.isInitialized()) {
            String msg = this.getName() + ": clamp is not initialized.";
            FCSLOG.severe(msg);
            throw new RejectedCommandException(msg);
        }
    }

    public void checkClamped() {
        if (!this.isClamped()) {
            throw new RejectedCommandException(this.name + " has to be CLAMPED");
        }
    }

    public void checkUnclamped() {
        if (this.isClamped()) {
            throw new RejectedCommandException(this.name + " has to be UNCLAMPED");
        }
    }

    public void checkClosed() {
        if (!this.isClosed()) {
            throw new RejectedCommandException(this.name + " has to be CLOSED");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open loader hooks and do homing with method Current Threshold Negative Speed.", timeout=60000)
    public void open() {
        this.loader.updateStateAndCheckSensors();
        this.loader.checkConditionsForOpeningHooks();
        this.executeAction(FcsEnumerations.MobileItemAction.OPENHOMINGLOADERHOOKS, this.timeoutForOpeningHooks);
        this.homingDone = true;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close loader hooks. Do a homing BEFORE the close action when at HANDOFF and AC holding filter.", timeout=60000)
    public void close() {
        this.loader.updateStateAndCheckSensors();
        this.loader.checkLoaderNotEmpty();
        if (this.isOpened() || this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL || this.lockStatus == FcsEnumerations.LockStatus.UNKNOWN) {
            this.doHomingIfPossible();
            if (!this.isHomingDone()) {
                throw new RejectedCommandException(this.getName() + " abort close action because homing could not be done.");
            }
            this.positionToReach = this.absolutePositionToClose;
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS, this.timeoutForClosingHooks);
        } else if (this.isClosed()) {
            FCSLOG.info(this.getName() + " is already CLOSED. Nothing to do.");
        } else {
            throw new RejectedCommandException(this.getName() + " has to be OPENED or IN_TRAVEL or UNKNOWN before a close action.");
        }
    }

    private void doHomingIfPossible() {
        if (this.loader.isAtHandoff() && this.loader.isAutochangerHoldingFilter()) {
            FCSLOG.info(this.name + " loader at HANFOFF; filter held by AC; about to do a homing before a close action.");
            this.open();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp to hold tightly a filter.", timeout=60000)
    public void clamp() {
        this.loader.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.loader.checkLoaderNotEmpty();
            this.loader.checkConditionsForClampingHooks();
            this.executeAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS, this.timeoutForClampingHooks);
            this.afterActionClamp();
        } else if (this.isClamped()) {
            FCSLOG.info(this.getName() + " is already CLAMPED. Nothing to do.");
        } else {
            throw new RejectedCommandException(this.getName() + " has to be CLOSED before a clamp action.");
        }
    }

    private void afterActionClamp() {
        if (this.overClampedStatusSensor.isOn()) {
            String msg = " force sensor value is higher than max force limit.";
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg);
            throw new FcsHardwareException(this.name + msg);
        }
        this.loader.updateFCSStateToReady();
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp to hold tightly a filter. Command to be executed to clamp a filter when carrier is between ENGAGED and STORAGE. Loader clamp must be CLOSED and not OVER_CLAMPED.", timeout=60000)
    public void recoveryClamp() {
        this.loader.updateStateAndCheckSensors();
        if (!this.isClosed()) {
            if (this.isClamped() || this.forceStatus == FcsEnumerations.LockStatus.OVER_CLAMPED) {
                throw new RejectedCommandException(this.getName() + " is already CLAMPED or OVER_CLAMPED. Nothing to do.");
            }
            throw new RejectedCommandException(this.getName() + " has to be CLOSED before a clamp action.");
        }
        this.loader.checkLoaderNotEmpty();
        this.loader.checkConditionsForRecoveryClampingHooks();
        this.executeAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS, this.timeoutForClampingHooks);
        this.afterActionClamp();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unclamp filter and return to CLOSED position.", timeout=60000)
    public void unclamp() {
        this.loader.updateStateAndCheckSensors();
        if (this.isClamped()) {
            this.loader.checkLoaderNotEmpty();
            this.loader.checkConditionsForUnclampingHooks();
            FCSLOG.info("position=" + this.position);
            FCSLOG.info("relativePositionToUnclamp=" + this.relativePositionToUnclamp);
            this.positionToReach = this.position + this.relativePositionToUnclamp;
            FCSLOG.info("positionToReach=" + this.positionToReach);
            this.executeAction(FcsEnumerations.MobileItemAction.UNCLAMPLOADERHOOKS, this.timeoutForClampingHooks);
        } else if (this.isClosed()) {
            FCSLOG.info(this.getName() + " is already CLOSED. Nothing to do.");
        } else {
            throw new RejectedCommandException(this.getName() + " has to be CLAMPED before an unclamp action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unclamp filter and go to CLOSED position and forceStatus = UNCLAMPED. Command to be used only for recovery when carrier is between ENGAGED and STORAGE.", timeout=60000)
    public void recoveryUnclamp() {
        this.loader.updateStateAndCheckSensors();
        if (!this.isClamped() || this.forceStatus == FcsEnumerations.LockStatus.UNCLAMPED || this.forceStatus == FcsEnumerations.LockStatus.UNDER_CLAMPED) {
            if (this.isClosed() || this.forceStatus == FcsEnumerations.LockStatus.UNCLAMPED || this.forceStatus == FcsEnumerations.LockStatus.UNDER_CLAMPED) {
                throw new RejectedCommandException(this.getName() + " is already CLOSED or UNCLAMPED. Nothing to do.");
            }
            throw new RejectedCommandException(this.getName() + " has to be CLAMPED before an unclamp action.");
        }
        this.loader.checkLoaderNotEmpty();
        this.loader.checkConditionsForRecoveryClampingHooks();
        FCSLOG.info("position=" + this.position);
        FCSLOG.info("relativePositionToUnclamp=" + this.relativePositionToUnclamp);
        this.positionToReach = this.position + this.relativePositionToUnclamp;
        FCSLOG.info("positionToReach=" + this.positionToReach);
        this.executeAction(FcsEnumerations.MobileItemAction.UNCLAMPLOADERHOOKS, this.timeoutForClampingHooks);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        boolean actionCompleted = false;
        if (action == FcsEnumerations.MobileItemAction.OPENHOMINGLOADERHOOKS) {
            actionCompleted = this.hooksController.isTargetReached() && this.isOpened();
        } else if (action == FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) {
            FCSLOG.info(this.name + " position = " + this.position);
            actionCompleted = this.hooksController.isTargetReached() && this.isPositionReached(this.positionToReach) && this.isClosed();
        } else if (action == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS) {
            actionCompleted = this.clampedStatusSensor.isOn() && this.forceSensor0.getVoltage() >= this.minClampedVoltage && this.forceSensor1.getVoltage() >= this.minClampedVoltage;
        } else if (action == FcsEnumerations.MobileItemAction.UNCLAMPLOADERHOOKS) {
            actionCompleted = this.isPositionReached(this.positionToReach) && !this.clampedStatusSensor.isOn() && this.hooksController.isTargetReached();
        }
        return actionCompleted;
    }

    private boolean isCurrentReached(int currentToReach) {
        int DELTA = 5;
        FCSLOG.finer(() -> "readCurrent=" + this.readCurrent + " currentToReached=" + currentToReach);
        return currentToReach - DELTA <= this.readCurrent && this.readCurrent <= currentToReach + DELTA;
    }

    private boolean isPositionReached(int positionToReach) {
        int DELTA = 5;
        FCSLOG.finer(() -> "position=" + this.position + " positionToReached=" + positionToReach);
        return positionToReach - DELTA <= this.position && this.position <= positionToReach + DELTA;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.hooksController.checkFault();
            this.loader.updateStateWithSensors();
        }
        catch (SDORequestException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, "error in updateStateWithSensorsToCheckIfActionIsCompleted: ", this.name, (Exception)((Object)ex));
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.hooksController.checkFault();
        if (null != action) {
            switch (action) {
                case OPENHOMINGLOADERHOOKS: {
                    this.hooksController.changeMode(EPOSEnumerations.EposMode.HOMING);
                    this.hooksController.writeParameter(EPOSEnumerations.Parameter.CurrentThresholdHomingMode, this.currentThreshold);
                    this.hooksController.writeParameter(EPOSEnumerations.Parameter.HomingMethod, -4);
                    this.hooksController.goToOperationEnable();
                    this.hooksController.writeControlWord(31);
                    break;
                }
                case CLOSELOADERHOOKS: {
                    this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                    this.hooksController.enableAndWriteAbsolutePosition(this.absolutePositionToClose);
                    break;
                }
                case CLAMPLOADERHOOKS: {
                    this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.hooksController.enableAndWriteCurrent((short)this.currentToClamp);
                    break;
                }
                case UNCLAMPLOADERHOOKS: {
                    this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                    this.hooksController.enableAndWriteRelativePosition(this.relativePositionToUnclamp);
                    break;
                }
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.finer(() -> this.name + " is ABORTING action " + action.toString() + " within delay " + delay);
        this.hooksController.quickStop();
        this.hooksController.goToSwitchOnDisabled();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.finer(() -> this.name + " is ENDING action " + action.toString());
        this.hooksController.goToSwitchOnDisabled();
        this.publishData();
        this.loader.updateFCSStateToReady();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.finer(() -> this.name + " is STOPPING action " + action.toString() + " within delay " + delay);
        this.hooksController.quickStop();
    }

    public void updateStateAndCheckSensors() {
        this.loader.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR, this.name);
    }

    void updateState() {
        for (LoaderHook hook : this.hooks) {
            hook.updateState();
        }
        this.updateForceStatus();
        if (this.oneHookInError()) {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
        } else if (this.allHooksInState(FcsEnumerations.LockStatus.OPENED)) {
            this.computeStatusHooksOpened();
        } else if (this.allHooksInState(FcsEnumerations.LockStatus.CLOSED)) {
            this.computeStatusHooksClosed();
        } else {
            this.lockStatus = this.allHooksInState(FcsEnumerations.LockStatus.INTRAVEL) ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN;
        }
        this.position = this.hooksController.readPosition();
        this.publishData();
    }

    private boolean oneHookInError() {
        boolean bool = false;
        for (LoaderHook hook : this.hooks) {
            bool = bool || hook.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
        }
        return bool;
    }

    private boolean allHooksInState(FcsEnumerations.LockStatus status) {
        boolean bool = true;
        for (LoaderHook hook : this.hooks) {
            bool = bool && hook.getLockStatus() == status;
        }
        return bool;
    }

    private void updateForceStatus() {
        this.forceStatus = this.unclampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.UNCLAMPED : (this.underClampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.UNDER_CLAMPED : (this.overClampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.OVER_CLAMPED : (this.clampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.CLAMPED : FcsEnumerations.LockStatus.ERROR)));
    }

    private void computeStatusHooksClosed() {
        this.lockStatus = this.clampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.CLAMPED : FcsEnumerations.LockStatus.CLOSED;
    }

    private void computeStatusHooksOpened() {
        this.lockStatus = this.forceStatus == FcsEnumerations.LockStatus.UNCLAMPED ? FcsEnumerations.LockStatus.OPENED : (this.forceStatus == FcsEnumerations.LockStatus.CLAMPED || this.forceStatus == FcsEnumerations.LockStatus.OVER_CLAMPED ? FcsEnumerations.LockStatus.ERROR : this.forceStatus);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp current in reading controller.")
    public void updateCurrent() {
        try {
            this.readCurrent = this.hooksController.readCurrent();
        }
        catch (SDORequestException ex) {
            FCSLOG.log(Level.WARNING, this.name + "=> ERROR IN READING CONTROLLER:", ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp position in reading controller.")
    public void updatePosition() {
        try {
            this.position = this.hooksController.readPosition();
        }
        catch (SDORequestException ex) {
            FCSLOG.log(Level.WARNING, this.name + "=> ERROR IN READING CONTROLLER:", ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="To update and display position for end user.Updates loader clamp position in reading controller and returns it.")
    public int readPosition() {
        this.updatePosition();
        return this.position;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.homingDone) {
            sb.append(" homing is DONE.");
        } else {
            sb.append(" homing is NOT DONE.");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/timeoutForClosingHooks=");
        sb.append(this.timeoutForClosingHooks);
        sb.append("/timeoutForClosingHooksStrongly=");
        sb.append(this.timeoutForClampingHooks);
        sb.append("/timeoutForOpeningHooks=");
        sb.append(this.timeoutForOpeningHooks);
        return sb.toString();
    }

    public StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp() {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setClampState(this.lockStatus);
        status.setForceSensorVoltage0(this.forceSensor0.getVoltage());
        status.setForceSensorVoltage1(this.forceSensor1.getVoltage());
        status.setForceClampedStatus(this.clampedStatusSensor.isOn());
        status.setForceUnclampedStatus(this.unclampedStatusSensor.isOn());
        status.setForceUnderClampedStatus(this.underClampedStatusSensor.isOn());
        status.setForceOverClampedStatus(this.overClampedStatusSensor.isOn());
        status.setAllHooksInStateCLOSED(this.allHooksInState(FcsEnumerations.LockStatus.CLOSED));
        status.setForceStatus(this.forceStatus);
        status.setHomingDone(this.homingDone);
        status.setControllerInError(this.hooksController.isInError());
        status.setStatusPublishedByHook1(this.hook1.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook2(this.hook2.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook3(this.hook3.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook4(this.hook4.createStatusDataPublishedByLoaderHook());
        return status;
    }

    @Override
    public void publishData() {
        KeyValueData kvd = new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByLoaderClamp());
        this.subs.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.hooksController.isBooted()) {
            this.hooksController.goToSwitchOnDisabled();
        }
        FCSLOG.info(this.name + " is shutdown.");
    }
}

