
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;

import java.util.logging.Logger;


/**
 *
 * @author virieux
 */
public class SimuCarouselSocket extends CarouselSocket {
    private static final Logger FCSLOG = Logger.getLogger(SimuCarouselSocket.class.getName());

    public SimuCarouselSocket(int id, CarouselClamp clampXminus, CarouselClamp clampXplus) {
        super(id, clampXminus, clampXplus);
    }

    /**
     * update field filterID to be used only with whole FCS. In standalone mode,
     * filters can't be removed neither loaded into carousel so filterID never
     * changes.
     */
    @Override
    public void updateFilterID() {
        if (this.isEmpty()) {
            filterID = 0;
        } else if (autochanger.isAtStandby() && autochanger.isHoldingFilter()) {
            filterID = autochanger.getFilterID();
        }
        FCSLOG.info(name + " filter ID = " + carousel.getSocketAtStandby().getFilterID());
    }

}
