
package org.lsst.ccs.subsystems.fcs.simulation;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.commons.annotations.LookupField;
import static org.lsst.ccs.commons.annotations.LookupField.Strategy.SIBLINGS;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;

/**
 *
 * @author virieux
 */
public class SimuCanOpenInterface implements CanOpenInterface {

    boolean firstSync = true;

    PDOData pdoData = new PDOData();

    @LookupField(strategy = SIBLINGS)
    private final List<PieceOfHardware> devices = new ArrayList<>();

    @Override
    public int getNodeId() {
        return 2;
    }

    @Override
    public void init(int master, String baud, String busName, int nodeID) {
        //nothing to be done for simulation
    }

    @Override
    public PDOData sync() throws DriverException {
        return pdoData;
    }

    /**
     * change pdoData to simulate a PDO
     * @param cobid
     * @param newValue
     */
    public void simulatePDOData(int cobid, long newValue) {
        pdoData.updatePDO(cobid, newValue);
    }

    @Override
    public int scan() {
        return 0;
    }


    @Override
    public String info(int nodeID) throws DriverException {

        // Finding the device serial number
        for(PieceOfHardware poh : devices) {
            if(nodeID == poh.getNodeID()) {
                return "info,"+Integer.toHexString(nodeID)+",,,,,"+poh.getSerialNB();
            }
        }
        return null;
    }

    @Override
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {

    }

    @Override
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        return 0L;
    }

    @Override
    public void setNMTStateStop(int nodeId) {

    }

    @Override
    public void resetNode(int nodeId) {

    }

    @Override
    public void quit() {

    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void addReceivedPDO(int cobId) throws DriverException {

    }

    @Override
    public void setEmergencyMessageListener(EmergencyMessageListener eml) throws DriverException {
        // unconfigured
    }

    @Override
    public void clearReceivedPDOs() throws DriverException {
        // nothing to do here in simulation
    }

    @Override
    public void setSdoTimeout(long to) throws DriverException {
        //no relevant in simulation
    }

    @Override
    public void setPdoTimeout(long to) throws DriverException {
        //no relevant in simulation
    }

    @Override
    public void setNMTStateOperational(int nodeId) throws DriverException {
        //no relevant in simulation
    }

    @Override
    public void setNMTStatePreOperational(int nodeId) throws DriverException {
        //no relevant in simulation
    }

    @Override
    public Instant getLastBeat(int id) {
        throw new UnsupportedOperationException("Not supported in simulation.");
    }

    @Override
    public int getLastState(int id) {
        throw new UnsupportedOperationException("Not supported in simulation.");
    }

    @Override
    public Set<Integer> getRegisteredPDOs() {
        throw new UnsupportedOperationException("Not supported in simulation.");
    }

    @Override
    public void setBootMessageListener(BootMessageListener bml) throws DriverException {
        throw new UnsupportedOperationException("Not supported in simulation.");
    }

    @Override
    public void addSlave(int s) {
        //no relevant in simulation
    }

    @Override
    public void addSlaves(int[] s) {
        //no relevant in simulation
    }

}
