
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.drivers.commons.DriverException;

import org.lsst.ccs.command.annotations.Command;

import org.lsst.ccs.subsystems.fcs.common.BridgeToLoader;

/**
 * A class for Loader when it's in whole Exchange System. Hardware can be
 * missing. Loader can be connected and disconnected.
 *
 * @author virieux
 */
public class LoaderCanOpenProxy extends CanOpenProxy implements BridgeToLoader {

    //masterNodeID = 9, busName = "1", baud = "125k"

    @Override
    public void start() {
        // nothing to be started automatically.
    }

    @Override
    public void postStart() {
        // nothing to be started automatically.
    }

    /**
     * This methods stops the CWrapper client, and the TCP server.
     */
    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL, description = "Disconnect the hardware. Used for loader disconnection.")
    @Override
    public void disconnectHardware() {
        try {
            FCSLOG.info(name + " disconnecting from CANbus. " + this.toString());
            // TODO we have to test if all the hardware is stopped before doing stopServer
            canInterface.quit();
            this.canbusConnected = false;
            initialize();
        } catch (DriverException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL, description = "Connect the hardware. Used for loader.")
    @Override
    public void connectHardware() {
        connectToCANbus();
        bootProcess();
        // for the GUI
        this.publishData();
    }

    @Override
    public void setPDOTimeout() {
        //nothing to be done here because in loader CANbus, there is no PDOs.
    }
}
