
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;

/**
 *
 * @author virieux
 */
public class SimuAutochanger extends Autochanger {

    @LookupField(strategy = LookupField.Strategy.TREE)
    private SimuAutochangerPlutoGateway acSensorsGateway;

    public SimuAutochanger(PlutoGatewayInterface plutoGateway) {
        super(plutoGateway);
    }

    /**
     * update filterOnTrucksID
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING_ROUTINE, description = "update filterOnTrucksID.")
    @Override
    public void updateFilterOnTrucksID() {
        //nothing to do in simulation as filterOnTrucksID is updated in commands :
        // simulateAutochangerIsEmpty and simulateFilterIDOnAutochanger
    }

    @Override
    public void moveEmptyFromStandbyToHandoff() {
        super.moveEmptyFromStandbyToHandoff();
        acSensorsGateway.simulateAutochangerIsEmpty();
    }

}
