/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.ArrayList;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClampSensor;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CarouselClamp
extends MobileItem
implements MovedByEPOSController {
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistenceService;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="canbus0")
    protected BridgeToHardware tcpProxy;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private static final boolean LOAD_OFFSET_SET_AT_STARTUP = true;
    private static final boolean SAVE_OFFSET_SET_AT_SHUTDOWN = true;
    private int id;
    private boolean available = true;
    protected EPOSController controller;
    private final SensorPluggedOnTTC580 filterPresenceSensor = new CarouselClampSensor();
    private final SensorPluggedOnTTC580 lockSensor = new CarouselClampSensor();
    private FcsEnumerations.FilterClampState clampState = FcsEnumerations.FilterClampState.UNDEFINED;
    private FcsEnumerations.FilterPresenceStatus filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    @ConfigurationParameter(description="value of current to send to controller to unlock carousel clamp", range="-6000..6000", units="mA", category="carousel")
    protected volatile int currentToUnlock = -4660;
    @Persist
    protected volatile Integer lockSensorOffset1 = 5000;
    protected Integer filterPresenceMinLimit = 200;
    @Persist
    protected volatile Integer filterPresenceOffset2 = 3000;
    @Deprecated
    @ConfigurationParameter(description="an offset for tests after carousel has been transported", range="0..1000", units="mV", category="carousel")
    protected volatile Integer filterPresenceOffset3 = 0;
    @ConfigurationParameter(range="0..12000", units="mV", category="carousel")
    private volatile Integer filterPresenceMaxValue = 12000;
    @ConfigurationParameter(range="0..10000", units="millisecond", category="carousel")
    protected volatile long timeoutForUnlocking = 1500L;
    @ConfigurationParameter(range="0..10000", units="millisecond", category="carousel")
    protected volatile long timeoutForReleasing = 1500L;
    private int velocity = 0;
    private ArrayList<String> sensorErrorCounter;

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByCarouselClamp.class, this.path);
        this.registerAction(FcsEnumerations.MobileItemAction.UNLOCK);
        this.registerAction(FcsEnumerations.MobileItemAction.RELEASE);
        String suffix = this.name.replace("clamp", "");
        ComponentLookup lookup = this.subs.getComponentLookup();
        ComponentNode thisNode = lookup.getComponentNodeForObject((Object)this);
        lookup.addComponentNodeToLookup(thisNode, new ComponentNode("filterPresence" + suffix, (Object)this.filterPresenceSensor));
        lookup.addComponentNodeToLookup(thisNode, new ComponentNode("lockSensor" + suffix, (Object)this.lockSensor));
    }

    public short getCurrentToUnlock() {
        return (short)this.currentToUnlock;
    }

    public ArrayList<String> getSensorErrorCounter() {
        return this.sensorErrorCounter;
    }

    protected void setController(EPOSController actuator) {
        this.controller = actuator;
    }

    public int getLockSensorOffset1() {
        return this.lockSensorOffset1;
    }

    public int getLockSensorMaxLimit() {
        if (this.isXminus()) {
            return this.carousel.getLockSensorMaxLimitXminus();
        }
        return this.carousel.getLockSensorMaxLimitXplus();
    }

    public int getLockSensorMinLimit() {
        if (this.isXminus()) {
            return this.carousel.getLockSensorMinLimitXminus();
        }
        return this.carousel.getLockSensorMinLimitXplus();
    }

    public int getFilterPresenceMinLimit() {
        return this.filterPresenceMinLimit;
    }

    public int getFilterPresenceOffset2() {
        return this.filterPresenceOffset2;
    }

    public SensorPluggedOnTTC580 getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public SensorPluggedOnTTC580 getLockSensor() {
        return this.lockSensor;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return the lockStatus")
    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return filterPresenceStatus")
    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public void setFilterPresenceOffset2(Integer value) {
        this.filterPresenceOffset2 = value;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void init() {
        this.persistenceService.setAutomatic(true, true);
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_LOCKING_ISSUE.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_SUCCESS.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_FAILURE.getAlert(this.name), alwaysClear);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CANopen hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.controller.isInitialized();
    }

    public FcsEnumerations.FilterClampState getClampState() {
        return this.clampState;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the clamp is locked")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    private boolean isAtStandby() {
        return this.carousel.getSocketAtStandbyID() == this.id;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if filter is engaged on the clamp : filter presence sensors sees it ")
    public boolean isFilterEngaged() {
        return this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.LOCKABLE;
    }

    public void checkAndUpdateOffset1(int newOffset1) {
        if (Math.abs(newOffset1 - this.lockSensorOffset1) > this.carousel.getMaxClampsOffsetDelta()) {
            this.lockSensorOffset1 = newOffset1;
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " offset1 has changed; new value = " + newOffset1, this.name);
        }
    }

    public void checkAndUpdateOffset2(int newOffset2) {
        if (Math.abs(newOffset2 - this.filterPresenceOffset2) > this.carousel.getMaxClampsOffsetDelta()) {
            this.filterPresenceOffset2 = newOffset2;
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " offset2 has changed; new value = " + newOffset2, this.name);
        }
    }

    public boolean isXminus() {
        return this.name.contains("Xminus");
    }

    public void updateFilterPresenceStatus() {
        int newFilterPresenceSensorValue = this.filterPresenceSensor.getValue();
        if (newFilterPresenceSensorValue < this.filterPresenceMinLimit) {
            if (this.carousel.isRotating()) {
                FCSLOG.info((Object)(this.name + String.format(this.name + " lost communication with TTC30 during rotation at position %d", this.carousel.getPosition())));
            } else if (this.available) {
                this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
                String errorMsg = this.name + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue + " must be >=" + this.filterPresenceMinLimit + " lost communication with TTC30 ?";
                this.sensorErrorCounter.add(errorMsg);
                this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, errorMsg, this.name);
            }
        } else if (newFilterPresenceSensorValue < this.filterPresenceOffset2 + this.filterPresenceOffset3) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.LOCKABLE;
        } else if (newFilterPresenceSensorValue < this.carousel.getFilterPresenceMinNoFilter()) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
        } else if (newFilterPresenceSensorValue < this.filterPresenceMaxValue) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOFILTER;
        } else if (this.available) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            String errorMsg = this.name + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue + " must be <=" + this.filterPresenceMaxValue;
            this.sensorErrorCounter.add(errorMsg);
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, errorMsg, this.name);
        }
    }

    public void updateLockStatus() {
        int mechaValue = this.lockSensor.getValue();
        if (mechaValue < this.getLockSensorMinLimit()) {
            if (this.carousel.isRotating()) {
                FCSLOG.info((Object)(this.name + String.format(this.name + " lost communication with TTC30 during rotation at position %d", this.carousel.getPosition())));
            } else if (this.available) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
                String errorMsg = this.name + " ERROR new read value FOR LOCK SENSOR  = " + mechaValue + " should be >= " + this.getLockSensorMinLimit() + " lost communication with TTC30 ?";
                this.sensorErrorCounter.add(errorMsg);
                this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, errorMsg, this.name);
            }
        } else if (mechaValue < this.lockSensorOffset1) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorOffset1 + 500 && this.isXminus()) {
            this.lockStatus = FcsEnumerations.LockStatus.RELAXED;
        } else if (mechaValue <= this.carousel.getMinLockedThreshold()) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.getLockSensorMaxLimit()) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else if (this.available) {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            String errorMsg = this.name + " ERROR new read value FOR LOCK SENSOR  = " + mechaValue + " should be <= " + this.getLockSensorMaxLimit();
            this.sensorErrorCounter.add(errorMsg);
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, errorMsg, this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        CarouselClamp carouselClamp = this;
        synchronized (carouselClamp) {
            this.sensorErrorCounter = new ArrayList();
            this.updateFilterPresenceStatus();
            this.updateLockStatus();
            this.computeClampState();
            this.updateVelocity();
        }
        this.publishData();
    }

    @Override
    public void publishData() {
        StatusDataPublishedByCarouselClamp status = this.createStatusDataPublishedByClamp();
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)status));
    }

    public StatusDataPublishedByCarouselClamp createStatusDataPublishedByClamp() {
        StatusDataPublishedByCarouselClamp status = new StatusDataPublishedByCarouselClamp();
        status.setClampState(this.clampState);
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        status.setFilterPositionSensorValue(this.filterPresenceSensor.getValue());
        status.setLockSensorValue(this.lockSensor.getValue());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorOffset1(this.lockSensorOffset1.intValue());
        status.setFilterPresenceMinLimit(this.filterPresenceMinLimit.intValue());
        status.setFilterPresenceOffset2(this.filterPresenceOffset2.intValue());
        return status;
    }

    private void computeClampState() {
        if (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.ERROR || this.lockStatus == FcsEnumerations.LockStatus.ERROR) {
            this.clampState = FcsEnumerations.FilterClampState.ERROR;
        } else if (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE) {
            this.clampState = FcsEnumerations.FilterClampState.UNLOCKABLE;
        } else if (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.LOCKABLE) {
            if (this.lockStatus == FcsEnumerations.LockStatus.LOCKED) {
                this.clampState = FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
            } else if (this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED) {
                this.clampState = FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
                FCSLOG.info((Object)(this.name + " to compute duration of unlockClamps time = " + System.currentTimeMillis()));
            } else {
                FCSLOG.fine((Object)(this.name + " is " + FcsEnumerations.FilterPresenceStatus.LOCKABLE + " and " + this.lockStatus + " lockValue = " + this.lockSensor.getValue() + " clampState = " + FcsEnumerations.FilterClampState.UNDEFINED));
                this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
            }
        } else if (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.NOFILTER) {
            if (this.lockStatus == FcsEnumerations.LockStatus.LOCKED) {
                this.clampState = FcsEnumerations.FilterClampState.READYTOCLAMP;
            } else if (this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED || this.lockStatus == FcsEnumerations.LockStatus.RELAXED) {
                this.clampState = FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
            } else {
                FCSLOG.fine((Object)(this.name + " is " + FcsEnumerations.FilterPresenceStatus.NOFILTER + " and " + this.lockStatus + " lockValue = " + this.lockSensor.getValue() + " clampState = " + FcsEnumerations.FilterClampState.UNDEFINED));
                this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
            }
        } else {
            FCSLOG.fine((Object)(this.name + " is " + this.filterPresenceStatus + " and " + this.lockStatus + " lockValue = " + this.lockSensor.getValue() + " clampState = " + FcsEnumerations.FilterClampState.UNDEFINED));
            this.clampState = FcsEnumerations.FilterClampState.UNDEFINED;
        }
    }

    @Command(level=3, type=Command.CommandType.ACTION, description="Release clamp in order to get ready to clamp a filter again")
    public void release() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("CarouselClamp-release");){
            FCSLOG.info((Object)("Checking conditions for release clamp " + this.name + " on socket at standby position."));
            this.carousel.updateSocketAtStandbyReadSensorsNoPublication();
            FCSLOG.info((Object)("Releasing clamp " + this.name + " on socket at standby position."));
            this.executeAction(FcsEnumerations.MobileItemAction.RELEASE, this.timeoutForUnlocking);
        }
        this.carousel.updateSocketAtStandbyWithSensors();
    }

    @Command(level=3, type=Command.CommandType.ACTION, description="Check if controller has been disabled. For end user.")
    public boolean isReleased() {
        return !this.controller.isEnabled();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamp")
    public void unlock() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("CarouselClamp-unlock");){
            FCSLOG.info((Object)(this.name + ": UNLOCK State1 = " + this.clampState.toString()));
            this.carousel.updateSocketAtStandbyReadSensorsNoPublication();
            if (this.isFilterEngaged() && this.autochanger.isAtStandby() && !this.autochanger.isHoldingFilter()) {
                throw new RejectedCommandException(this.name + "cannot unlock a clamp is FILTER is NOT HELD by autochanger.");
            }
            this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK, this.timeoutForUnlocking);
        }
        this.carousel.updateSocketAtStandbyState();
    }

    public void recoveryLocking() {
        this.raiseWarning(FcsEnumerations.FcsAlert.CA_LOCKING_ISSUE, String.format(this.name + " is not LOCKED : filter presence = %d lock value = %d about to do a recoveryLocking", this.filterPresenceSensor.getValue(), this.lockSensor.getValue()), this.name);
        this.controller.goToOperationEnable();
        this.controller.writeCurrent((short)this.carousel.getRecoveryLockingCurrent());
        try {
            this.waitForLocked();
        }
        finally {
            this.controller.goToSwitchOnDisabled();
        }
    }

    private void waitForLocked() {
        block15: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("CarouselClamp-waitForLocked");){
                long timeoutMillis = 1500L;
                long timeStart = System.currentTimeMillis();
                long duration = 0L;
                boolean state_ok = false;
                int updateRate = 50;
                while (!state_ok && duration <= timeoutMillis) {
                    FcsUtils.sleep(updateRate, this.name);
                    duration = System.currentTimeMillis() - timeStart;
                    this.tcpProxy.updatePDOData();
                    this.carousel.updateSocketAtStandbyState();
                    state_ok = this.isLocked();
                }
                if (state_ok) {
                    this.raiseWarning(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_SUCCESS, String.format(this.name + " filter presence = %d lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue()), this.name);
                    FCSLOG.info((Object)(this.name + String.format(" go to state LOCKED duration = %d", duration)));
                    break block15;
                }
                this.controller.goToSwitchOnDisabled();
                this.raiseWarning(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_FAILURE, String.format(this.name + " could not be LOCKED during allocated time, stop waiting.  filter presence = %d lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue()), this.name);
                FcsUtils.sleep(500, this.name);
                this.tcpProxy.updatePDOData();
                this.carousel.updateSocketAtStandbyState();
                if (this.isLocked()) {
                    this.raiseWarning(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_SUCCESS, String.format(this.name + " finally clamp is LOCKED after controller.goToSwitchOnDisabled. filter presence = %d lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue()), this.name);
                    FCSLOG.info((Object)(this.name + String.format(" go to state LOCKED duration = %d", duration)));
                    break block15;
                }
                String msg = this.name + " LOCKING RECOVERY FAILED ";
                String cause = this.velocity > this.carousel.getRecoveryMaxVelocity() ? String.format("Cause = controller velocity reached %d which is over limit %d", this.velocity, this.carousel.getRecoveryMaxVelocity()) : String.format("Cause = couldn't go to state LOCKED during time allocated of %d ms;", timeoutMillis);
                String msg_log = msg + cause + String.format("; filter presence value = %d lock value = %d", this.filterPresenceSensor.getValue(), this.lockSensor.getValue());
                this.raiseAlarm(FcsEnumerations.FcsAlert.CA_LOCKING_RECOVERY_FAILURE, msg_log, this.name);
                FCSLOG.error((Object)msg_log);
                throw new FcsHardwareException(msg);
            }
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCK) {
            this.controller.goToOperationEnable();
            int timeToPrepareUnlock = this.carousel.getTimeToPrepareUnlock();
            short currentToPrepareUnlock = (short)this.carousel.getCurrentToPrepareUnlock();
            this.controller.writeCurrent(currentToPrepareUnlock);
            FcsUtils.sleep(timeToPrepareUnlock, this.name);
            this.controller.writeCurrent((short)this.currentToUnlock);
        } else if (action == FcsEnumerations.MobileItemAction.RELEASE) {
            this.controller.goToSwitchOnDisabled();
        } else {
            throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCK) {
            return this.clampState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
        }
        if (action == FcsEnumerations.MobileItemAction.RELEASE) {
            return !this.controller.isInState(EPOSEnumerations.EposState.OPERATION_ENABLE);
        }
        throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.carousel.updateSocketAtStandbyReadSensorsNoPublication();
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        FCSLOG.debug((Object)(this.name + " NOTHING BEING DONE HERE"));
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        this.carousel.updateStateWithSensors();
        FCSLOG.debug((Object)(this.name + " NOTHING BEING DONE HERE"));
    }

    public void checkVelocity() {
        FCSLOG.info((Object)(this.name + " checking velocity; velocity = " + this.controller.getVelocity()));
        FcsUtils.checkAndWaitConditionWithTimeoutAndFixedDelay(() -> Math.abs(this.controller.getVelocity()) < 20, () -> this.tcpProxy.updatePDOData(), this.name + " check controller velocity is around 0 after unlock ", this.name + ": controller velocity is too high after trying every 100ms during 500 ms", 500L, 100L);
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet. Not relevant to stop action clamps.");
    }

    @Override
    public EPOSController getController() {
        return this.controller;
    }

    public void updateVelocity() {
        this.velocity = this.isAtStandby() ? this.controller.getVelocity() : 0;
    }

    public void postStart() {
        this.id = Integer.parseInt(this.name.substring(this.name.length() - 1));
        FCSLOG.info((Object)(this.name + " ID =" + this.id));
    }
}

