package org.lsst.ccs.subsystems.fcs.utils;

import java.util.concurrent.ConcurrentHashMap;

import static org.lsst.ccs.subsystems.fcs.utils.FcsUtils.FCSLOG;

public abstract class ActionGuard implements AutoCloseable {
    public abstract Runnable getPreAction();

    public abstract Runnable getPostAction();

    static ConcurrentHashMap<Class<? extends ActionGuard>, Integer> guards = new ConcurrentHashMap<>();

    static {
        FCSLOG.info("ActionGuard -- INIT -- 2021 11 26  01:00");
    }

    protected ActionGuard() {
        Integer i = guards.get(getClass());
        if (i == null)
            i = 0;
        i++;
        if (requiredEnclosure() == null || guards.containsKey(requiredEnclosure())) {
            if (i == 1) {
                FCSLOG.info("ActionGuard -- PRE ACTION " + this + " enclosure " + requiredEnclosure());
                getPreAction().run();
            } else {
                FCSLOG.info("ActionGuard -- enter, stacked i " + i);
            }
        }
        guards.put(getClass(), i);  // will not happen if getPreAction throws an exception, and this is what we want
    }

    public void close() {
        Integer i = guards.get(getClass());
        if (i == null)
            throw new RuntimeException("inconsistent behavior i is null");
        i--;
        if (i == 0) {
            try {
                if (requiredEnclosure() == null || guards.containsKey(requiredEnclosure())) {
                    FCSLOG.info("ActionGuard -- POST ACTION " + this + " enclosure " + requiredEnclosure());
                    getPostAction().run();
                } else {
                    FCSLOG.info("ActionGuard -- closing, noop no enclosure " + requiredEnclosure());
                }
            } finally {
                guards.remove(getClass());
            }
        } else {
            guards.put(getClass(), i); // should always happen, normal exit or exception
            FCSLOG.info("ActionGuard -- closing, stacked i " + i);
        }
    }

    public Class<? extends ActionGuard> requiredEnclosure() {
        return null;
    }

}
