
package org.lsst.ccs.subsystems.fcs.common;

import java.util.List;
import org.lsst.ccs.drivers.canopenjni.PDOData;

/**
 * This interface has to be implemented by classes which start a tcpip server to
 * communicate with real hardware or by classes which simulate the communication
 * with hardware.
 *
 * @author virieux
 */
public interface BridgeToHardware {

    void bootProcess();

    boolean isCanbusConnected();

    /**
     * This method is used when the loader CANbus is connected.
     */
    void connectHardware();

    /**
     * This methods stops the CWrapper client, and the TCP server.
     */
    void disconnectHardware();

    /**
     * Return a String with the list of hardware expected in this subsystem. For
     * debug purpose.
     *
     * @return
     */
    String printHardwareList();

    /**
     * Return an Array containing hardware names handled by this component.
     *
     * @return
     */
    List<String> listHardwareNames();

    /**
     * Return list of names of sensors plugged on AC pluto gateway.
     *
     * @return
     */
    List<String> listAcSensorsNames();

    /**
     *
     * @return list of names of sensors plugged on Loader pluto gateway.
     */
    List<String> listLoSensorsNames();

    /**
     * Return a printed list of hardware with the initialization state. For debug
     * purpose.
     *
     * @return
     */
    String printHardwareState();

    /**
     * Publish Data on status bus for trending data base and GUIs.
     */
    void publishData();

    /**
     * This method should return true when connection to hardware is effective and
     * all devices connected to that bridge have been correctly identified.
     *
     * @return
     */
    boolean isReady();

    /**
     * @return true if the hardware is booted, identified.
     */
    boolean allDevicesBooted();

    PDOData getPDOData();

    void updatePDOData();

    void doShutdown();

    public void checkControllers();

}
